/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.producer;

import hu.icellmobilsoft.coffee.dto.exception.BONotFoundException;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.module.etcd.config.DefaultEtcdConfigImpl;
import hu.icellmobilsoft.coffee.module.etcd.repository.EtcdRepository;
import hu.icellmobilsoft.coffee.module.etcd.service.ConfigEtcdService;
import hu.icellmobilsoft.coffee.module.etcd.service.EtcdService;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import io.etcd.jetcd.Client;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class DefaultEtcdConfigSource
implements ConfigSource {
    private static Logger log = Logger.getLogger(DefaultEtcdConfigSource.class);
    private static ConfigEtcdService configEtcdService;

    public int getOrdinal() {
        return 150;
    }

    public Map<String, String> getProperties() {
        try {
            return DefaultEtcdConfigSource.getConfigEtcdService().getAll();
        }
        catch (BaseException e) {
            log.error(MessageFormat.format("Error in getting all values from ETCD: [{0}]", e.getLocalizedMessage()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConfigEtcdService getConfigEtcdService() {
        if (configEtcdService != null) return configEtcdService;
        Class<DefaultEtcdConfigSource> clazz = DefaultEtcdConfigSource.class;
        synchronized (DefaultEtcdConfigSource.class) {
            if (configEtcdService != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return configEtcdService;
            }
            configEtcdService = DefaultEtcdConfigSource.createConfigEtcdService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configEtcdService;
        }
    }

    private static ConfigEtcdService createConfigEtcdService() {
        DefaultEtcdConfigImpl config = new DefaultEtcdConfigImpl();
        Client etcdClient = Client.builder().endpoints(config.getUrl()).build();
        EtcdRepository etcdRepository = new EtcdRepository();
        etcdRepository.init(etcdClient);
        EtcdService etcdService = new EtcdService();
        etcdService.init(etcdRepository);
        ConfigEtcdService local = new ConfigEtcdService();
        local.init(etcdService);
        return local;
    }

    public String getValue(String propertyName) {
        try {
            return this.readValue(propertyName).orElse(null);
        }
        catch (BaseException e) {
            log.error(MessageFormat.format("Error in getting value from ETCD by propertyName [{0}]: [{1}]", propertyName, e.getLocalizedMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.debug(MessageFormat.format("CDI is not initialized, property [{0}] is unresolvable from ETCD: [{1}]", propertyName, e.getLocalizedMessage()));
        }
        return null;
    }

    protected Optional<String> readValue(String propertyName) throws BaseException {
        return DefaultEtcdConfigSource.readEtcdValue(propertyName);
    }

    public static Optional<String> readEtcdValue(String propertyName) throws BaseException {
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return Optional.empty();
        }
        try {
            String value = DefaultEtcdConfigSource.getConfigEtcdService().getValue(propertyName);
            return Optional.of(value);
        }
        catch (BONotFoundException e) {
            log.trace(e.getLocalizedMessage());
            return Optional.empty();
        }
    }

    public String getName() {
        String urls = null;
        DefaultEtcdConfigImpl config = new DefaultEtcdConfigImpl();
        urls = Arrays.toString(config.getUrl());
        return MessageFormat.format("{0} class on urls: [{1}]", DefaultEtcdConfigSource.class.getSimpleName(), urls);
    }
}

