/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.producer;

import hu.icellmobilsoft.coffee.module.etcd.config.DefaultEtcdConfigImpl;
import hu.icellmobilsoft.coffee.module.etcd.repository.EtcdRepository;
import hu.icellmobilsoft.coffee.module.etcd.service.ConfigEtcdService;
import hu.icellmobilsoft.coffee.module.etcd.service.EtcdService;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import io.etcd.jetcd.Client;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;

@ApplicationScoped
public class DefaultEtcdFactory {
    private static Logger LOGGER = Logger.getLogger(DefaultEtcdFactory.class);
    @Inject
    private DefaultEtcdConfigImpl defaultEtcdConfigImpl;

    @ApplicationScoped
    @Produces
    public Client createEtcdClient() {
        Client etcdClient = null;
        try {
            etcdClient = Client.builder().endpoints(this.defaultEtcdConfigImpl.getUrl()).build();
        }
        catch (Exception e) {
            LOGGER.error("Problems trying to get the Etcd connection.", (Throwable)e);
        }
        return etcdClient;
    }

    public void closeEtcdClient(@Disposes Client etcdClient) {
        try {
            etcdClient.close();
            LOGGER.trace("etcdClient closed successfully");
        }
        catch (Exception e) {
            LOGGER.error("Error in closing etcd client: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Produces
    @Dependent
    public EtcdRepository createEtcdRepository() {
        EtcdRepository etcdRepository = new EtcdRepository();
        Client client = (Client)CDI.current().select(Client.class, new Annotation[0]).get();
        etcdRepository.init(client);
        return etcdRepository;
    }

    @Produces
    @Dependent
    public EtcdService createEtcdService() {
        EtcdService etcdService = new EtcdService();
        EtcdRepository etcdRepository = (EtcdRepository)CDI.current().select(EtcdRepository.class, new Annotation[0]).get();
        etcdService.init(etcdRepository);
        return etcdService;
    }

    public void disposeEtcdService(@Disposes EtcdService etcdService) {
        if (etcdService != null) {
            CDI.current().destroy((Object)etcdService.getEtcdRepository());
        }
    }

    @Produces
    @Dependent
    public ConfigEtcdService createConfigEtcdService() {
        ConfigEtcdService configEtcdService = new ConfigEtcdService();
        EtcdService etcdService = (EtcdService)CDI.current().select(EtcdService.class, new Annotation[0]).get();
        configEtcdService.init(etcdService);
        return configEtcdService;
    }

    public void disposeConfigEtcdService(@Disposes ConfigEtcdService configEtcdService) {
        if (configEtcdService != null) {
            CDI.current().destroy((Object)configEtcdService.getEtcdService());
        }
    }
}

