/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.producer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.module.etcd.producer.DefaultEtcdConfigSource;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class EtcdConfigSourceCache {
    public static final int CACHE_TIME_MINUTES = 30;
    private LoadingCache<String, Optional<String>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<String>>(){

        public Optional<String> load(String key) throws Exception {
            return DefaultEtcdConfigSource.readEtcdValue(key);
        }
    });

    private EtcdConfigSourceCache() {
    }

    public Optional<String> getValue(String propertyName) throws BaseException {
        try {
            return (Optional)this.cache.get((Object)propertyName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BaseException) {
                throw (BaseException)e.getCause();
            }
            throw new TechnicalException((Enum)CoffeeFaultType.SERVICE_CALL_FAILED, MessageFormat.format("Error in getting key [{0}] from ETCD", propertyName), (Throwable)e);
        }
    }

    public static EtcdConfigSourceCache instance() {
        return LazyHolder.INSTANCE;
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    private static class LazyHolder {
        public static final EtcdConfigSourceCache INSTANCE = new EtcdConfigSourceCache();

        private LazyHolder() {
        }
    }
}

