/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.repository;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.options.GetOption;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class EtcdRepository {
    private Client etcdClient;

    public void init(Client etcdClient) {
        this.etcdClient = etcdClient;
    }

    protected void checkInit() throws BaseException {
        if (this.etcdClient == null) {
            throw new TechnicalException("Etcd client is not initialized!");
        }
    }

    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value) throws BaseException {
        this.checkInit();
        try {
            return this.etcdClient.getKVClient().put(key, value);
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Exception in put key [" + key + "] and value [" + value + "] into etcd: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CompletableFuture<GetResponse> get(ByteSequence key) throws BaseException {
        this.checkInit();
        try {
            return this.etcdClient.getKVClient().get(key);
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Exception in get key [" + key + "] into etcd: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CompletableFuture<DeleteResponse> delete(ByteSequence key) throws BaseException {
        this.checkInit();
        try {
            return this.etcdClient.getKVClient().delete(key);
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Exception in deleting key [" + key + "] in etcd: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CompletableFuture<GetResponse> getList(ByteSequence startKey, ByteSequence endKey) throws BaseException {
        this.checkInit();
        try {
            return this.etcdClient.getKVClient().get(startKey, GetOption.newBuilder().withRange(endKey).build());
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Exception in getList startKey [" + startKey + "] into etcd: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Client getEtcdClient() {
        return this.etcdClient;
    }
}

