/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.service;

import hu.icellmobilsoft.coffee.dto.exception.BONotFoundException;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.module.etcd.repository.EtcdRepository;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.string.StringHelper;
import hu.icellmobilsoft.coffee.tool.utils.string.StringUtil;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Response;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

@Dependent
@Deprecated(since="1.3.0", forRemoval=true)
public class BaseEtcdService<T> {
    private static Logger log = Logger.getLogger(BaseEtcdService.class);
    @Inject
    private EtcdRepository etcdRepository;

    public T getEtcdData(String key, Class<T> c) throws BaseException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new BaseException("key is empty!");
        }
        try {
            ByteSequence bsKey = ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8);
            GetResponse response = this.etcdRepository.get(bsKey).get();
            if (response.getCount() < 1L) {
                throw new BONotFoundException(MessageFormat.format("Etcd data not found for key [{0}], response: [{1}]", key, response));
            }
            String stringData = ((KeyValue)response.getKvs().get(0)).getValue().toString(StandardCharsets.UTF_8);
            String responseStr = this.replaceSensitiveDataInReponseString((Response)response);
            log.trace("etcd: getting key [{0}], value [{1}], response: [{2}]", new Object[]{key, StringHelper.maskPropertyValue((String)key, (Object)stringData), responseStr});
            if (c == String.class) {
                return (T)stringData;
            }
            throw new TechnicalException("Type [" + c.getClass() + "] is not implemented yet!");
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Communication exception: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setEtcdData(String key, String value) throws BaseException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) {
            throw new BaseException("key or value is empty!");
        }
        try {
            ByteSequence bsKey = ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8);
            ByteSequence bsValue = ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8);
            PutResponse response = this.etcdRepository.put(bsKey, bsValue).get();
            String stringData = this.replaceSensitiveDataInReponseString((Response)response);
            log.trace("etcd: putting key [{0}], value [{1}] response: [{2}]", new Object[]{key, StringHelper.maskPropertyValue((String)key, (Object)value), stringData});
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Communication exception: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Map<String, T> getEtcdDataList(String startKeyStr, String endKeyStr) throws BaseException {
        log.debug(">> ExtEtcdService.getEtcdDataList()");
        HashMap<String, String> etcdDataList = new HashMap<String, String>();
        try {
            ByteSequence startKey = ByteSequence.from((String)startKeyStr, (Charset)StandardCharsets.UTF_8);
            ByteSequence endKey = ByteSequence.from((String)endKeyStr, (Charset)StandardCharsets.UTF_8);
            log.debug("etcd search: startKey : [{0}], endKey : [{1}]", new Object[]{startKeyStr, endKeyStr});
            GetResponse response = this.etcdRepository.getList(startKey, endKey).get();
            long kvsCount = response.getCount();
            int i = 0;
            while ((long)i < kvsCount) {
                String stringKey = ((KeyValue)response.getKvs().get(i)).getKey().toString(StandardCharsets.UTF_8);
                String stringValue = ((KeyValue)response.getKvs().get(i)).getValue().toString(StandardCharsets.UTF_8);
                log.debug("etcd: [{0}]. key : [{1}], value : [{2}]", new Object[]{i, stringKey, StringHelper.maskPropertyValue((String)stringKey, (Object)stringValue)});
                etcdDataList.put(stringKey, stringValue);
                ++i;
            }
            String responseStr = this.replaceSensitiveDataInReponseString((Response)response);
            log.debug("etcd: found [{0}] entry, response: [{1}]", new Object[]{kvsCount, responseStr});
            HashMap<String, String> hashMap = etcdDataList;
            return hashMap;
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Communication exception: " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            log.debug("<< ExtEtcdService.getEtcdDataList()");
        }
    }

    public void deleteEtcdData(String key, Class<T> c) throws BaseException {
        log.debug(">> ExtEtcdService.deleteEtcdData(key : [{0}])", new Object[]{key});
        try {
            ByteSequence keyToDelete = ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8);
            DeleteResponse deleteResponse = this.etcdRepository.delete(keyToDelete).get();
            long deletedCount = deleteResponse.getDeleted();
            if (deletedCount < 1L) {
                log.debug("etcd: delete key [{0}], keyNotFound NOT FOUND, response: [{1}]", new Object[]{key, deleteResponse});
                throw new BONotFoundException("Etcd data not found for key [" + key + "]!");
            }
            String responseStr = this.replaceSensitiveDataInReponseString((Response)deleteResponse);
            log.debug("etcd: found [{0}] entry deleted, response: [{1}]", new Object[]{deletedCount, responseStr});
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Communication exception: " + e.getLocalizedMessage(), (Throwable)e);
        }
        log.debug("<< ExtEtcdService.deleteEtcdData()");
    }

    private String replaceSensitiveDataInReponseString(Response response) {
        String[] sensitiveKeyPatterns;
        String responseText = String.valueOf(response);
        for (String sensitiveKeyPattern : sensitiveKeyPatterns = StringHelper.getSensitiveKeyPattern()) {
            String replacementRegex = "(kvs[\\S\\s]*?key:[\\s]*?\"(" + sensitiveKeyPattern + ")\"[\\S\\s]*?value:[\\s]*?)\"(.*?)\"";
            responseText = StringUtil.replaceAllIgnoreCase((String)responseText, (String)replacementRegex, (String)"$1\"*\"");
        }
        return responseText;
    }
}

