/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.service;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.module.etcd.service.EtcdService;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class ConfigEtcdService {
    private Logger log;
    private EtcdService etcdService;

    public void init(EtcdService etcdService) {
        this.etcdService = etcdService;
    }

    protected void checkInit() throws BaseException {
        if (this.etcdService == null) {
            throw new TechnicalException("EtcdRepository is not initialized!");
        }
    }

    public String getRawValue(String key) throws BaseException {
        this.checkInit();
        return this.etcdService.get(key).orElse("");
    }

    public String getValue(String key) throws BaseException {
        this.checkInit();
        HashSet<String> previousKeys = new HashSet<String>();
        return this.getValueWithCircleCheck(key, previousKeys);
    }

    public void putValue(String key, Object value) throws BaseException {
        this.checkInit();
        this.etcdService.set(key, value == null ? null : value.toString());
    }

    public Map<String, String> getAll() throws BaseException {
        this.checkInit();
        Map<String, Optional<String>> valueMap = this.etcdService.get(" ", "\u0000");
        return this.reMapOptional(valueMap);
    }

    protected Map<String, String> reMapOptional(Map<String, Optional<String>> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Optional<String>> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().orElse(""));
        }
        return result;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public Map<String, String> getList() throws BaseException {
        return this.getAll();
    }

    public Map<String, String> searchList(String startKey) throws BaseException {
        if (startKey == null) {
            return Collections.emptyMap();
        }
        this.checkInit();
        Object endKey = "\u0000";
        try {
            int strLastIndex = startKey.length() - 1;
            char lastChar = startKey.charAt(strLastIndex);
            lastChar = (char)(lastChar + '\u0001');
            endKey = startKey.substring(0, strLastIndex) + lastChar;
        }
        catch (Exception e) {
            this.log.debug("etcd: cannot increase last character of startKey [{0}]", new Object[]{startKey});
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, "Convert exception: " + e.getLocalizedMessage(), (Throwable)e);
        }
        Map<String, Optional<String>> valueMap = this.etcdService.get(startKey, (String)endKey);
        return this.reMapOptional(valueMap);
    }

    public Map<String, String> searchList(String[] startKeyArray) throws BaseException {
        HashMap<String, String> aggregatedMap = new HashMap<String, String>();
        for (String key : startKeyArray) {
            Map<String, String> configMAp = this.searchList(key);
            aggregatedMap.putAll(configMAp);
        }
        return aggregatedMap;
    }

    public void delete(String key) throws BaseException {
        this.checkInit();
        this.etcdService.delete(key);
    }

    protected String getValueWithCircleCheck(String key, Set<String> previousKeys) throws BaseException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new BaseException("key is empty!");
        }
        String value = this.getRawValue(key);
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"{") && StringUtils.endsWith((CharSequence)value, (CharSequence)"}")) {
            String newKey = value.substring(1, value.length() - 1);
            if (previousKeys.contains(newKey)) {
                throw new TechnicalException("Circle found in the chain for key [" + key + "]!");
            }
            previousKeys.add(newKey);
            return this.getValueWithCircleCheck(newKey, previousKeys);
        }
        return value;
    }

    public EtcdService getEtcdService() {
        return this.etcdService;
    }
}

