/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.service;

import hu.icellmobilsoft.coffee.dto.exception.BONotFoundException;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.module.etcd.repository.EtcdRepository;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.string.StringHelper;
import hu.icellmobilsoft.coffee.tool.utils.string.StringUtil;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Response;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Vetoed;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class EtcdService {
    private static Logger log = Logger.getLogger(EtcdService.class);
    public static final String STARTKEY = " ";
    public static final String ENDKEY = "\u0000";
    public static final String EMPTY_VALUE = "";
    private EtcdRepository etcdRepository;

    public void init(EtcdRepository etcdRepository) {
        this.etcdRepository = etcdRepository;
    }

    protected void checkInit() throws BaseException {
        if (this.etcdRepository == null) {
            throw new TechnicalException("EtcdRepository is not initialized!");
        }
    }

    public Optional<String> get(String key) throws BaseException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new TechnicalException((Enum)CoffeeFaultType.INVALID_INPUT, "key is empty!");
        }
        this.checkInit();
        try {
            ByteSequence bsKey = ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8);
            GetResponse response = this.etcdRepository.get(bsKey).get();
            if (response.getCount() < 1L) {
                throw new BONotFoundException(MessageFormat.format("Etcd data not found for key [{0}], response: [{1}]", key, response));
            }
            Optional<String> value = this.toOptional(((KeyValue)response.getKvs().get(0)).getValue());
            if (log.isTraceEnabled()) {
                String responseStr = this.replaceSensitiveDataInResponseString((Response)response);
                log.trace("etcd: getting key [{0}], value [{1}], response: [{2}]", new Object[]{key, value.isPresent() ? StringHelper.maskPropertyValue((String)key, (Object)value.get()) : "null", responseStr});
            }
            return value;
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Communication exception on Get [{0}] key: [{1}]", key, e.getLocalizedMessage());
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, msg, (Throwable)e);
        }
    }

    protected Optional<String> toOptional(ByteSequence byteSequence) {
        return byteSequence.isEmpty() ? Optional.empty() : Optional.of(byteSequence.toString(StandardCharsets.UTF_8));
    }

    public void set(String key, String value) throws BaseException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new TechnicalException((Enum)CoffeeFaultType.INVALID_INPUT, "key is empty!");
        }
        this.checkInit();
        try {
            ByteSequence bsKey = ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8);
            ByteSequence bsValue = ByteSequence.from((String)(value == null ? EMPTY_VALUE : value), (Charset)StandardCharsets.UTF_8);
            PutResponse response = this.etcdRepository.put(bsKey, bsValue).get();
            if (log.isTraceEnabled()) {
                String stringData = this.replaceSensitiveDataInResponseString((Response)response);
                log.trace("etcd: putting key [{0}], value [{1}] response: [{2}]", new Object[]{key, StringHelper.maskPropertyValue((String)key, (Object)value), stringData});
            }
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Communication exception on Set [{0}] key with [{1}] value: [{2}]", key, value, e.getLocalizedMessage());
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, msg, (Throwable)e);
        }
    }

    public Map<String, Optional<String>> get(String startKeyStr, String endKeyStr) throws BaseException {
        if (startKeyStr == null || endKeyStr == null) {
            throw new TechnicalException((Enum)CoffeeFaultType.INVALID_INPUT, "startKeyStr or endKeyStr is null!");
        }
        this.checkInit();
        try {
            HashMap<String, Optional<String>> etcdDataList = new HashMap<String, Optional<String>>();
            ByteSequence startKey = ByteSequence.from((String)startKeyStr, (Charset)StandardCharsets.UTF_8);
            ByteSequence endKey = ByteSequence.from((String)endKeyStr, (Charset)StandardCharsets.UTF_8);
            log.debug("etcd search: startKey: [{0}], endKey: [{1}]", new Object[]{startKeyStr, endKeyStr});
            GetResponse response = this.etcdRepository.getList(startKey, endKey).get();
            long kvsCount = response.getCount();
            int i = 0;
            while ((long)i < kvsCount) {
                String stringKey = ((KeyValue)response.getKvs().get(i)).getKey().toString(StandardCharsets.UTF_8);
                Optional<String> value = this.toOptional(((KeyValue)response.getKvs().get(i)).getValue());
                if (log.isTraceEnabled()) {
                    log.trace("etcd: [{0}]. key: [{1}], value: [{2}]", new Object[]{i, stringKey, value.isPresent() ? StringHelper.maskPropertyValue((String)stringKey, (Object)value.get()) : "null"});
                }
                etcdDataList.put(stringKey, value);
                ++i;
            }
            if (log.isTraceEnabled()) {
                String responseStr = this.replaceSensitiveDataInResponseString((Response)response);
                log.trace("etcd: found [{0}] entry, response: [{1}]", new Object[]{kvsCount, responseStr});
            }
            return etcdDataList;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Communication exception on Get list by [{0}] startKey and [{1}] endKey: [{2}]", startKeyStr, endKeyStr, e.getLocalizedMessage());
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, msg, (Throwable)e);
        }
    }

    public void delete(String key) throws BaseException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new TechnicalException((Enum)CoffeeFaultType.INVALID_INPUT, "key is empty!");
        }
        this.checkInit();
        try {
            ByteSequence keyToDelete = ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8);
            DeleteResponse deleteResponse = this.etcdRepository.delete(keyToDelete).get();
            long deletedCount = deleteResponse.getDeleted();
            if (deletedCount < 1L) {
                log.trace("etcd: delete key [{0}], key NOT FOUND, response: [{1}]", new Object[]{key, deleteResponse});
                throw new BONotFoundException("Etcd data not found for key [" + key + "]!");
            }
            if (log.isTraceEnabled()) {
                String responseStr = this.replaceSensitiveDataInResponseString((Response)deleteResponse);
                log.trace("etcd: delete key [{0}], key NOT FOUND, response: [{1}]", new Object[]{key, responseStr});
            }
            log.trace("etcd: found [{0}] entry deleted", new Object[]{deletedCount});
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Communication exception on Delete [{0}] key: [{1}]", key, e.getLocalizedMessage());
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, msg, (Throwable)e);
        }
    }

    private String replaceSensitiveDataInResponseString(Response response) {
        String[] sensitiveKeyPatterns;
        String responseText = String.valueOf(response);
        for (String sensitiveKeyPattern : sensitiveKeyPatterns = StringHelper.getSensitiveKeyPattern()) {
            String replacementRegex = "(kvs[\\S\\s]*?key:[\\s]*?\"(" + sensitiveKeyPattern + ")\"[\\S\\s]*?value:[\\s]*?)\"(.*?)\"";
            responseText = StringUtil.replaceAllIgnoreCase((String)responseText, (String)replacementRegex, (String)"$1\"*\"");
        }
        return responseText;
    }

    public EtcdRepository getEtcdRepository() {
        return this.etcdRepository;
    }
}

