/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.dookug.api.rest.builder;

import hu.icellmobilsoft.coffee.tool.gson.JsonUtil;
import hu.icellmobilsoft.coffee.tool.utils.marshalling.MarshallingUtil;
import hu.icellmobilsoft.dookug.schemas.document._1_0.rest.documentgenerate.ParametersDataType;
import hu.icellmobilsoft.dookug.schemas.document._1_0.rest.generator.saxon.SaxonGeneratorParametersData;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class ParametersDataBuilder {
    private ParametersDataType parametersData;

    public static ParametersDataBuilder newBuilder() {
        ParametersDataBuilder builder = new ParametersDataBuilder();
        builder.parametersData = new ParametersDataType();
        return builder;
    }

    public static ParametersDataType getSaxonParameters(byte[] fopConfig, byte[] xmlDataset, boolean isCompressed) {
        ParametersDataBuilder builder = new ParametersDataBuilder();
        SaxonGeneratorParametersData saxonParameters = new SaxonGeneratorParametersData().withFopConfig(fopConfig).withXmlDataset(xmlDataset).withXmlDatasetCompressed(Boolean.valueOf(isCompressed));
        builder.parametersData = new ParametersDataType();
        builder.withGeneratorParameters(saxonParameters);
        return builder.build();
    }

    public static ParametersDataType getSaxonParameters(byte[] fopConfig, byte[] xmlDataset) {
        return ParametersDataBuilder.getSaxonParameters(fopConfig, xmlDataset, false);
    }

    public static ParametersDataType getSaxonParameters(byte[] xmlDataset) {
        return ParametersDataBuilder.getSaxonParameters(null, xmlDataset);
    }

    public ParametersDataType build() {
        return this.parametersData;
    }

    public byte[] binaryBuild() {
        return MarshallingUtil.marshall((Object)this.parametersData).getBytes(StandardCharsets.UTF_8);
    }

    public ParametersDataBuilder withTemplateParameters(Object templateParameters) {
        if (templateParameters == null) {
            return this;
        }
        this.parametersData.setTemplateParameters(JsonUtil.toJson((Object)templateParameters).getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public ParametersDataBuilder withTemplateParameters(String templateParametersJson) {
        if (StringUtils.isBlank((CharSequence)templateParametersJson)) {
            return this;
        }
        this.parametersData.setTemplateParameters(templateParametersJson.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public ParametersDataBuilder withGeneratorParameters(SaxonGeneratorParametersData saxonParameters) {
        if (saxonParameters == null) {
            return this;
        }
        String saxonParametersXml = MarshallingUtil.marshall((Object)saxonParameters);
        this.parametersData.setGeneratorParameters(saxonParametersXml.getBytes(StandardCharsets.UTF_8));
        return this;
    }
}

