(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'zakadabar-stack-core', 'kotlinx-serialization-kotlinx-serialization-json-js-legacy', 'kotlinx-coroutines-core', 'kotlinx-serialization-kotlinx-serialization-core-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('zakadabar-stack-core'), require('kotlinx-serialization-kotlinx-serialization-json-js-legacy'), require('kotlinx-coroutines-core'), require('kotlinx-serialization-kotlinx-serialization-core-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'zakadabar-stack-blobs'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'zakadabar-stack-blobs'.");
    }if (typeof this['zakadabar-stack-core'] === 'undefined') {
      throw new Error("Error loading module 'zakadabar-stack-blobs'. Its dependency 'zakadabar-stack-core' was not found. Please, check whether 'zakadabar-stack-core' is loaded prior to 'zakadabar-stack-blobs'.");
    }if (typeof this['kotlinx-serialization-kotlinx-serialization-json-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'zakadabar-stack-blobs'. Its dependency 'kotlinx-serialization-kotlinx-serialization-json-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-json-js-legacy' is loaded prior to 'zakadabar-stack-blobs'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'zakadabar-stack-blobs'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'zakadabar-stack-blobs'.");
    }if (typeof this['kotlinx-serialization-kotlinx-serialization-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'zakadabar-stack-blobs'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' is loaded prior to 'zakadabar-stack-blobs'.");
    }root['zakadabar-stack-blobs'] = factory(typeof this['zakadabar-stack-blobs'] === 'undefined' ? {} : this['zakadabar-stack-blobs'], kotlin, this['zakadabar-stack-core'], this['kotlinx-serialization-kotlinx-serialization-json-js-legacy'], this['kotlinx-coroutines-core'], this['kotlinx-serialization-kotlinx-serialization-core-js-legacy']);
  }
}(this, function (_, Kotlin, $module$zakadabar_stack_core, $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy, $module$kotlinx_coroutines_core, $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var EntityCommInterface = $module$zakadabar_stack_core.zakadabar.core.comm.EntityCommInterface;
  var throwCCE = Kotlin.throwCCE;
  var getPropertyCallableRef = Kotlin.getPropertyCallableRef;
  var L0 = Kotlin.Long.ZERO;
  var L2147483647 = Kotlin.Long.fromInt(2147483647);
  var Unit = Kotlin.kotlin.Unit;
  var BoSchema_init = $module$zakadabar_stack_core.zakadabar.core.schema.BoSchema_init_lfp7xm$;
  var EntityBo = $module$zakadabar_stack_core.zakadabar.core.data.EntityBo;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var coerceAtLeast = Kotlin.kotlin.ranges.coerceAtLeast_dqglrj$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var getKClass = Kotlin.getKClass;
  var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
  var callCtor = $module$zakadabar_stack_core.zakadabar.core.util.callCtor_za3rmp$;
  var PropertyMetadata = Kotlin.PropertyMetadata;
  var ZkStringStore = $module$zakadabar_stack_core.zakadabar.core.resource.ZkStringStore;
  var throwUPAE = Kotlin.throwUPAE;
  var ZkElementMode = $module$zakadabar_stack_core.zakadabar.core.browser.ZkElementMode;
  var css = $module$zakadabar_stack_core.zakadabar.core.resource.css;
  var resource = $module$zakadabar_stack_core.zakadabar.core.resource;
  var ZkFlavour = $module$zakadabar_stack_core.zakadabar.core.resource.ZkFlavour;
  var ZkButton_init = $module$zakadabar_stack_core.zakadabar.core.browser.button.ZkButton_init_6zfbcd$;
  var getCallableRef = Kotlin.getCallableRef;
  var io = $module$zakadabar_stack_core.zakadabar.core.browser.util.io_g2bo5h$;
  var newInstance = $module$zakadabar_stack_core.zakadabar.core.browser.util.newInstance_1yb8b7$;
  var EntityId_init = $module$zakadabar_stack_core.zakadabar.core.data.EntityId_init_287e2$;
  var numberToLong = Kotlin.numberToLong;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var lastOrNull = Kotlin.kotlin.collections.lastOrNull_2p1efm$;
  var equals = Kotlin.equals;
  var capitalized = $module$zakadabar_stack_core.zakadabar.core.text.capitalized_pdl1vz$;
  var ZkConfirmDialog = $module$zakadabar_stack_core.zakadabar.core.browser.modal.ZkConfirmDialog;
  var EntityId = $module$zakadabar_stack_core.zakadabar.core.data.EntityId;
  var ZkFieldBase = $module$zakadabar_stack_core.zakadabar.core.browser.field.ZkFieldBase;
  var List = Kotlin.kotlin.collections.List;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Collection = Kotlin.kotlin.collections.Collection;
  var checkCountOverflow = Kotlin.kotlin.collections.checkCountOverflow_za3lpa$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var ZkElement = $module$zakadabar_stack_core.zakadabar.core.browser.ZkElement;
  var cssStyleSheet = $module$zakadabar_stack_core.zakadabar.core.resource.css.cssStyleSheet_rqrv27$;
  var ZkCssStyleSheet = $module$zakadabar_stack_core.zakadabar.core.resource.css.ZkCssStyleSheet;
  var ZkElementState = $module$zakadabar_stack_core.zakadabar.core.browser.ZkElementState;
  var toString = Kotlin.toString;
  var layout = $module$zakadabar_stack_core.zakadabar.core.browser.layout;
  var RuntimeException_init = Kotlin.kotlin.RuntimeException_init_pdl1vj$;
  var Json = $module$kotlinx_serialization_kotlinx_serialization_json_js_legacy.kotlinx.serialization.json.Json;
  var await_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.await_t11jrl$;
  var ListSerializer = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.builtins.ListSerializer_swdriu$;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var CommBase = $module$zakadabar_stack_core.zakadabar.core.comm.CommBase;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  BlobCreateState.prototype = Object.create(Enum.prototype);
  BlobCreateState.prototype.constructor = BlobCreateState;
  Strings.prototype = Object.create(ZkStringStore.prototype);
  Strings.prototype.constructor = Strings;
  ZkBlobField.prototype = Object.create(ZkFieldBase.prototype);
  ZkBlobField.prototype.constructor = ZkBlobField;
  ZkBlobFieldEntry.prototype = Object.create(ZkElement.prototype);
  ZkBlobFieldEntry.prototype.constructor = ZkBlobFieldEntry;
  ZkAttachmentEntry.prototype = Object.create(ZkBlobFieldEntry.prototype);
  ZkAttachmentEntry.prototype.constructor = ZkAttachmentEntry;
  ZkAttachmentsField.prototype = Object.create(ZkBlobField.prototype);
  ZkAttachmentsField.prototype.constructor = ZkAttachmentsField;
  BlobStyles.prototype = Object.create(ZkCssStyleSheet.prototype);
  BlobStyles.prototype.constructor = BlobStyles;
  ZkFullScreenImageView.prototype = Object.create(ZkElement.prototype);
  ZkFullScreenImageView.prototype.constructor = ZkFullScreenImageView;
  ZkImagePreview.prototype = Object.create(ZkBlobFieldEntry.prototype);
  ZkImagePreview.prototype.constructor = ZkImagePreview;
  ZkImagesField.prototype = Object.create(ZkBlobField.prototype);
  ZkImagesField.prototype.constructor = ZkImagesField;
  BlobComm.prototype = Object.create(CommBase.prototype);
  BlobComm.prototype.constructor = BlobComm;
  function BlobCommInterface() {
  }
  BlobCommInterface.prototype.byReference_vcfpzq$ = function (reference, disposition, continuation, callback$default) {
    if (disposition === void 0)
      disposition = null;
    return callback$default ? callback$default(reference, disposition, continuation) : this.byReference_vcfpzq$$default(reference, disposition, continuation);
  };
  BlobCommInterface.prototype.listByReference_vfp5nv$$default = function (reference, disposition, continuation) {
    return this.byReference_vcfpzq$(reference, disposition, continuation);
  };
  BlobCommInterface.prototype.listByReference_vfp5nv$ = function (reference, disposition, continuation, callback$default) {
    if (disposition === void 0)
      disposition = null;
    return callback$default ? callback$default(reference, disposition, continuation) : this.listByReference_vfp5nv$$default(reference, disposition, continuation);
  };
  BlobCommInterface.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'BlobCommInterface',
    interfaces: [EntityCommInterface]
  };
  function BlobBo() {
  }
  BlobBo.prototype.upload_za3rmp$ = function (data, continuation) {
    var tmp$;
    return this.comm().upload_b2ray6$(Kotlin.isType(tmp$ = this, BlobBo) ? tmp$ : throwCCE(), data, continuation);
  };
  BlobBo.prototype.download = function (continuation) {
    return this.comm().download_vfw297$(this.id, continuation);
  };
  function BlobBo$schema$lambda(this$BlobBo) {
    return function ($receiver) {
      $receiver.unaryPlus_jtogi3$(getPropertyCallableRef('disposition', 0, function ($receiver) {
        return $receiver.disposition;
      }.bind(null, this$BlobBo), function ($receiver, value) {
        $receiver.disposition = value;
      }.bind(null, this$BlobBo))).max_za3lpa$(200);
      $receiver.unaryPlus_jtogi3$(getPropertyCallableRef('name', 0, function ($receiver) {
        return $receiver.name;
      }.bind(null, this$BlobBo), function ($receiver, value) {
        $receiver.name = value;
      }.bind(null, this$BlobBo))).min_za3lpa$(1).max_za3lpa$(200);
      $receiver.unaryPlus_jtogi3$(getPropertyCallableRef('mimeType', 0, function ($receiver) {
        return $receiver.mimeType;
      }.bind(null, this$BlobBo), function ($receiver, value) {
        $receiver.mimeType = value;
      }.bind(null, this$BlobBo))).min_za3lpa$(1).max_za3lpa$(100);
      $receiver.unaryPlus_khjmlc$(getPropertyCallableRef('size', 0, function ($receiver) {
        return $receiver.size;
      }.bind(null, this$BlobBo), function ($receiver, value) {
        $receiver.size = value;
      }.bind(null, this$BlobBo))).min_s8cxhz$(L0).max_s8cxhz$(L2147483647);
      return Unit;
    };
  }
  BlobBo.prototype.schema = function () {
    return BoSchema_init(BlobBo$schema$lambda(this));
  };
  BlobBo.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'BlobBo',
    interfaces: [EntityBo]
  };
  function BlobBoCompanion(boNamespace) {
    this.boNamespace = boNamespace;
    this._comm_pmkiax$_0 = null;
  }
  BlobBoCompanion.prototype.makeComm_u6dhay$_0 = function () {
    var nc = makeBlobComm(this);
    this._comm_pmkiax$_0 = nc;
    return nc;
  };
  Object.defineProperty(BlobBoCompanion.prototype, 'comm', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this._comm_pmkiax$_0) != null ? tmp$ : this.makeComm_u6dhay$_0();
    },
    set: function (value) {
      this._comm_pmkiax$_0 = value;
    }
  });
  BlobBoCompanion.prototype.read_vfw297$ = function (id, continuation) {
    return this.comm.read_f0dtxn$(id, continuation);
  };
  BlobBoCompanion.prototype.delete_vfw297$ = function (id, continuation) {
    return this.comm.delete_f0dtxn$(id, continuation);
  };
  BlobBoCompanion.prototype.all = function (continuation) {
    return this.comm.all(continuation);
  };
  function Coroutine$allAsMap($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$allAsMap.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$allAsMap.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$allAsMap.prototype.constructor = Coroutine$allAsMap;
  Coroutine$allAsMap.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.comm.all(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var $receiver = this.result_0;
            var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver, 10)), 16);
            var destination = LinkedHashMap_init(capacity);
            var tmp$;
            tmp$ = $receiver.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              destination.put_xwzc9p$(element.id, element);
            }

            return destination;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  BlobBoCompanion.prototype.allAsMap = function (continuation_0, suspended) {
    var instance = new Coroutine$allAsMap(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  BlobBoCompanion.prototype.upload_g6mxm5$ = function (bo, data, callback, continuation) {
    return this.comm.upload_g6mxm5$(bo, data, callback, continuation);
  };
  BlobBoCompanion.prototype.download_vfw297$ = function (id, continuation) {
    return this.comm.download_vfw297$(id, continuation);
  };
  BlobBoCompanion.prototype.byReference_vcfpzq$ = function (reference, disposition, continuation) {
    if (disposition === void 0)
      disposition = null;
    return this.comm.byReference_vcfpzq$(reference, disposition, continuation);
  };
  BlobBoCompanion.prototype.listByReference_h9ylwk$ = function (reference, continuation) {
    return this.byReference_vcfpzq$(reference, void 0, continuation);
  };
  BlobBoCompanion.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BlobBoCompanion',
    interfaces: []
  };
  function BlobCreateState(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function BlobCreateState_initFields() {
    BlobCreateState_initFields = function () {
    };
    BlobCreateState$Starting_instance = new BlobCreateState('Starting', 0);
    BlobCreateState$Progress_instance = new BlobCreateState('Progress', 1);
    BlobCreateState$Done_instance = new BlobCreateState('Done', 2);
    BlobCreateState$Error_instance = new BlobCreateState('Error', 3);
    BlobCreateState$Abort_instance = new BlobCreateState('Abort', 4);
  }
  var BlobCreateState$Starting_instance;
  function BlobCreateState$Starting_getInstance() {
    BlobCreateState_initFields();
    return BlobCreateState$Starting_instance;
  }
  var BlobCreateState$Progress_instance;
  function BlobCreateState$Progress_getInstance() {
    BlobCreateState_initFields();
    return BlobCreateState$Progress_instance;
  }
  var BlobCreateState$Done_instance;
  function BlobCreateState$Done_getInstance() {
    BlobCreateState_initFields();
    return BlobCreateState$Done_instance;
  }
  var BlobCreateState$Error_instance;
  function BlobCreateState$Error_getInstance() {
    BlobCreateState_initFields();
    return BlobCreateState$Error_instance;
  }
  var BlobCreateState$Abort_instance;
  function BlobCreateState$Abort_getInstance() {
    BlobCreateState_initFields();
    return BlobCreateState$Abort_instance;
  }
  BlobCreateState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BlobCreateState',
    interfaces: [Enum]
  };
  function BlobCreateState$values() {
    return [BlobCreateState$Starting_getInstance(), BlobCreateState$Progress_getInstance(), BlobCreateState$Done_getInstance(), BlobCreateState$Error_getInstance(), BlobCreateState$Abort_getInstance()];
  }
  BlobCreateState.values = BlobCreateState$values;
  function BlobCreateState$valueOf(name) {
    switch (name) {
      case 'Starting':
        return BlobCreateState$Starting_getInstance();
      case 'Progress':
        return BlobCreateState$Progress_getInstance();
      case 'Done':
        return BlobCreateState$Done_getInstance();
      case 'Error':
        return BlobCreateState$Error_getInstance();
      case 'Abort':
        return BlobCreateState$Abort_getInstance();
      default:throwISE('No enum constant zakadabar.lib.blobs.data.BlobCreateState.' + name);
    }
  }
  BlobCreateState.valueOf_61zpoe$ = BlobCreateState$valueOf;
  function create$lambda(closure$func) {
    return function ($receiver) {
      closure$func($receiver);
      return Unit;
    };
  }
  function Coroutine$create(T_0_0, isT_0, RT_0_0, isRT_0, $receiver_0, content_0, func_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$T_0 = T_0_0;
    this.local$isT = isT_0;
    this.local$content = content_0;
    this.local$func = func_0;
  }
  Coroutine$create.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$create.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$create.prototype.constructor = Coroutine$create;
  Coroutine$create.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$_0;
            var instance_0 = this.local$isT(tmp$_0 = callCtor(get_js(getKClass(this.local$T_0)))) ? tmp$_0 : throwCCE();
            instance_0.schema().setDefaults();
            create$lambda(this.local$func)(instance_0);
            this.state_0 = 2;
            this.result_0 = instance_0.create(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.result_0.upload_za3rmp$(this.local$content, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function create(T_0_0, isT_0, RT_0_0, isRT_0, $receiver_0, content_0, func_0, continuation_0, suspended) {
    var instance = new Coroutine$create(T_0_0, isT_0, RT_0_0, isRT_0, $receiver_0, content_0, func_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  defineInlineFunction('zakadabar-stack-blobs.zakadabar.lib.blobs.data.create_97boww$', wrapFunction(function () {
    var Unit = Kotlin.kotlin.Unit;
    var getKClass = Kotlin.getKClass;
    var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
    var callCtor = _.$$importsForInline$$['zakadabar-stack-core'].zakadabar.core.util.callCtor_za3rmp$;
    var throwCCE = Kotlin.throwCCE;
    function create$lambda(closure$func) {
      return function ($receiver) {
        closure$func($receiver);
        return Unit;
      };
    }
    return function (T_0, isT, RT_0, isRT, $receiver, content, func, continuation) {
      var tmp$_0;
      var instance_0 = isT(tmp$_0 = callCtor(get_js(getKClass(T_0)))) ? tmp$_0 : throwCCE();
      instance_0.schema().setDefaults();
      create$lambda(func)(instance_0);
      Kotlin.suspendCall(instance_0.create(Kotlin.coroutineReceiver()));
      Kotlin.suspendCall(Kotlin.coroutineResult(Kotlin.coroutineReceiver()).upload_za3rmp$(content, Kotlin.coroutineReceiver()));
      return Kotlin.coroutineResult(Kotlin.coroutineReceiver());
    };
  }));
  function get_url($receiver) {
    return '/api/' + $receiver.getBoNamespace() + '/blob/content/' + $receiver.id;
  }
  var blobStrings;
  function Strings() {
    ZkStringStore.call(this);
    this.starting_zf0hw$_0 = this.provideDelegate_gz1gfe$('starting ...', this, Strings$starting_metadata);
    this.uploading_iob6y9$_0 = this.provideDelegate_gz1gfe$('uploading: ', this, Strings$uploading_metadata);
    this.uploadError_6viakp$_0 = this.provideDelegate_gz1gfe$('upload error', this, Strings$uploadError_metadata);
    this.uploadAbort_4qh8td$_0 = this.provideDelegate_gz1gfe$('upload aborted', this, Strings$uploadAbort_metadata);
  }
  var Strings$starting_metadata = new PropertyMetadata('starting');
  Object.defineProperty(Strings.prototype, 'starting', {
    configurable: true,
    get: function () {
      return this.starting_zf0hw$_0.getValue_lrcp0p$(this, Strings$starting_metadata);
    }
  });
  var Strings$uploading_metadata = new PropertyMetadata('uploading');
  Object.defineProperty(Strings.prototype, 'uploading', {
    configurable: true,
    get: function () {
      return this.uploading_iob6y9$_0.getValue_lrcp0p$(this, Strings$uploading_metadata);
    }
  });
  var Strings$uploadError_metadata = new PropertyMetadata('uploadError');
  Object.defineProperty(Strings.prototype, 'uploadError', {
    configurable: true,
    get: function () {
      return this.uploadError_6viakp$_0.getValue_lrcp0p$(this, Strings$uploadError_metadata);
    }
  });
  var Strings$uploadAbort_metadata = new PropertyMetadata('uploadAbort');
  Object.defineProperty(Strings.prototype, 'uploadAbort', {
    configurable: true,
    get: function () {
      return this.uploadAbort_4qh8td$_0.getValue_lrcp0p$(this, Strings$uploadAbort_metadata);
    }
  });
  Strings.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Strings',
    interfaces: [ZkStringStore]
  };
  function ZkBlobField(form, comm, reference, blobCountMax, disposition, blobClass, make, makeBlobCb) {
    if (reference === void 0)
      reference = null;
    if (blobCountMax === void 0)
      blobCountMax = null;
    if (disposition === void 0)
      disposition = null;
    if (blobClass === void 0)
      blobClass = null;
    if (make === void 0)
      make = null;
    if (makeBlobCb === void 0)
      makeBlobCb = make;
    ZkFieldBase.call(this, form, '');
    this.form = form;
    this.comm_lplms0$_0 = comm;
    this.reference_15j87n$_0 = reference;
    this.blobCountMax_atq47e$_0 = blobCountMax;
    this.disposition_jzlhof$_0 = disposition;
    this.blobClass_ytlusd$_0 = blobClass;
    this.make_luul7y$_0 = make;
    this.makeBlobCb_eix1fy$_0 = makeBlobCb;
    this.droparea_w06kyo$_0 = this.droparea_w06kyo$_0;
    this.readOnly_lt0r22$_0 = this.form.readOnly;
  }
  Object.defineProperty(ZkBlobField.prototype, 'comm', {
    get: function () {
      return this.comm_lplms0$_0;
    }
  });
  Object.defineProperty(ZkBlobField.prototype, 'reference', {
    get: function () {
      return this.reference_15j87n$_0;
    }
  });
  Object.defineProperty(ZkBlobField.prototype, 'blobCountMax', {
    get: function () {
      return this.blobCountMax_atq47e$_0;
    }
  });
  Object.defineProperty(ZkBlobField.prototype, 'disposition', {
    get: function () {
      return this.disposition_jzlhof$_0;
    }
  });
  Object.defineProperty(ZkBlobField.prototype, 'blobClass', {
    get: function () {
      return this.blobClass_ytlusd$_0;
    }
  });
  Object.defineProperty(ZkBlobField.prototype, 'make', {
    get: function () {
      return this.make_luul7y$_0;
    }
  });
  Object.defineProperty(ZkBlobField.prototype, 'makeBlobCb', {
    get: function () {
      return this.makeBlobCb_eix1fy$_0;
    }
  });
  Object.defineProperty(ZkBlobField.prototype, 'droparea', {
    configurable: true,
    get: function () {
      if (this.droparea_w06kyo$_0 == null)
        return throwUPAE('droparea');
      return this.droparea_w06kyo$_0;
    },
    set: function (droparea) {
      this.droparea_w06kyo$_0 = droparea;
    }
  });
  Object.defineProperty(ZkBlobField.prototype, 'readOnly', {
    configurable: true,
    get: function () {
      return this.readOnly_lt0r22$_0;
    },
    set: function (readOnly) {
      this.readOnly_lt0r22$_0 = readOnly;
    }
  });
  function ZkBlobField$onCreate$lambda$lambda$lambda$lambda$lambda($receiver) {
    $receiver.buildPoint.style.whiteSpace = 'nowrap';
    $receiver.unaryPlus_pdl1vz$(resource.localizedStrings.dropFilesHere);
    return Unit;
  }
  function ZkBlobField$onCreate$lambda$lambda$lambda$lambda($receiver) {
    $receiver.unaryPlus_57x8mj$(css.AlignItems.center);
    $receiver.unaryPlus_51iybo$(ZkButton_init(resource.ZkIcons.cloudUpload, ZkFlavour.Custom)).marginBottom_za3rmp$(10);
    $receiver.unaryPlus_y4uc6z$($receiver.div_ddb4j7$(void 0, ZkBlobField$onCreate$lambda$lambda$lambda$lambda$lambda));
    return Unit;
  }
  function ZkBlobField$onCreate$lambda$lambda$lambda($receiver) {
    $receiver.unaryPlus_y4uc6z$($receiver.column_ddb4j7$(get_blobStyles().imageDropAreaMessage, ZkBlobField$onCreate$lambda$lambda$lambda$lambda));
    return Unit;
  }
  function ZkBlobField$onCreate$lambda$lambda(this$ZkBlobField) {
    return function ($receiver) {
      $receiver.unaryPlus_y4uc6z$($receiver.div_ip079v$([get_blobStyles().imageDropArea], ZkBlobField$onCreate$lambda$lambda$lambda));
      $receiver.on_bzyv6u$('drop', getCallableRef('onDrop', function ($receiver, p1) {
        return $receiver.onDrop_9ojx7i$(p1), Unit;
      }.bind(null, this$ZkBlobField)));
      $receiver.on_bzyv6u$('dragover', getCallableRef('onDragOver', function ($receiver, p1) {
        return $receiver.onDragOver_9ojx7i$(p1), Unit;
      }.bind(null, this$ZkBlobField)));
      return Unit;
    };
  }
  function Coroutine$ZkBlobField$onCreate$lambda(this$ZkBlobField_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ZkBlobField = this$ZkBlobField_0;
    this.local$this$ZkBlobField_0 = void 0;
  }
  Coroutine$ZkBlobField$onCreate$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkBlobField$onCreate$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkBlobField$onCreate$lambda.prototype.constructor = Coroutine$ZkBlobField$onCreate$lambda;
  Coroutine$ZkBlobField$onCreate$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var $receiver = this.local$this$ZkBlobField.form.fields;
            var element = this.local$this$ZkBlobField;
            $receiver.add_11rb$(element);
            if (this.local$this$ZkBlobField.form.mode !== ZkElementMode.Create) {
              if ((tmp$ = this.local$this$ZkBlobField.reference) != null) {
                this.local$this$ZkBlobField_0 = this.local$this$ZkBlobField;
                this.state_0 = 2;
                this.result_0 = this.local$this$ZkBlobField_0.comm.byReference_vcfpzq$(tmp$, this.local$this$ZkBlobField_0.disposition, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                this.state_0 = 3;
                continue;
              }
            } else {
              this.state_0 = 4;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            var tmp$_0;
            tmp$_0 = this.result_0.iterator();
            while (tmp$_0.hasNext()) {
              var element_0 = tmp$_0.next();
              this.local$this$ZkBlobField_0.unaryPlus_51iybo$(this.local$this$ZkBlobField_0.makeEntry_k4iao6$(element_0));
            }

            this.state_0 = 3;
            continue;
          case 3:
            this.state_0 = 4;
            continue;
          case 4:
            this.local$this$ZkBlobField.droparea = this.local$this$ZkBlobField.zke_ddb4j7$(void 0, ZkBlobField$onCreate$lambda$lambda(this.local$this$ZkBlobField)).marginRight_za3rmp$(10).marginBottom_za3rmp$(10);
            this.local$this$ZkBlobField.unaryPlus_51iybo$(this.local$this$ZkBlobField.droparea);
            return this.local$this$ZkBlobField.updateDropArea(), Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkBlobField$onCreate$lambda(this$ZkBlobField_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$ZkBlobField$onCreate$lambda(this$ZkBlobField_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ZkBlobField.prototype.onCreate = function () {
    io(ZkBlobField$onCreate$lambda(this));
  };
  ZkBlobField.prototype.makeEntry_k4iao6$ = function (blob, state, callback$default) {
    if (state === void 0)
      state = null;
    return callback$default ? callback$default(blob, state) : this.makeEntry_k4iao6$$default(blob, state);
  };
  ZkBlobField.prototype.makeBlob_6d2hh8$ = function (file) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    if ((tmp$_0 = (tmp$ = this.makeBlobCb) != null ? tmp$(file) : null) != null) {
      return tmp$_0;
    }if ((tmp$_2 = (tmp$_1 = this.blobClass) != null ? newInstance(tmp$_1) : null) != null) {
      var tmp$_3;
      tmp$_2.id = EntityId_init();
      tmp$_2.reference = this.reference;
      tmp$_2.disposition = (tmp$_3 = this.disposition) != null ? tmp$_3 : '';
      tmp$_2.name = file.name;
      tmp$_2.mimeType = file.type;
      tmp$_2.size = numberToLong(file.size);
      return tmp$_2;
    }throw IllegalStateException_init('both blobClass and makeBlobCb is null');
  };
  ZkBlobField.prototype.onDragOver_9ojx7i$ = function (event) {
    event.preventDefault();
  };
  function Coroutine$ZkBlobField$onDrop$lambda$lambda(this$ZkBlobField_0, closure$bo_0, closure$file_0, closure$entry_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ZkBlobField = this$ZkBlobField_0;
    this.local$closure$bo = closure$bo_0;
    this.local$closure$file = closure$file_0;
    this.local$closure$entry = closure$entry_0;
  }
  Coroutine$ZkBlobField$onDrop$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkBlobField$onDrop$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkBlobField$onDrop$lambda$lambda.prototype.constructor = Coroutine$ZkBlobField$onDrop$lambda$lambda;
  Coroutine$ZkBlobField$onDrop$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$ZkBlobField.comm.upload_g6mxm5$(this.local$closure$bo, this.local$closure$file, getCallableRef('update', function ($receiver, p1, p2, p3) {
              return $receiver.update_kg59yq$(p1, p2, p3), Unit;
            }.bind(null, this.local$closure$entry)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkBlobField$onDrop$lambda$lambda(this$ZkBlobField_0, closure$bo_0, closure$file_0, closure$entry_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$ZkBlobField$onDrop$lambda$lambda(this$ZkBlobField_0, closure$bo_0, closure$file_0, closure$entry_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$ZkBlobField$onDrop$lambda(closure$file_0, this$ZkBlobField_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$file = closure$file_0;
    this.local$this$ZkBlobField = this$ZkBlobField_0;
  }
  Coroutine$ZkBlobField$onDrop$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkBlobField$onDrop$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkBlobField$onDrop$lambda.prototype.constructor = Coroutine$ZkBlobField$onDrop$lambda;
  Coroutine$ZkBlobField$onDrop$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$ZkBlobField.makeBlob_6d2hh8$(this.local$closure$file).create(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var bo = this.result_0;
            var entry = this.local$this$ZkBlobField.makeEntry_k4iao6$(bo, BlobCreateState$Starting_getInstance());
            var tmp$ = this.local$this$ZkBlobField;
            var $this = this.local$this$ZkBlobField;
            var tmp$_0;
            var kClass = getKClass(ZkBlobFieldEntry);
            var $receiver = $this.childElements;
            var destination = ArrayList_init();
            var tmp$_0_0;
            tmp$_0_0 = $receiver.iterator();
            while (tmp$_0_0.hasNext()) {
              var element = tmp$_0_0.next();
              if (kClass.isInstance_s8jyv4$(element))
                destination.add_11rb$(element);
            }

            tmp$.insertAfter_8wlgjg$(entry, lastOrNull(Kotlin.isType(tmp$_0 = destination, List) ? tmp$_0 : throwCCE()));
            this.local$this$ZkBlobField.updateDropArea();
            return io(ZkBlobField$onDrop$lambda$lambda(this.local$this$ZkBlobField, bo, this.local$closure$file, entry));
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkBlobField$onDrop$lambda(closure$file_0, this$ZkBlobField_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$ZkBlobField$onDrop$lambda(closure$file_0, this$ZkBlobField_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ZkBlobField.prototype.onDrop_9ojx7i$ = function (event) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    event.stopPropagation();
    event.preventDefault();
    if (!this.allowUpload()) {
      window.alert(resource.localizedStrings.cannotAddMore);
      return;
    }if (!Kotlin.isType(event, DragEvent))
      return;
    tmp$ = event.dataTransfer;
    if (tmp$ == null) {
      return;
    }var dataTransfer = tmp$;
    tmp$_0 = dataTransfer.items.length;
    for (var index = 0; index <= tmp$_0; index++) {
      tmp$_1 = dataTransfer.items[index];
      if (tmp$_1 == null) {
        continue;
      }var item = tmp$_1;
      if (equals(item.kind, 'file')) {
        tmp$_2 = item.getAsFile();
        if (tmp$_2 == null) {
          continue;
        }var file = tmp$_2;
        io(ZkBlobField$onDrop$lambda(file, this));
      }}
  };
  ZkBlobField.prototype.allowUpload = function () {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$ = this.blobCountMax) != null) {
      var $receiver = this.childElements;
      var count$result;
      count$break: do {
        var tmp$_2;
        if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
          count$result = 0;
          break count$break;
        }var count = 0;
        tmp$_2 = $receiver.iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          if (Kotlin.isType(element, ZkBlobFieldEntry))
            checkCountOverflow((count = count + 1 | 0, count));
        }
        count$result = count;
      }
       while (false);
      tmp$_1 = (tmp$ - count$result | 0) > 0;
    } else
      tmp$_1 = null;
    return (tmp$_0 = tmp$_1) != null ? tmp$_0 : true;
  };
  ZkBlobField.prototype.updateDropArea = function () {
    if (this.allowUpload()) {
      this.droparea.show();
    } else {
      this.droparea.hide();
    }
  };
  function Coroutine$onDelete_vhhjuh$($this, preview_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$preview = preview_0;
  }
  Coroutine$onDelete_vhhjuh$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onDelete_vhhjuh$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onDelete_vhhjuh$.prototype.constructor = Coroutine$onDelete_vhhjuh$;
  Coroutine$onDelete_vhhjuh$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = (new ZkConfirmDialog(capitalized(resource.localizedStrings.confirmation), resource.localizedStrings.confirmDelete)).run(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.result_0) {
              return false;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 3:
            if (this.$this.form.mode !== ZkElementMode.Create) {
              this.state_0 = 4;
              this.result_0 = this.$this.comm.delete_f0dtxn$(this.local$preview.bo.id, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 5;
              continue;
            }

          case 4:
            this.state_0 = 5;
            continue;
          case 5:
            this.$this.minusAssign_51iyc4$(this.local$preview);
            this.$this.updateDropArea();
            return true;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ZkBlobField.prototype.onDelete_vhhjuh$ = function (preview_0, continuation_0, suspended) {
    var instance = new Coroutine$onDelete_vhhjuh$(this, preview_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ZkBlobField.prototype.onValidated_rhoczr$ = function (report) {
  };
  function Coroutine$onCreateSuccess_i71di$($this, created_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$created = created_0;
  }
  Coroutine$onCreateSuccess_i71di$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$onCreateSuccess_i71di$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$onCreateSuccess_i71di$.prototype.constructor = Coroutine$onCreateSuccess_i71di$;
  Coroutine$onCreateSuccess_i71di$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var kClass = getKClass(ZkBlobFieldEntry);
            var $receiver = this.$this.childElements;
            var destination = ArrayList_init();
            var tmp$_0;
            tmp$_0 = $receiver.iterator();
            while (tmp$_0.hasNext()) {
              var element = tmp$_0.next();
              if (kClass.isInstance_s8jyv4$(element))
                destination.add_11rb$(element);
            }

            this.local$tmp$ = (Kotlin.isType(tmp$ = destination, List) ? tmp$ : throwCCE()).iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var element_0 = this.local$tmp$.next();
            var tmp$_1;
            element_0.bo.reference = Kotlin.isType(tmp$_1 = this.local$created.id, EntityId) ? tmp$_1 : throwCCE();
            this.state_0 = 3;
            this.result_0 = element_0.bo.update(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  ZkBlobField.prototype.onCreateSuccess_i71di$ = function (created_0, continuation_0, suspended) {
    var instance = new Coroutine$onCreateSuccess_i71di$(this, created_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  ZkBlobField.prototype.blobs = function () {
    var tmp$;
    var kClass = getKClass(ZkImagePreview);
    var $receiver = this.childElements;
    var destination = ArrayList_init();
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      if (kClass.isInstance_s8jyv4$(element))
        destination.add_11rb$(element);
    }
    var $receiver_0 = Kotlin.isType(tmp$ = destination, List) ? tmp$ : throwCCE();
    var destination_0 = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
    var tmp$_1;
    tmp$_1 = $receiver_0.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      destination_0.add_11rb$(item.bo);
    }
    return destination_0;
  };
  ZkBlobField.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ZkBlobField',
    interfaces: [ZkFieldBase]
  };
  function ZkBlobFieldEntry(bo, createState, progress, size, onDelete) {
    if (createState === void 0)
      createState = null;
    if (progress === void 0)
      progress = null;
    if (size === void 0)
      size = 200;
    if (onDelete === void 0)
      onDelete = ZkBlobFieldEntry_init$lambda;
    ZkElement.call(this);
    this.bo = bo;
    this.createState = createState;
    this.progress = progress;
    this.size = size;
    this.onDelete = onDelete;
  }
  ZkBlobFieldEntry.prototype.onCreate = function () {
    this.render();
  };
  ZkBlobFieldEntry.prototype.update_kg59yq$ = function (bo, createState, progress) {
    this.bo = bo;
    this.createState = createState;
    this.progress = progress;
    this.render();
  };
  function Coroutine$ZkBlobFieldEntry_init$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$ZkBlobFieldEntry_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkBlobFieldEntry_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkBlobFieldEntry_init$lambda.prototype.constructor = Coroutine$ZkBlobFieldEntry_init$lambda;
  Coroutine$ZkBlobFieldEntry_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return false;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkBlobFieldEntry_init$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ZkBlobFieldEntry_init$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ZkBlobFieldEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ZkBlobFieldEntry',
    interfaces: [ZkElement]
  };
  function ZkAttachmentEntry(bo, createState, progress, size, onDelete) {
    if (createState === void 0)
      createState = null;
    if (progress === void 0)
      progress = null;
    if (size === void 0)
      size = 200;
    if (onDelete === void 0)
      onDelete = ZkAttachmentEntry_init$lambda;
    ZkBlobFieldEntry.call(this, bo, createState, progress, size, onDelete);
  }
  ZkAttachmentEntry.prototype.onCreate = function () {
    this.unaryPlus_jcqzh$(get_blobStyles().attachmentEntry);
    this.render();
  };
  function ZkAttachmentEntry$render$lambda(this$ZkAttachmentEntry) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$ZkAttachmentEntry.bo.name);
      return Unit;
    };
  }
  function ZkAttachmentEntry$render$lambda_0(this$ZkAttachmentEntry) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$ZkAttachmentEntry.bo.size.toString());
      return Unit;
    };
  }
  function ZkAttachmentEntry$render$lambda_1(this$ZkAttachmentEntry) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$ZkAttachmentEntry.bo.mimeType);
      return Unit;
    };
  }
  function ZkAttachmentEntry$render$lambda_2($receiver) {
    $receiver.unaryPlus_pdl1vz$(blobStrings.starting);
    return Unit;
  }
  function ZkAttachmentEntry$render$lambda_3($receiver) {
    $receiver.unaryPlus_pdl1vz$(blobStrings.uploading);
    return Unit;
  }
  function ZkAttachmentEntry$render$lambda_4($receiver) {
    $receiver.unaryPlus_pdl1vz$(blobStrings.uploadError);
    return Unit;
  }
  function ZkAttachmentEntry$render$lambda_5($receiver) {
    $receiver.unaryPlus_pdl1vz$(blobStrings.uploadAbort);
    return Unit;
  }
  function ZkAttachmentEntry$render$lambda_6() {
    return Unit;
  }
  function ZkAttachmentEntry$render$lambda_7(this$ZkAttachmentEntry) {
    return function (event) {
      event.preventDefault();
      window.location.href = get_url(this$ZkAttachmentEntry.bo);
      return Unit;
    };
  }
  ZkAttachmentEntry.prototype.render = function () {
    var tmp$;
    this.clear();
    this.unaryPlus_y4uc6z$(this.div_ddb4j7$(void 0, ZkAttachmentEntry$render$lambda(this)));
    this.unaryPlus_y4uc6z$(this.div_ddb4j7$(void 0, ZkAttachmentEntry$render$lambda_0(this)));
    this.unaryPlus_y4uc6z$(this.div_ddb4j7$(void 0, ZkAttachmentEntry$render$lambda_1(this)));
    tmp$ = this.createState;
    if (equals(tmp$, BlobCreateState$Starting_getInstance()))
      this.unaryPlus_y4uc6z$(this.div_ddb4j7$(void 0, ZkAttachmentEntry$render$lambda_2));
    else if (equals(tmp$, BlobCreateState$Progress_getInstance()))
      this.unaryPlus_y4uc6z$(this.div_ddb4j7$(void 0, ZkAttachmentEntry$render$lambda_3));
    else if (equals(tmp$, BlobCreateState$Error_getInstance()))
      this.unaryPlus_y4uc6z$(this.div_ddb4j7$(void 0, ZkAttachmentEntry$render$lambda_4));
    else if (equals(tmp$, BlobCreateState$Abort_getInstance()))
      this.unaryPlus_y4uc6z$(this.div_ddb4j7$(void 0, ZkAttachmentEntry$render$lambda_5));
    else {
      this.unaryPlus_51iybo$(ZkButton_init(resource.ZkIcons.fileDownload, ZkFlavour.Info, get_url(this.bo), void 0, void 0, void 0, void 0, void 0, void 0, void 0, ZkAttachmentEntry$render$lambda_6).on_bzyv6u$('click', ZkAttachmentEntry$render$lambda_7(this)));
    }
  };
  function Coroutine$ZkAttachmentEntry_init$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$ZkAttachmentEntry_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkAttachmentEntry_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkAttachmentEntry_init$lambda.prototype.constructor = Coroutine$ZkAttachmentEntry_init$lambda;
  Coroutine$ZkAttachmentEntry_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return false;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkAttachmentEntry_init$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ZkAttachmentEntry_init$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ZkAttachmentEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ZkAttachmentEntry',
    interfaces: [ZkBlobFieldEntry]
  };
  function ZkAttachmentsField(form, comm, reference, blobCountMax, disposition, blobClass, makeBlobCb) {
    if (reference === void 0)
      reference = null;
    if (blobCountMax === void 0)
      blobCountMax = null;
    if (disposition === void 0)
      disposition = null;
    if (blobClass === void 0)
      blobClass = null;
    if (makeBlobCb === void 0)
      makeBlobCb = null;
    ZkBlobField.call(this, form, comm, reference, blobCountMax, disposition, blobClass, makeBlobCb);
  }
  ZkAttachmentsField.prototype.onCreate = function () {
    ZkBlobField.prototype.onCreate.call(this);
    this.unaryPlus_jcqzh$(get_blobStyles().attachmentField);
  };
  function Coroutine$ZkAttachmentsField$makeEntry$lambda(this$ZkAttachmentsField_0, preview_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ZkAttachmentsField = this$ZkAttachmentsField_0;
    this.local$preview = preview_0;
  }
  Coroutine$ZkAttachmentsField$makeEntry$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkAttachmentsField$makeEntry$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkAttachmentsField$makeEntry$lambda.prototype.constructor = Coroutine$ZkAttachmentsField$makeEntry$lambda;
  Coroutine$ZkAttachmentsField$makeEntry$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$ZkAttachmentsField.onDelete_vhhjuh$(this.local$preview, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkAttachmentsField$makeEntry$lambda(this$ZkAttachmentsField_0) {
    return function (preview_0, continuation_0, suspended) {
      var instance = new Coroutine$ZkAttachmentsField$makeEntry$lambda(this$ZkAttachmentsField_0, preview_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ZkAttachmentsField.prototype.makeEntry_k4iao6$$default = function (blob, state) {
    var $receiver = new ZkAttachmentEntry(blob, state, void 0, void 0, ZkAttachmentsField$makeEntry$lambda(this));
    $receiver.marginRight_za3rmp$(10).marginBottom_za3rmp$(10);
    return $receiver;
  };
  ZkAttachmentsField.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ZkAttachmentsField',
    interfaces: [ZkBlobField]
  };
  var blobStyles;
  var blobStyles_metadata = new PropertyMetadata('blobStyles');
  function get_blobStyles() {
    return blobStyles.getValue_d6mtq7$(this, blobStyles_metadata);
  }
  function BlobStyles() {
    ZkCssStyleSheet.call(this);
    this.attachmentField_1azljq$_0 = this.cssClass_27a4fn$(BlobStyles$attachmentField$lambda(this)).provideDelegate_rqhjsf$(this, BlobStyles$attachmentField_metadata);
    this.attachmentEntry_wynvi$_0 = this.cssClass_27a4fn$(BlobStyles$attachmentEntry$lambda).provideDelegate_rqhjsf$(this, BlobStyles$attachmentEntry_metadata);
    this.imageDropArea_nb0ewa$_0 = this.cssClass_27a4fn$(BlobStyles$imageDropArea$lambda(this)).provideDelegate_rqhjsf$(this, BlobStyles$imageDropArea_metadata);
    this.imageDropAreaMessage_mx8uy1$_0 = this.cssClass_27a4fn$(BlobStyles$imageDropAreaMessage$lambda).provideDelegate_rqhjsf$(this, BlobStyles$imageDropAreaMessage_metadata);
    this.outerView_nskxkj$_0 = this.cssClass_27a4fn$(BlobStyles$outerView$lambda).provideDelegate_rqhjsf$(this, BlobStyles$outerView_metadata);
    this.image_on83am$_0 = this.cssClass_27a4fn$(BlobStyles$image$lambda).provideDelegate_rqhjsf$(this, BlobStyles$image_metadata);
    this.imageName_5lfkl5$_0 = this.cssClass_27a4fn$(BlobStyles$imageName$lambda).provideDelegate_rqhjsf$(this, BlobStyles$imageName_metadata);
    this.imageMimeType_hrg23g$_0 = this.cssClass_27a4fn$(BlobStyles$imageMimeType$lambda).provideDelegate_rqhjsf$(this, BlobStyles$imageMimeType_metadata);
    this.actions_r6dyk0$_0 = this.cssClass_27a4fn$(BlobStyles$actions$lambda).provideDelegate_rqhjsf$(this, BlobStyles$actions_metadata);
    this.closeButton_zempdp$_0 = this.cssClass_27a4fn$(BlobStyles$closeButton$lambda).provideDelegate_rqhjsf$(this, BlobStyles$closeButton_metadata);
    this.deleteButton_xwrkgm$_0 = this.cssClass_27a4fn$(BlobStyles$deleteButton$lambda).provideDelegate_rqhjsf$(this, BlobStyles$deleteButton_metadata);
  }
  var BlobStyles$attachmentField_metadata = new PropertyMetadata('attachmentField');
  Object.defineProperty(BlobStyles.prototype, 'attachmentField', {
    configurable: true,
    get: function () {
      return this.attachmentField_1azljq$_0.getValue_lrcp0p$(this, BlobStyles$attachmentField_metadata);
    }
  });
  var BlobStyles$attachmentEntry_metadata = new PropertyMetadata('attachmentEntry');
  Object.defineProperty(BlobStyles.prototype, 'attachmentEntry', {
    configurable: true,
    get: function () {
      return this.attachmentEntry_wynvi$_0.getValue_lrcp0p$(this, BlobStyles$attachmentEntry_metadata);
    }
  });
  var BlobStyles$imageDropArea_metadata = new PropertyMetadata('imageDropArea');
  Object.defineProperty(BlobStyles.prototype, 'imageDropArea', {
    configurable: true,
    get: function () {
      return this.imageDropArea_nb0ewa$_0.getValue_lrcp0p$(this, BlobStyles$imageDropArea_metadata);
    }
  });
  var BlobStyles$imageDropAreaMessage_metadata = new PropertyMetadata('imageDropAreaMessage');
  Object.defineProperty(BlobStyles.prototype, 'imageDropAreaMessage', {
    configurable: true,
    get: function () {
      return this.imageDropAreaMessage_mx8uy1$_0.getValue_lrcp0p$(this, BlobStyles$imageDropAreaMessage_metadata);
    }
  });
  var BlobStyles$outerView_metadata = new PropertyMetadata('outerView');
  Object.defineProperty(BlobStyles.prototype, 'outerView', {
    configurable: true,
    get: function () {
      return this.outerView_nskxkj$_0.getValue_lrcp0p$(this, BlobStyles$outerView_metadata);
    }
  });
  var BlobStyles$image_metadata = new PropertyMetadata('image');
  Object.defineProperty(BlobStyles.prototype, 'image', {
    configurable: true,
    get: function () {
      return this.image_on83am$_0.getValue_lrcp0p$(this, BlobStyles$image_metadata);
    }
  });
  var BlobStyles$imageName_metadata = new PropertyMetadata('imageName');
  Object.defineProperty(BlobStyles.prototype, 'imageName', {
    configurable: true,
    get: function () {
      return this.imageName_5lfkl5$_0.getValue_lrcp0p$(this, BlobStyles$imageName_metadata);
    }
  });
  var BlobStyles$imageMimeType_metadata = new PropertyMetadata('imageMimeType');
  Object.defineProperty(BlobStyles.prototype, 'imageMimeType', {
    configurable: true,
    get: function () {
      return this.imageMimeType_hrg23g$_0.getValue_lrcp0p$(this, BlobStyles$imageMimeType_metadata);
    }
  });
  var BlobStyles$actions_metadata = new PropertyMetadata('actions');
  Object.defineProperty(BlobStyles.prototype, 'actions', {
    configurable: true,
    get: function () {
      return this.actions_r6dyk0$_0.getValue_lrcp0p$(this, BlobStyles$actions_metadata);
    }
  });
  var BlobStyles$closeButton_metadata = new PropertyMetadata('closeButton');
  Object.defineProperty(BlobStyles.prototype, 'closeButton', {
    configurable: true,
    get: function () {
      return this.closeButton_zempdp$_0.getValue_lrcp0p$(this, BlobStyles$closeButton_metadata);
    }
  });
  var BlobStyles$deleteButton_metadata = new PropertyMetadata('deleteButton');
  Object.defineProperty(BlobStyles.prototype, 'deleteButton', {
    configurable: true,
    get: function () {
      return this.deleteButton_xwrkgm$_0.getValue_lrcp0p$(this, BlobStyles$deleteButton_metadata);
    }
  });
  function BlobStyles$attachmentField$lambda(this$BlobStyles) {
    return function ($receiver, it) {
      $receiver.unaryPlus_57x8mj$(css.Display.grid);
      $receiver.unaryPlus_57x8mj$(css.AlignItems.center);
      $receiver.gridTemplateColumns = 'repeat(4, max-content)';
      $receiver.gap = this$BlobStyles.theme.spacingStep.toString() + 'px';
      return Unit;
    };
  }
  function BlobStyles$attachmentEntry$lambda($receiver, it) {
    $receiver.unaryPlus_57x8mj$(css.Display.contents);
    return Unit;
  }
  function BlobStyles$imageDropArea$lambda$lambda(this$BlobStyles) {
    return function ($receiver, it) {
      $receiver.backgroundColor = this$BlobStyles.theme.hoverBackgroundColor;
      $receiver.color = this$BlobStyles.theme.hoverTextColor;
      $receiver.fill = this$BlobStyles.theme.hoverTextColor;
      return Unit;
    };
  }
  function BlobStyles$imageDropArea$lambda(this$BlobStyles) {
    return function ($receiver, it) {
      $receiver.unaryPlus_57x8mj$(css.BoxSizing.borderBox);
      $receiver.unaryPlus_57x8mj$(css.Display.flex);
      $receiver.unaryPlus_57x8mj$(css.JustifyContent.center);
      $receiver.unaryPlus_57x8mj$(css.AlignItems.center);
      $receiver.flexGrow = 1.0;
      $receiver.width = (100).toString() + '%';
      $receiver.height = (100).toString() + '%';
      $receiver.color = this$BlobStyles.theme.textColor;
      $receiver.fill = this$BlobStyles.theme.textColor;
      $receiver.padding = (20).toString() + 'px';
      $receiver.borderRadius = this$BlobStyles.theme.cornerRadius.toString() + 'px';
      $receiver.border = '1px dotted lightgray';
      $receiver.on_9198b7$(':hover', void 0, BlobStyles$imageDropArea$lambda$lambda(this$BlobStyles));
      return Unit;
    };
  }
  function BlobStyles$imageDropAreaMessage$lambda($receiver, it) {
    $receiver.fontSize = (14).toString() + 'px';
    $receiver.fontWeight = (400).toString();
    $receiver.paddingLeft = (6).toString() + 'px';
    return Unit;
  }
  function BlobStyles$outerView$lambda($receiver, it) {
    $receiver.unaryPlus_57x8mj$(css.BoxSizing.borderBox);
    $receiver.unaryPlus_57x8mj$(css.Position.absolute);
    $receiver.unaryPlus_57x8mj$(css.Display.flex);
    $receiver.unaryPlus_57x8mj$(css.FlexDirection.row);
    $receiver.unaryPlus_57x8mj$(css.JustifyContent.center);
    $receiver.unaryPlus_57x8mj$(css.AlignItems.center);
    $receiver.top = (0).toString() + 'px';
    $receiver.left = (0).toString() + 'px';
    $receiver.height = (100).toString() + 'vh';
    $receiver.width = (100).toString() + 'vw';
    $receiver.background = 'rgba(0, 0, 0, 0.8)';
    $receiver.zIndex = (1000).toString();
    $receiver.outline = 'none';
    return Unit;
  }
  function BlobStyles$image$lambda($receiver, it) {
    $receiver.maxWidth = (100).toString() + '%';
    $receiver.maxHeight = (100).toString() + '%';
    return Unit;
  }
  function BlobStyles$imageName$lambda($receiver, it) {
    $receiver.unaryPlus_57x8mj$(css.AlignSelf.center);
    $receiver.marginBlockStart = (4).toString() + 'px';
    $receiver.marginBlockEnd = (4).toString() + 'px';
    $receiver.fontSize = (85).toString() + '%';
    return Unit;
  }
  function BlobStyles$imageMimeType$lambda($receiver, it) {
    $receiver.unaryPlus_57x8mj$(css.AlignSelf.center);
    $receiver.fontSize = (70).toString() + '%';
    return Unit;
  }
  function BlobStyles$actions$lambda($receiver, it) {
    $receiver.unaryPlus_57x8mj$(css.Display.flex);
    $receiver.unaryPlus_57x8mj$(css.FlexDirection.row);
    $receiver.unaryPlus_57x8mj$(css.JustifyContent.spaceAround);
    return Unit;
  }
  function BlobStyles$closeButton$lambda($receiver, it) {
    $receiver.unaryPlus_57x8mj$(css.Position.absolute);
    $receiver.top = (20).toString() + 'px';
    $receiver.right = (20).toString() + 'px';
    $receiver.zIndex = (1001).toString();
    return Unit;
  }
  function BlobStyles$deleteButton$lambda($receiver, it) {
    $receiver.unaryPlus_57x8mj$(css.Position.absolute);
    $receiver.top = (20).toString() + 'px';
    $receiver.left = (20).toString() + 'px';
    $receiver.zIndex = (1001).toString();
    return Unit;
  }
  BlobStyles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BlobStyles',
    interfaces: [ZkCssStyleSheet]
  };
  function ZkFullScreenImageView(url, onDeleteImage) {
    ZkElement.call(this);
    this.url = url;
    this.onDeleteImage = onDeleteImage;
  }
  function ZkFullScreenImageView$onCreate$lambda(this$ZkFullScreenImageView) {
    return function () {
      this$ZkFullScreenImageView.hide();
      return Unit;
    };
  }
  function ZkFullScreenImageView$onCreate$lambda_0(this$ZkFullScreenImageView) {
    return function () {
      this$ZkFullScreenImageView.onDeleteImage(this$ZkFullScreenImageView);
      return Unit;
    };
  }
  function ZkFullScreenImageView$onCreate$lambda_1(this$ZkFullScreenImageView) {
    return function (event) {
      var tmp$;
      Kotlin.isType(tmp$ = event, KeyboardEvent) ? tmp$ : throwCCE();
      if (equals(event.key, 'Escape'))
        this$ZkFullScreenImageView.hide();
      return Unit;
    };
  }
  ZkFullScreenImageView.prototype.onCreate = function () {
    this.unaryPlus_jcqzh$(get_blobStyles().outerView);
    this.element.tabIndex = 0;
    this.unaryPlus_y4uc6z$(this.image_gdpym3$(this.url, get_blobStyles().image));
    this.unaryPlus_51iybo$(ZkButton_init(resource.ZkIcons.close, void 0, void 0, true, void 0, void 0, void 0, 32, 48, void 0, ZkFullScreenImageView$onCreate$lambda(this))).css_29v2oc$(get_blobStyles().closeButton);
    this.unaryPlus_51iybo$(ZkButton_init(resource.ZkIcons.deleteForever, void 0, void 0, true, void 0, void 0, void 0, 32, 48, void 0, ZkFullScreenImageView$onCreate$lambda_0(this))).css_29v2oc$(get_blobStyles().deleteButton);
    this.on_bzyv6u$('keydown', ZkFullScreenImageView$onCreate$lambda_1(this));
  };
  ZkFullScreenImageView.prototype.show = function () {
    var tmp$;
    (tmp$ = document.body) != null ? tmp$.appendChild(this.element) : null;
    if (this.lifeCycleState !== ZkElementState.Created) {
      this.onCreate();
    }this.focus();
    return this;
  };
  ZkFullScreenImageView.prototype.hide = function () {
    var tmp$;
    (tmp$ = document.body) != null ? tmp$.removeChild(this.element) : null;
    return this;
  };
  ZkFullScreenImageView.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ZkFullScreenImageView',
    interfaces: [ZkElement]
  };
  function ZkImagePreview(bo, createState, progress, size, showMeta, onDelete) {
    if (createState === void 0)
      createState = null;
    if (progress === void 0)
      progress = null;
    if (size === void 0)
      size = 200;
    if (showMeta === void 0)
      showMeta = false;
    if (onDelete === void 0)
      onDelete = ZkImagePreview_init$lambda;
    ZkBlobFieldEntry.call(this, bo, createState, progress, size, onDelete);
    this.showMeta_weaxbr$_0 = showMeta;
  }
  ZkImagePreview.prototype.render = function () {
    var tmp$;
    this.clear();
    tmp$ = this.createState;
    if (equals(tmp$, BlobCreateState$Starting_getInstance()))
      this.renderProgress_vx719q$_0(this);
    else if (equals(tmp$, BlobCreateState$Progress_getInstance()))
      this.renderProgress_vx719q$_0(this);
    else if (equals(tmp$, BlobCreateState$Done_getInstance()))
      this.renderImage_85asvm$_0(this);
    else if (equals(tmp$, BlobCreateState$Error_getInstance()))
      this.renderError_drtdfp$_0(this);
    else if (equals(tmp$, BlobCreateState$Abort_getInstance()))
      this.renderAbort_y83cbh$_0(this);
    else if (tmp$ == null)
      this.renderImage_85asvm$_0(this);
  };
  function Coroutine$ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda(this$ZkImagePreview_0, closure$it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ZkImagePreview = this$ZkImagePreview_0;
    this.local$closure$it = closure$it_0;
  }
  Coroutine$ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda.prototype.constructor = Coroutine$ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda;
  Coroutine$ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$ZkImagePreview.onDelete(this.local$this$ZkImagePreview, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var deleted = this.result_0;
            if (deleted) {
              return this.local$closure$it.hide(), Unit;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda(this$ZkImagePreview_0, closure$it_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda(this$ZkImagePreview_0, closure$it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function ZkImagePreview$renderImage$lambda$lambda$lambda$lambda(this$ZkImagePreview) {
    return function (it) {
      io(ZkImagePreview$renderImage$lambda$lambda$lambda$lambda$lambda(this$ZkImagePreview, it));
      return Unit;
    };
  }
  function ZkImagePreview$renderImage$lambda$lambda$lambda(this$ZkImagePreview) {
    return function (f) {
      (new ZkFullScreenImageView(get_url(this$ZkImagePreview.bo), ZkImagePreview$renderImage$lambda$lambda$lambda$lambda(this$ZkImagePreview))).show();
      return Unit;
    };
  }
  function ZkImagePreview$renderImage$lambda$lambda(this$ZkImagePreview) {
    return function ($receiver) {
      var receiver = $receiver.buildPoint.style;
      var this$ZkImagePreview_0 = this$ZkImagePreview;
      if (Kotlin.compareTo(receiver.height, receiver.width) > 0) {
        receiver.height = this$ZkImagePreview_0.size.toString() + 'px';
        receiver.width = 'auto';
      } else {
        receiver.height = 'auto';
        receiver.width = this$ZkImagePreview_0.size.toString() + 'px';
      }
      $receiver.on_6kkwlp$($receiver.buildPoint, 'click', ZkImagePreview$renderImage$lambda$lambda$lambda(this$ZkImagePreview));
      return Unit;
    };
  }
  function ZkImagePreview$renderImage$lambda$lambda_0(this$ZkImagePreview) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$ZkImagePreview.bo.name);
      return Unit;
    };
  }
  function ZkImagePreview$renderImage$lambda$lambda_1(this$ZkImagePreview) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$(this$ZkImagePreview.bo.mimeType);
      return Unit;
    };
  }
  function ZkImagePreview$renderImage$lambda(this$ZkImagePreview) {
    return function ($receiver) {
      $receiver.unaryPlus_y4uc6z$($receiver.image_gdpym3$(get_url(this$ZkImagePreview.bo), void 0, ZkImagePreview$renderImage$lambda$lambda(this$ZkImagePreview)));
      if (this$ZkImagePreview.showMeta_weaxbr$_0) {
        $receiver.unaryPlus_y4uc6z$($receiver.div_ip079v$([get_blobStyles().imageName], ZkImagePreview$renderImage$lambda$lambda_0(this$ZkImagePreview)));
        $receiver.unaryPlus_y4uc6z$($receiver.div_ip079v$([get_blobStyles().imageMimeType], ZkImagePreview$renderImage$lambda$lambda_1(this$ZkImagePreview)));
      }return Unit;
    };
  }
  ZkImagePreview.prototype.renderImage_85asvm$_0 = function ($receiver) {
    $receiver.unaryPlus_y4uc6z$($receiver.column_ddb4j7$(void 0, ZkImagePreview$renderImage$lambda(this)));
  };
  function ZkImagePreview$renderProgress$lambda(this$ZkImagePreview) {
    return function ($receiver) {
      $receiver.unaryPlus_pdl1vz$('uploading: ' + toString(this$ZkImagePreview.progress) + ' / ' + this$ZkImagePreview.bo.size.toString());
      return Unit;
    };
  }
  ZkImagePreview.prototype.renderProgress_vx719q$_0 = function ($receiver) {
    $receiver.unaryPlus_y4uc6z$($receiver.row_i9pmy5$(void 0, void 0, void 0, ZkImagePreview$renderProgress$lambda(this)));
  };
  ZkImagePreview.prototype.renderError_drtdfp$_0 = function ($receiver) {
    $receiver.unaryPlus_pdl1vz$('upload error');
  };
  ZkImagePreview.prototype.renderAbort_y83cbh$_0 = function ($receiver) {
    $receiver.unaryPlus_pdl1vz$('aborted');
  };
  function Coroutine$ZkImagePreview_init$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$ZkImagePreview_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkImagePreview_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkImagePreview_init$lambda.prototype.constructor = Coroutine$ZkImagePreview_init$lambda;
  Coroutine$ZkImagePreview_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return false;
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkImagePreview_init$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$ZkImagePreview_init$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  ZkImagePreview.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ZkImagePreview',
    interfaces: [ZkBlobFieldEntry]
  };
  function ZkImagesField(form, comm, reference, blobCountMax, disposition, blobClass, showMeta, makeBlobCb) {
    if (reference === void 0)
      reference = null;
    if (blobCountMax === void 0)
      blobCountMax = null;
    if (disposition === void 0)
      disposition = null;
    if (blobClass === void 0)
      blobClass = null;
    if (showMeta === void 0)
      showMeta = false;
    if (makeBlobCb === void 0)
      makeBlobCb = null;
    ZkBlobField.call(this, form, comm, reference, blobCountMax, disposition, blobClass, makeBlobCb);
    this.showMeta = showMeta;
  }
  ZkImagesField.prototype.onCreate = function () {
    ZkBlobField.prototype.onCreate.call(this);
    this.unaryPlus_jcqzh$(layout.zkLayoutStyles.row);
  };
  function Coroutine$ZkImagesField$makeEntry$lambda(this$ZkImagesField_0, preview_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$ZkImagesField = this$ZkImagesField_0;
    this.local$preview = preview_0;
  }
  Coroutine$ZkImagesField$makeEntry$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ZkImagesField$makeEntry$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ZkImagesField$makeEntry$lambda.prototype.constructor = Coroutine$ZkImagesField$makeEntry$lambda;
  Coroutine$ZkImagesField$makeEntry$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$ZkImagesField.onDelete_vhhjuh$(this.local$preview, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ZkImagesField$makeEntry$lambda(this$ZkImagesField_0) {
    return function (preview_0, continuation_0, suspended) {
      var instance = new Coroutine$ZkImagesField$makeEntry$lambda(this$ZkImagesField_0, preview_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ZkImagesField.prototype.makeEntry_k4iao6$$default = function (blob, state) {
    var $receiver = new ZkImagePreview(blob, state, void 0, void 0, this.showMeta, ZkImagesField$makeEntry$lambda(this));
    $receiver.marginRight_za3rmp$(10).marginBottom_za3rmp$(10);
    return $receiver;
  };
  ZkImagesField.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ZkImagesField',
    interfaces: [ZkBlobField]
  };
  function BlobComm(namespace, serializer) {
    CommBase.call(this);
    this.namespace_v1ot2w$_0 = namespace;
    this.serializer_3ipjbj$_0 = serializer;
  }
  BlobComm.prototype.create_11rb$ = function (bo, continuation) {
    if (!bo.id.isEmpty())
      throw RuntimeException_init('id is not empty in ' + bo);
    var headers = new Headers();
    headers.append('content-type', 'application/json; charset=UTF-8');
    var body = Json.Default.encodeToString_tf03ej$(this.serializer_3ipjbj$_0, bo);
    var referrer;
    var referrerPolicy;
    var mode;
    var credentials;
    var cache;
    var redirect;
    var integrity;
    var keepalive;
    var window_0;
    referrer = undefined;
    referrerPolicy = undefined;
    mode = undefined;
    credentials = undefined;
    cache = undefined;
    redirect = undefined;
    integrity = undefined;
    keepalive = undefined;
    window_0 = undefined;
    var o = {};
    o['method'] = 'POST';
    o['headers'] = headers;
    o['body'] = body;
    o['referrer'] = referrer;
    o['referrerPolicy'] = referrerPolicy;
    o['mode'] = mode;
    o['credentials'] = credentials;
    o['cache'] = cache;
    o['redirect'] = redirect;
    o['integrity'] = integrity;
    o['keepalive'] = keepalive;
    o['window'] = window_0;
    var requestInit = o;
    return this.sendAndReceive_hzxl4x$_0('/api/' + this.namespace_v1ot2w$_0 + '/blob/meta', requestInit, continuation);
  };
  BlobComm.prototype.read_f0dtxn$ = function (id, continuation) {
    var headers = new Headers();
    var body;
    var referrer;
    var referrerPolicy;
    var mode;
    var credentials;
    var cache;
    var redirect;
    var integrity;
    var keepalive;
    var window_0;
    body = undefined;
    referrer = undefined;
    referrerPolicy = undefined;
    mode = undefined;
    credentials = undefined;
    cache = undefined;
    redirect = undefined;
    integrity = undefined;
    keepalive = undefined;
    window_0 = undefined;
    var o = {};
    o['method'] = 'GET';
    o['headers'] = headers;
    o['body'] = body;
    o['referrer'] = referrer;
    o['referrerPolicy'] = referrerPolicy;
    o['mode'] = mode;
    o['credentials'] = credentials;
    o['cache'] = cache;
    o['redirect'] = redirect;
    o['integrity'] = integrity;
    o['keepalive'] = keepalive;
    o['window'] = window_0;
    var requestInit = o;
    return this.sendAndReceive_hzxl4x$_0('/api/' + this.namespace_v1ot2w$_0 + '/blob/meta/' + id, requestInit, continuation);
  };
  BlobComm.prototype.update_11rb$ = function (bo, continuation) {
    if (bo.id.isEmpty())
      throw RuntimeException_init('ID of the ' + bo + ' is empty');
    var headers = new Headers();
    headers.append('content-type', 'application/json; charset=UTF-8');
    var body = Json.Default.encodeToString_tf03ej$(this.serializer_3ipjbj$_0, bo);
    var referrer;
    var referrerPolicy;
    var mode;
    var credentials;
    var cache;
    var redirect;
    var integrity;
    var keepalive;
    var window_0;
    referrer = undefined;
    referrerPolicy = undefined;
    mode = undefined;
    credentials = undefined;
    cache = undefined;
    redirect = undefined;
    integrity = undefined;
    keepalive = undefined;
    window_0 = undefined;
    var o = {};
    o['method'] = 'PATCH';
    o['headers'] = headers;
    o['body'] = body;
    o['referrer'] = referrer;
    o['referrerPolicy'] = referrerPolicy;
    o['mode'] = mode;
    o['credentials'] = credentials;
    o['cache'] = cache;
    o['redirect'] = redirect;
    o['integrity'] = integrity;
    o['keepalive'] = keepalive;
    o['window'] = window_0;
    var requestInit = o;
    return this.sendAndReceive_hzxl4x$_0('/api/' + this.namespace_v1ot2w$_0 + '/blob/meta/' + bo.id, requestInit, continuation);
  };
  function Coroutine$BlobComm$all$lambda(this$BlobComm_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$BlobComm = this$BlobComm_0;
  }
  Coroutine$BlobComm$all$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$BlobComm$all$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$BlobComm$all$lambda.prototype.constructor = Coroutine$BlobComm$all$lambda;
  Coroutine$BlobComm$all$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var responsePromise = window.fetch('/api/' + this.local$this$BlobComm.namespace_v1ot2w$_0 + '/blob/meta');
            this.state_0 = 2;
            this.result_0 = await_0(responsePromise, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            tmp$ = this.result_0;
            this.state_0 = 3;
            this.result_0 = this.local$this$BlobComm.checkStatus_7ri4uy$(tmp$, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function BlobComm$all$lambda(this$BlobComm_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$BlobComm$all$lambda(this$BlobComm_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$all($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$all.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$all.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$all.prototype.constructor = Coroutine$all;
  Coroutine$all.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.commBlock_knlm9s$(BlobComm$all$lambda(this.$this), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var response = this.result_0;
            var textPromise = response.text();
            this.state_0 = 3;
            this.result_0 = await_0(textPromise, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            var text = this.result_0;
            return Json.Default.decodeFromString_awif5v$(ListSerializer(this.$this.serializer_3ipjbj$_0), text);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  BlobComm.prototype.all = function (continuation_0, suspended) {
    var instance = new Coroutine$all(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$BlobComm$delete$lambda(this$BlobComm_0, closure$id_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$BlobComm = this$BlobComm_0;
    this.local$closure$id = closure$id_0;
  }
  Coroutine$BlobComm$delete$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$BlobComm$delete$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$BlobComm$delete$lambda.prototype.constructor = Coroutine$BlobComm$delete$lambda;
  Coroutine$BlobComm$delete$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var tmp$_0 = window;
            var tmp$_1 = '/api/' + this.local$this$BlobComm.namespace_v1ot2w$_0 + '/blob/meta/' + this.local$closure$id;
            var headers;
            var body;
            var referrer;
            var referrerPolicy;
            var mode;
            var credentials;
            var cache;
            var redirect;
            var integrity;
            var keepalive;
            var window_0;
            headers = undefined;
            body = undefined;
            referrer = undefined;
            referrerPolicy = undefined;
            mode = undefined;
            credentials = undefined;
            cache = undefined;
            redirect = undefined;
            integrity = undefined;
            keepalive = undefined;
            window_0 = undefined;
            var o = {};
            o['method'] = 'DELETE';
            o['headers'] = headers;
            o['body'] = body;
            o['referrer'] = referrer;
            o['referrerPolicy'] = referrerPolicy;
            o['mode'] = mode;
            o['credentials'] = credentials;
            o['cache'] = cache;
            o['redirect'] = redirect;
            o['integrity'] = integrity;
            o['keepalive'] = keepalive;
            o['window'] = window_0;
            var responsePromise = tmp$_0.fetch(tmp$_1, o);
            this.state_0 = 2;
            this.result_0 = await_0(responsePromise, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            tmp$ = this.result_0;
            this.state_0 = 3;
            this.result_0 = this.local$this$BlobComm.checkStatus_7ri4uy$(tmp$, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function BlobComm$delete$lambda(this$BlobComm_0, closure$id_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$BlobComm$delete$lambda(this$BlobComm_0, closure$id_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$delete_f0dtxn$($this, id_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$id = id_0;
  }
  Coroutine$delete_f0dtxn$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$delete_f0dtxn$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$delete_f0dtxn$.prototype.constructor = Coroutine$delete_f0dtxn$;
  Coroutine$delete_f0dtxn$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.commBlock_knlm9s$(BlobComm$delete$lambda(this.$this, this.local$id), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  BlobComm.prototype.delete_f0dtxn$ = function (id_0, continuation_0, suspended) {
    var instance = new Coroutine$delete_f0dtxn$(this, id_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$BlobComm$sendAndReceive$lambda(closure$path_0, closure$requestInit_0, this$BlobComm_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$path = closure$path_0;
    this.local$closure$requestInit = closure$requestInit_0;
    this.local$this$BlobComm = this$BlobComm_0;
  }
  Coroutine$BlobComm$sendAndReceive$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$BlobComm$sendAndReceive$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$BlobComm$sendAndReceive$lambda.prototype.constructor = Coroutine$BlobComm$sendAndReceive$lambda;
  Coroutine$BlobComm$sendAndReceive$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var responsePromise = window.fetch(this.local$closure$path, this.local$closure$requestInit);
            this.state_0 = 2;
            this.result_0 = await_0(responsePromise, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            tmp$ = this.result_0;
            this.state_0 = 3;
            this.result_0 = this.local$this$BlobComm.checkStatus_7ri4uy$(tmp$, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function BlobComm$sendAndReceive$lambda(closure$path_0, closure$requestInit_0, this$BlobComm_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$BlobComm$sendAndReceive$lambda(closure$path_0, closure$requestInit_0, this$BlobComm_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$sendAndReceive_hzxl4x$_0($this, path_0, requestInit_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$path = path_0;
    this.local$requestInit = requestInit_0;
  }
  Coroutine$sendAndReceive_hzxl4x$_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$sendAndReceive_hzxl4x$_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$sendAndReceive_hzxl4x$_0.prototype.constructor = Coroutine$sendAndReceive_hzxl4x$_0;
  Coroutine$sendAndReceive_hzxl4x$_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.commBlock_knlm9s$(BlobComm$sendAndReceive$lambda(this.local$path, this.local$requestInit, this.$this), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var response = this.result_0;
            var textPromise = response.text();
            this.state_0 = 3;
            this.result_0 = await_0(textPromise, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            var text = this.result_0;
            return Json.Default.decodeFromString_awif5v$(this.$this.serializer_3ipjbj$_0, text);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  BlobComm.prototype.sendAndReceive_hzxl4x$_0 = function (path_0, requestInit_0, continuation_0, suspended) {
    var instance = new Coroutine$sendAndReceive_hzxl4x$_0(this, path_0, requestInit_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$BlobComm$upload$lambda$lambda(closure$state_0, closure$channel_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$state = closure$state_0;
    this.local$closure$channel = closure$channel_0;
  }
  Coroutine$BlobComm$upload$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$BlobComm$upload$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$BlobComm$upload$lambda$lambda.prototype.constructor = Coroutine$BlobComm$upload$lambda$lambda;
  Coroutine$BlobComm$upload$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            switch (this.local$closure$state.name) {
              case 'Error':
                this.state_0 = 3;
                this.result_0 = this.local$closure$channel.send_11rb$(false, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              case 'Done':
                this.state_0 = 2;
                this.result_0 = this.local$closure$channel.send_11rb$(true, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              default:return Unit;
            }

          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          case 3:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function BlobComm$upload$lambda$lambda(closure$state_0, closure$channel_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$BlobComm$upload$lambda$lambda(closure$state_0, closure$channel_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function BlobComm$upload$lambda(closure$channel) {
    return function (f, state, f_0) {
      launch(coroutines.GlobalScope, coroutines.Dispatchers.Default, void 0, BlobComm$upload$lambda$lambda(state, closure$channel));
      return Unit;
    };
  }
  function Coroutine$upload_b2ray6$($this, bo_0, data_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$channel = void 0;
    this.local$bo = bo_0;
    this.local$data = data_0;
  }
  Coroutine$upload_b2ray6$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$upload_b2ray6$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$upload_b2ray6$.prototype.constructor = Coroutine$upload_b2ray6$;
  Coroutine$upload_b2ray6$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$channel = Channel();
            this.state_0 = 2;
            this.result_0 = this.$this.upload_g6mxm5$(this.local$bo, this.local$data, BlobComm$upload$lambda(this.local$channel), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$channel.receive(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            if (!this.result_0)
              throw RuntimeException_init('blob upload error');
            return this.local$bo;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  BlobComm.prototype.upload_b2ray6$ = function (bo_0, data_0, continuation_0, suspended) {
    var instance = new Coroutine$upload_b2ray6$(this, bo_0, data_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function BlobComm$upload$lambda_0(closure$callback, closure$bo) {
    return function (it) {
      var tmp$, tmp$_0, tmp$_1;
      tmp$ = BlobCreateState$Progress_getInstance();
      tmp$_1 = numberToLong((Kotlin.isType(tmp$_0 = it, ProgressEvent) ? tmp$_0 : throwCCE()).loaded);
      closure$callback(closure$bo, tmp$, tmp$_1);
      return Unit;
    };
  }
  function BlobComm$upload$lambda_1(closure$callback, closure$bo) {
    return function (it) {
      closure$callback(closure$bo, BlobCreateState$Error_getInstance(), L0);
      return Unit;
    };
  }
  function BlobComm$upload$lambda_2(closure$callback, closure$bo) {
    return function (it) {
      closure$callback(closure$bo, BlobCreateState$Abort_getInstance(), L0);
      return Unit;
    };
  }
  function BlobComm$upload$lambda_3(closure$callback, closure$bo, closure$data) {
    return function (it) {
      closure$callback(closure$bo, BlobCreateState$Done_getInstance(), numberToLong(closure$data.size));
      return Unit;
    };
  }
  BlobComm.prototype.upload_g6mxm5$ = function (bo, data, callback, continuation) {
    if (!Kotlin.isType(data, Blob)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException_init(message.toString());
    }var req = new XMLHttpRequest();
    callback(bo, BlobCreateState$Starting_getInstance(), L0);
    req.addEventListener('progress', BlobComm$upload$lambda_0(callback, bo));
    req.addEventListener('error', BlobComm$upload$lambda_1(callback, bo));
    req.addEventListener('abort', BlobComm$upload$lambda_2(callback, bo));
    req.addEventListener('load', BlobComm$upload$lambda_3(callback, bo, data));
    var url = '/api/' + this.namespace_v1ot2w$_0 + '/blob/content/' + bo.id;
    req.open('POST', url, true);
    req.setRequestHeader('Content-Type', bo.mimeType);
    req.setRequestHeader('Content-Disposition', 'attachment; filename=' + '"' + bo.name + '"');
    req.send(data);
    bo.size = numberToLong(data.size);
    return bo;
  };
  function Coroutine$BlobComm$download$lambda(this$BlobComm_0, closure$id_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$BlobComm = this$BlobComm_0;
    this.local$closure$id = closure$id_0;
  }
  Coroutine$BlobComm$download$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$BlobComm$download$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$BlobComm$download$lambda.prototype.constructor = Coroutine$BlobComm$download$lambda;
  Coroutine$BlobComm$download$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var responsePromise = window.fetch('/api/' + this.local$this$BlobComm.namespace_v1ot2w$_0 + '/blob/content/' + this.local$closure$id);
            this.state_0 = 2;
            this.result_0 = await_0(responsePromise, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            tmp$ = this.result_0;
            this.state_0 = 3;
            this.result_0 = this.local$this$BlobComm.checkStatus_7ri4uy$(tmp$, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function BlobComm$download$lambda(this$BlobComm_0, closure$id_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$BlobComm$download$lambda(this$BlobComm_0, closure$id_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$download_vfw297$($this, id_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$id = id_0;
  }
  Coroutine$download_vfw297$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$download_vfw297$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$download_vfw297$.prototype.constructor = Coroutine$download_vfw297$;
  Coroutine$download_vfw297$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.commBlock_knlm9s$(BlobComm$download$lambda(this.$this, this.local$id), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var response = this.result_0;
            this.state_0 = 3;
            this.result_0 = await_0(response.arrayBuffer(), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            var ab = this.result_0;
            return new Int8Array(ab);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  BlobComm.prototype.download_vfw297$ = function (id_0, continuation_0, suspended) {
    var instance = new Coroutine$download_vfw297$(this, id_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$BlobComm$byReference$lambda(this$BlobComm_0, closure$reference_0, closure$q_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$this$BlobComm = this$BlobComm_0;
    this.local$closure$reference = closure$reference_0;
    this.local$closure$q = closure$q_0;
  }
  Coroutine$BlobComm$byReference$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$BlobComm$byReference$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$BlobComm$byReference$lambda.prototype.constructor = Coroutine$BlobComm$byReference$lambda;
  Coroutine$BlobComm$byReference$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var responsePromise = window.fetch('/api/' + this.local$this$BlobComm.namespace_v1ot2w$_0 + '/blob/list' + (this.local$closure$reference == null ? '' : '/' + toString(this.local$closure$reference)) + this.local$closure$q);
            this.state_0 = 2;
            this.result_0 = await_0(responsePromise, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            tmp$ = this.result_0;
            this.state_0 = 3;
            this.result_0 = this.local$this$BlobComm.checkStatus_7ri4uy$(tmp$, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function BlobComm$byReference$lambda(this$BlobComm_0, closure$reference_0, closure$q_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$BlobComm$byReference$lambda(this$BlobComm_0, closure$reference_0, closure$q_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$byReference_vcfpzq$$default($this, reference_0, disposition_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$reference = reference_0;
    this.local$disposition = disposition_0;
  }
  Coroutine$byReference_vcfpzq$$default.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$byReference_vcfpzq$$default.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$byReference_vcfpzq$$default.prototype.constructor = Coroutine$byReference_vcfpzq$$default;
  Coroutine$byReference_vcfpzq$$default.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var q = (tmp$ = this.local$disposition != null ? '?disposition=' + this.local$disposition : null) != null ? tmp$ : '';
            this.state_0 = 2;
            this.result_0 = this.$this.commBlock_knlm9s$(BlobComm$byReference$lambda(this.$this, this.local$reference, q), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var response = this.result_0;
            var textPromise = response.text();
            this.state_0 = 3;
            this.result_0 = await_0(textPromise, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            var text = this.result_0;
            return Json.Default.decodeFromString_awif5v$(ListSerializer(this.$this.serializer_3ipjbj$_0), text);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  BlobComm.prototype.byReference_vcfpzq$$default = function (reference_0, disposition_0, continuation_0, suspended) {
    var instance = new Coroutine$byReference_vcfpzq$$default(this, reference_0, disposition_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  BlobComm.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BlobComm',
    interfaces: [BlobCommInterface, CommBase]
  };
  function makeBlobComm(companion) {
    return new BlobComm(companion.boNamespace, companion.serializer());
  }
  var package$zakadabar = _.zakadabar || (_.zakadabar = {});
  var package$lib = package$zakadabar.lib || (package$zakadabar.lib = {});
  var package$blobs = package$lib.blobs || (package$lib.blobs = {});
  var package$comm = package$blobs.comm || (package$blobs.comm = {});
  package$comm.BlobCommInterface = BlobCommInterface;
  var package$data = package$blobs.data || (package$blobs.data = {});
  package$data.BlobBo = BlobBo;
  package$data.BlobBoCompanion = BlobBoCompanion;
  Object.defineProperty(BlobCreateState, 'Starting', {
    get: BlobCreateState$Starting_getInstance
  });
  Object.defineProperty(BlobCreateState, 'Progress', {
    get: BlobCreateState$Progress_getInstance
  });
  Object.defineProperty(BlobCreateState, 'Done', {
    get: BlobCreateState$Done_getInstance
  });
  Object.defineProperty(BlobCreateState, 'Error', {
    get: BlobCreateState$Error_getInstance
  });
  Object.defineProperty(BlobCreateState, 'Abort', {
    get: BlobCreateState$Abort_getInstance
  });
  package$data.BlobCreateState = BlobCreateState;
  $$importsForInline$$['zakadabar-stack-blobs'] = _;
  $$importsForInline$$['zakadabar-stack-core'] = $module$zakadabar_stack_core;
  package$data.get_url_dc2eqz$ = get_url;
  var package$resource = package$blobs.resource || (package$blobs.resource = {});
  Object.defineProperty(package$resource, 'blobStrings', {
    get: function () {
      return blobStrings;
    }
  });
  package$resource.Strings = Strings;
  var package$browser = package$blobs.browser || (package$blobs.browser = {});
  package$browser.ZkBlobField = ZkBlobField;
  package$browser.ZkBlobFieldEntry = ZkBlobFieldEntry;
  var package$attachment = package$browser.attachment || (package$browser.attachment = {});
  package$attachment.ZkAttachmentEntry = ZkAttachmentEntry;
  package$attachment.ZkAttachmentsField = ZkAttachmentsField;
  Object.defineProperty(package$browser, 'blobStyles', {
    get: get_blobStyles
  });
  package$browser.BlobStyles = BlobStyles;
  var package$image = package$browser.image || (package$browser.image = {});
  package$image.ZkFullScreenImageView = ZkFullScreenImageView;
  package$image.ZkImagePreview = ZkImagePreview;
  package$image.ZkImagesField = ZkImagesField;
  package$comm.BlobComm = BlobComm;
  package$comm.makeBlobComm_b8u7gy$ = makeBlobComm;
  BlobCommInterface.prototype.read_s8cxhz$ = EntityCommInterface.prototype.read_s8cxhz$;
  BlobCommInterface.prototype.read_61zpoe$ = EntityCommInterface.prototype.read_61zpoe$;
  Object.defineProperty(BlobBo.prototype, 'isValid', Object.getOwnPropertyDescriptor(EntityBo.prototype, 'isValid'));
  BlobBo.prototype.create = EntityBo.prototype.create;
  BlobBo.prototype.delete = EntityBo.prototype.delete;
  BlobBo.prototype.update = EntityBo.prototype.update;
  BlobBo.prototype.update_qlkmfe$ = EntityBo.prototype.update_qlkmfe$;
  BlobComm.prototype.read_s8cxhz$ = BlobCommInterface.prototype.read_s8cxhz$;
  BlobComm.prototype.read_61zpoe$ = BlobCommInterface.prototype.read_61zpoe$;
  BlobComm.prototype.listByReference_vfp5nv$$default = BlobCommInterface.prototype.listByReference_vfp5nv$$default;
  BlobComm.prototype.byReference_vcfpzq$ = BlobCommInterface.prototype.byReference_vcfpzq$;
  BlobComm.prototype.listByReference_vfp5nv$ = BlobCommInterface.prototype.listByReference_vfp5nv$;
  blobStrings = new Strings();
  blobStyles = cssStyleSheet(new BlobStyles());
  Kotlin.defineModule('zakadabar-stack-blobs', _);
  return _;
}));

//# sourceMappingURL=zakadabar-stack-blobs.js.map
