/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public final class EasyjListSerializer
implements ObjectSerializer {
    public static final EasyjListSerializer INSTANCE = new EasyjListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        boolean writeClassName = serializer.out.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled((int)features, (SerializerFeature)SerializerFeature.WriteClassName);
        SerializeWriter out = serializer.out;
        Type elementType = null;
        if (writeClassName) {
            elementType = TypeUtils.getCollectionItemType((Type)fieldType);
        }
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        List list = (List)object;
        if (list.size() == 0) {
            out.append((CharSequence)"[]");
            return;
        }
        SerialContext context = serializer.getContext();
        serializer.setContext(context, object, fieldName, 0);
        try {
            if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                out.append('[');
                serializer.incrementIndent();
                int i = 0;
                for (Object item : list) {
                    if (i != 0) {
                        out.append(',');
                    }
                    serializer.println();
                    if (item != null) {
                        if (serializer.containsReference(item)) {
                            serializer.writeReference(item);
                        } else {
                            ObjectSerializer itemSerializer = serializer.getObjectWriter(item.getClass());
                            SerialContext itemContext = new SerialContext(context, object, fieldName, 0, 0);
                            serializer.setContext(itemContext);
                            itemSerializer.write(serializer, item, (Object)i, elementType, features);
                        }
                    } else {
                        serializer.out.writeNull();
                    }
                    ++i;
                }
                serializer.decrementIdent();
                serializer.println();
                out.append(']');
                return;
            }
            out.append('[');
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ObjectSerializer itemSerializer;
                Object item = list.get(i);
                if (i != 0) {
                    out.append(',');
                }
                if (item == null) {
                    out.append((CharSequence)"null");
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeInt(((Integer)item).intValue());
                    continue;
                }
                if (clazz == Long.class) {
                    ObjectSerializer writer = serializer.config.getObjectWriter(clazz);
                    try {
                        writer.write(serializer, item, null, null, 0);
                        continue;
                    }
                    catch (IOException e) {
                        throw new JSONException(e.getMessage(), (Throwable)e);
                    }
                }
                if ((SerializerFeature.DisableCircularReferenceDetect.mask & features) != 0) {
                    itemSerializer = serializer.getObjectWriter(item.getClass());
                    itemSerializer.write(serializer, item, (Object)i, elementType, features);
                    continue;
                }
                if (!out.disableCircularReferenceDetect) {
                    serializer.context = new SerialContext(context, object, fieldName, 0, 0);
                }
                if (serializer.containsReference(item)) {
                    serializer.writeReference(item);
                    continue;
                }
                itemSerializer = serializer.getObjectWriter(item.getClass());
                if ((SerializerFeature.WriteClassName.mask & features) != 0 && itemSerializer instanceof JavaBeanSerializer) {
                    JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)itemSerializer;
                    javaBeanSerializer.writeNoneASM(serializer, item, (Object)i, elementType, features);
                    continue;
                }
                itemSerializer.write(serializer, item, (Object)i, elementType, features);
            }
            out.append(']');
        }
        finally {
            serializer.context = context;
        }
    }
}

