/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.clock;

import icu.easyj.core.clock.IClock;

public interface ITickClock
extends IClock,
Comparable<ITickClock> {
    public long getBaseEpochMicros();

    public long getBaseTickNanos();

    default public long getPassedNanos() {
        return System.nanoTime() - this.getBaseTickNanos();
    }

    @Override
    default public int compareTo(ITickClock otherClock) {
        long nanoTime = this.getBaseTickNanos();
        long nanos = nanoTime - this.getBaseTickNanos() + this.getBaseEpochMicros() * 1000L;
        long otherNanos = nanoTime - otherClock.getBaseTickNanos() + otherClock.getBaseEpochMicros() * 1000L;
        return Long.compare(nanos, otherNanos);
    }
}

