/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.clock.factory;

import icu.easyj.core.clock.AutoRefreshHighAccuracyTickClock;
import icu.easyj.core.clock.IAutoRefreshTickClock;
import icu.easyj.core.clock.TickClock;
import java.util.Date;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public interface IRemotingClockFactory<K> {
    @NonNull
    public long getRemotingTime(@NonNull K var1);

    @NonNull
    default public IAutoRefreshTickClock createClock(@NonNull K remotingKey) {
        Assert.notNull(remotingKey, (String)"'remotingKey' must not be null");
        return new AutoRefreshHighAccuracyTickClock(remotingKey.getClass().getSimpleName(), () -> new TickClock(this.getRemotingTime(remotingKey) * 1000L));
    }

    @NonNull
    public IAutoRefreshTickClock getClock(@NonNull K var1);

    public void destroyClock(@NonNull K var1);

    @NonNull
    default public Date now(@NonNull K remotingKey) {
        return this.getClock(remotingKey).now();
    }

    default public long currentTimeMillis(@NonNull K remotingKey) {
        return this.getClock(remotingKey).currentTimeMillis();
    }

    default public long currentTimeMicros(@NonNull K remotingKey) {
        return this.getClock(remotingKey).currentTimeMicros();
    }

    default public long currentTimeNanos(@NonNull K remotingKey) {
        return this.getClock(remotingKey).currentTimeNanos();
    }
}

