/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.sequence.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.core.util.MapUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.lang.NonNull;

@LoadLevel(name="atomic-long", order=999)
public class AtomicLongSequenceServiceImpl
implements ISequenceService {
    private static final long DEFAULT_INITIAL_VALUE = 0L;
    private final Map<String, AtomicLong> atomicLongMap = new ConcurrentHashMap<String, AtomicLong>();
    private final long initialValue;

    public AtomicLongSequenceServiceImpl(long initialValue) {
        this.initialValue = initialValue;
    }

    public AtomicLongSequenceServiceImpl() {
        this(0L);
    }

    @Override
    public long currVal(@NonNull String seqName) {
        return this.getAtomicLong(seqName).get();
    }

    @Override
    public long nextVal(@NonNull String seqName) {
        return this.getAtomicLong(seqName).incrementAndGet();
    }

    @Override
    public long setVal(@NonNull String seqName, long newVal) {
        return this.getAtomicLong(seqName).getAndSet(newVal);
    }

    public AtomicLong getAtomicLong(String seqName) {
        return MapUtils.computeIfAbsent(this.atomicLongMap, seqName, k -> new AtomicLong(this.initialValue));
    }
}

