/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.trace.impls;

import brave.Span;
import brave.Tracer;
import cn.hutool.extra.spring.SpringUtil;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.core.trace.TraceService;
import icu.easyj.core.trace.impls.ZipkinTraceServiceValidate;
import org.springframework.lang.Nullable;

@LoadLevel(name="zipkin", order=2, validators={ZipkinTraceServiceValidate.class})
@DependsOnClass(value={Tracer.class})
public class ZipkinTraceServiceImpl
implements TraceService {
    static Tracer getTracer() {
        return TraceServiceSingletonHolder.INSTANCE.instance;
    }

    @Nullable
    static Span currentSpan() {
        return ZipkinTraceServiceImpl.getTracer().currentSpan();
    }

    @Override
    public boolean canTrace() {
        Span span = ZipkinTraceServiceImpl.currentSpan();
        return span != null && !span.isNoop();
    }

    @Override
    public void put(String key, String value) {
        Span span = ZipkinTraceServiceImpl.currentSpan();
        if (span == null || span.isNoop()) {
            return;
        }
        if (key == null) {
            key = "null";
        }
        if (value == null) {
            value = "null";
        }
        span.tag(key, value);
    }

    @Override
    public void remove(String key) {
    }

    @Override
    public void clear() {
    }

    private static enum TraceServiceSingletonHolder {
        INSTANCE;

        private final Tracer instance = (Tracer)SpringUtil.getBean(Tracer.class);

        public Tracer getInstances() {
            return TraceServiceSingletonHolder.INSTANCE.instance;
        }
    }
}

