/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.jar.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.util.jar.IJarGroupLoader;
import icu.easyj.core.util.jar.JarContext;

@LoadLevel(name="test")
public class TestJarGroupLoaderImpl
implements IJarGroupLoader {
    @Override
    public String load(JarContext jarContext) {
        String name = jarContext.getName();
        if (name.startsWith("junit-jupiter")) {
            return "org.junit.jupiter";
        }
        if (name.startsWith("junit-platform")) {
            return "org.junit.platform";
        }
        if (name.startsWith("junit-vintage")) {
            return "org.junit.vintage";
        }
        switch (name) {
            case "junit": {
                return "junit";
            }
            case "junit-theories": {
                return "org.junit.contrib";
            }
            case "org.junit.source": {
                return "org.junit.source";
            }
            case "mockito-core": 
            case "mockito-junit-jupiter": {
                return "org.mockito";
            }
            case "opentest4j": {
                return "org.opentest4j";
            }
            case "android-json": {
                return "com.vaadin.external.google";
            }
            case "asm": {
                if (jarContext.getVersionInfo().compareTo("4.0-SNAPSHOT") >= 0) {
                    return "org.ow2.asm";
                }
                return "asm";
            }
            case "aspectjweaver": {
                if (jarContext.getVersionInfo().compareTo("1.6.0-SNAPSHOT") >= 0) {
                    return "org.aspectj";
                }
                return "aspectj";
            }
        }
        return null;
    }
}

