@file:Suppress("unused")

package id.unum.crossPlatformInterfaces

import id.unum.protos.crypto.v1.EncryptedData
import id.unum.protos.crypto.v1.KeyPair
import id.unum.protos.crypto.v1.PublicKeyInfo

internal const val EC_KEYSTORE = "EC"
internal const val RSA_KEYSTORE = "RSA"
internal const val EC_SIGN_TYPE = "SHA256withECDSA"

class CryptoLibJvm {

    fun verifyDataWithProvidedKey(key: PublicKeyInfo, data: ByteArray, signatureResults: String): Boolean {
        return JvmSignature.verifyDataWithProvidedKey(key, data, signatureResults)
    }

    fun signData(data: ByteArray, keyPair: KeyPair): String {
        return JvmSignature.signData(data, JvmKeys.getPrivateKey(keyPair, KeyType.ECC), EC_SIGN_TYPE)
    }

    fun encryptData(data: ByteArray, keyPair: KeyPair): String {
        return JvmEncryption.encryptData(data, JvmKeys.getPublicKey(keyPair, KeyType.RSA))
    }

    fun encryptDataWithOptions(
        data: ByteArray,
        iv: ByteArray,
        algorithm: String,
        key: ByteArray,
        did: String,
        pemKey: String
    ): EncryptedData {
        return JvmEncryption.encryptWithOptions(data, iv, algorithm, key, did, pemKey)
    }

    fun decryptData(data: String, keyPair: KeyPair): ByteArray? {
        return JvmEncryption.decryptData(data, JvmKeys.getPrivateKey(keyPair, KeyType.RSA))
    }

    fun decryptWithOptions(data: String, iv: ByteArray, algorithm: String, key: ByteArray): ByteArray? {
        return JvmEncryption.decryptWithOptions(data, iv, algorithm, key)
    }

    fun generateEcKey(encoding: Encoding = Encoding.PEM): KeyPair? {
        return JvmKeys.generateEcKey(encoding)
    }

    fun generateRsaKey(encoding: Encoding = Encoding.PEM): KeyPair? {
        return JvmKeys.generateRsaKey(encoding)
    }
}