@file:Suppress("JAVA_MODULE_DOES_NOT_EXPORT_PACKAGE")

package id.unum.crossPlatformInterfaces

import java.security.*


class KeyGenerator(keyType: String) {

    private val keyGen: KeyPairGenerator
    private var prng: SecureRandom? = null
    var publicKey: PublicKey? = null
    var privateKey: PrivateKey? = null

    init {
        keyGen = KeyPairGenerator.getInstance(keyType)
    }

    @Throws(
        InvalidKeyException::class
    )
    fun generate(keyBits: Int) {
        val pair: KeyPair
        try {
            if (prng == null) {
                prng = SecureRandom()
            }
            keyGen.initialize(keyBits, prng)
            pair = keyGen.genKeyPair()
            publicKey = pair.public
            privateKey = pair.private
        } catch (e: Exception) {
            println(e.localizedMessage)
            println(e.stackTrace)
        }

        if (!"X.509".equals(publicKey?.format, true)) {
            throw IllegalArgumentException("publicKey's is not X.509, but " + publicKey?.format)
        }
    }
}