/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import ie.curiositysoftware.jobengine.dto.file.UploadFileResponse;
import ie.curiositysoftware.jobengine.dto.job.AutomationExecutionParameter;
import ie.curiositysoftware.jobengine.dto.job.Job;
import ie.curiositysoftware.jobengine.dto.job.JobType;
import ie.curiositysoftware.jobengine.dto.job.ServerProcessScopeEnum;
import ie.curiositysoftware.jobengine.dto.job.settings.VIPAutomationExecutionJobSettings;
import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.jobengine.services.file.FileService;
import ie.curiositysoftware.jobengine.settings.JobSetting;
import ie.curiositysoftware.jobengine.settings.JobSettingParameter;
import ie.curiositysoftware.jobengine.settings.JobSettingParser;
import ie.curiositysoftware.jobengine.utils.JobExecutor;
import ie.curiositysoftware.utils.UnirestHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Main {
    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        UnirestHelper.initUnirestMapper();
        String xmlPath = args[0];
        JobSetting result = new JobSettingParser().parseSettings(xmlPath);
        if (result == null) {
            System.out.println("Error parsing configuration");
            return;
        }
        ConnectionProfile p = new ConnectionProfile();
        p.setAPIKey(result.getApikeyField());
        p.setAPIUrl(result.getUrlField());
        HashMap<String, String> overrideValues = new HashMap<String, String>();
        if (args.length >= 3) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode actualObj = mapper.readTree(args[2]);
                Iterator<JobSettingParameter> it = actualObj.fieldNames();
                while (it.hasNext()) {
                    String fName = (String)it.next();
                    String fValue = actualObj.get(fName).toString();
                    overrideValues.put(fName, fValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Continuing...");
            }
        }
        Job job = new Job();
        job.setJobType(JobType.VIPAutoExecutionJob);
        job.setVipAutomationJobSettings(new VIPAutomationExecutionJobSettings());
        job.getVipAutomationJobSettings().setMachineKey(result.getMachinekeyField());
        job.getVipAutomationJobSettings().setServerProfileId(result.getSeverprofileidField());
        job.getVipAutomationJobSettings().setAutomationType(result.getAutomationtypeField());
        if (result.getTestsuiteidField() != null) {
            job.getVipAutomationJobSettings().setTestSuiteId(result.getTestsuiteidField());
            job.getVipAutomationJobSettings().setScope(ServerProcessScopeEnum.ModelTestSuite);
        } else {
            job.getVipAutomationJobSettings().setScope(ServerProcessScopeEnum.Global);
        }
        job.getVipAutomationJobSettings().setSharedJobServer(false);
        job.getVipAutomationJobSettings().setAutomationParameters(new ArrayList<AutomationExecutionParameter>());
        int index = 1;
        for (JobSettingParameter curParam : result.getParametersField()) {
            System.out.println("Working on parameter - " + curParam.getNameField() + " " + curParam.getTypeField());
            if (curParam.getTypeField().equals("fileupload")) {
                FileService fs = new FileService(p);
                UploadFileResponse fileResponse = fs.addFile(new File(curParam.getValueField()));
                if (fileResponse == null) {
                    System.out.println("Error " + fs.getErrorMessage());
                } else {
                    System.out.println("File " + fileResponse.getDownloadUri());
                }
                AutomationExecutionParameter param = new AutomationExecutionParameter();
                param.setVar(curParam.getNameField());
                param.setValue(fileResponse.getDownloadUri());
                param.setParamIndex(index);
                job.getVipAutomationJobSettings().getAutomationParameters().add(param);
            } else {
                AutomationExecutionParameter param = new AutomationExecutionParameter();
                param.setVar(curParam.getNameField());
                if (overrideValues.containsKey(curParam.getNameField())) {
                    param.setValue((String)overrideValues.get(curParam.getNameField()));
                } else {
                    param.setValue(curParam.getValueField());
                }
                param.setParamIndex(index);
                job.getVipAutomationJobSettings().getAutomationParameters().add(param);
                System.out.println("Added parameter - " + param.getVar() + " " + param.getValue());
            }
            ++index;
        }
        JobExecutor jobExecutor = new JobExecutor(p);
        if (!jobExecutor.executeJob(job, args[1], result.getMaximumtimeField()).booleanValue()) {
            System.out.println(jobExecutor.getErrorMessage());
            return;
        }
    }
}

