/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.allocation.engine;

import ie.curiositysoftware.allocation.dto.AllocatedTest;
import ie.curiositysoftware.allocation.dto.AllocatedTestParameter;
import ie.curiositysoftware.allocation.dto.AllocationLookupDto;
import ie.curiositysoftware.allocation.dto.AllocationPool;
import ie.curiositysoftware.allocation.dto.AllocationType;
import ie.curiositysoftware.allocation.dto.DataAllocationResult;
import ie.curiositysoftware.allocation.dto.DataCatalogueModellerParameter;
import ie.curiositysoftware.allocation.dto.DataCatalogueTestCriteria;
import ie.curiositysoftware.allocation.dto.ResultMergeMethod;
import ie.curiositysoftware.allocation.engine.DataAllocationCriteria;
import ie.curiositysoftware.allocation.services.AllocationPoolService;
import ie.curiositysoftware.allocation.services.AllocationPoolTestService;
import ie.curiositysoftware.allocation.services.DataCriteriaService;
import ie.curiositysoftware.jobengine.dto.job.Job;
import ie.curiositysoftware.jobengine.dto.job.JobState;
import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.jobengine.services.job.JobSubmissionService;
import ie.curiositysoftware.utils.UnirestHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class DataAllocationEngine {
    private String m_ErrorMessage;
    private Boolean failOnError;
    private ConnectionProfile m_ConnectionProfile;

    public DataAllocationEngine(ConnectionProfile p) {
        this.m_ConnectionProfile = p;
        this.failOnError = true;
        UnirestHelper.initUnirestMapper();
    }

    public void setFailOnError(Boolean failOnError) {
        this.failOnError = failOnError;
    }

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public String getErrorMessage() {
        return this.m_ErrorMessage;
    }

    public Boolean resolvePools(String serverName, List<AllocationType> allocationTypes) {
        return this.resolvePools(serverName, allocationTypes, 1000000000L);
    }

    public Boolean resolvePools(String serverName, List<AllocationType> allocationTypes, Long maxTime) {
        HashMap allocationPoolsToResolve = new HashMap();
        for (AllocationType allocType : allocationTypes) {
            if (!allocationPoolsToResolve.containsKey(allocType.getPoolName())) {
                allocationPoolsToResolve.put(allocType.getPoolName(), new ArrayList());
            }
            ((List)allocationPoolsToResolve.get(allocType.getPoolName())).add(allocType);
        }
        for (String poolName : allocationPoolsToResolve.keySet()) {
            if (this.performAllocation(serverName, poolName, (List)allocationPoolsToResolve.get(poolName), maxTime).booleanValue() || !this.failOnError.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public DataAllocationResult getDataResult(String pool, String suite, String testName) {
        return this.getDataResult(pool, suite, testName, ResultMergeMethod.NoMerge);
    }

    public DataAllocationResult getDataResult(String pool, String suite, String testName, ResultMergeMethod mergeMethod) {
        try {
            AllocationLookupDto lookupDto = new AllocationLookupDto();
            lookupDto.setPool(pool);
            lookupDto.setSuite(suite);
            lookupDto.setTestName(testName);
            HttpResponse postResponse = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(this.m_ConnectionProfile.getAPIUrl() + "/api/apikey/" + this.m_ConnectionProfile.getAPIKey() + "/allocation-pool/suite/allocated-test/result/value")).header("accept", "application/json")).header("Content-Type", "application/json")).queryString("mergeMethod", (Object)mergeMethod)).body((Object)lookupDto).asObject(DataAllocationResult.class);
            if (postResponse.getStatus() == 200) {
                DataAllocationResult res = (DataAllocationResult)postResponse.getBody();
                System.out.println("Found data for " + pool + " " + suite + " " + testName);
                System.out.println(res.toString());
                return (DataAllocationResult)postResponse.getBody();
            }
            this.m_ErrorMessage = postResponse.getStatus() + " - " + postResponse.getStatusText();
            return null;
        }
        catch (Exception e) {
            this.m_ErrorMessage = e.getMessage();
            e.printStackTrace();
            return null;
        }
    }

    public DataAllocationResult getDataResultForCriteriaInPool(String serverName, String poolName, String catalogueName, String criteriaName, Integer howMany, ArrayList<DataAllocationCriteria> criteriaParameters) {
        return this.getDataResultForCriteriaInPool(serverName, poolName, catalogueName, criteriaName, howMany, criteriaParameters, 10000000L);
    }

    public DataAllocationResult getDataResultForCriteriaInPool(String serverName, String poolName, String catalogueName, String criteriaName, Integer howMany, ArrayList<DataAllocationCriteria> criteriaParameters, Long maxTime) {
        DataCriteriaService dataCriteriaService = new DataCriteriaService(this.m_ConnectionProfile);
        DataCatalogueTestCriteria criteria = dataCriteriaService.GetTestCriteria(catalogueName, criteriaName);
        if (criteria == null) {
            this.m_ErrorMessage = dataCriteriaService.getErrorMessage();
            System.out.println("Error GetTestCriteria() " + this.m_ErrorMessage);
            return null;
        }
        AllocationPoolService allocationPoolService = new AllocationPoolService(this.m_ConnectionProfile);
        AllocationPool allocationPool = allocationPoolService.GetAllocationPool(poolName);
        if (allocationPool == null) {
            this.m_ErrorMessage = allocationPoolService.getErrorMessage();
            System.out.println("Error GetAllocationPool() - " + this.m_ErrorMessage);
            return null;
        }
        AllocatedTest allocatedTest = new AllocatedTest();
        allocatedTest.setHowMany(howMany);
        allocatedTest.setName("Test " + UUID.randomUUID().toString());
        allocatedTest.setPoolId(allocationPool.getId());
        allocatedTest.setSuiteName("DataAllocationFramework");
        allocatedTest.setTestCriteriaIdCatalogueId(allocationPool.getCatalogueId());
        allocatedTest.setTestCriteriaId(criteria.getId());
        allocatedTest.setUniqueFind(false);
        HashMap<String, DataCatalogueModellerParameter> criteriaParamHash = criteria.getModellerParameterHash();
        ArrayList<AllocatedTestParameter> params = new ArrayList<AllocatedTestParameter>();
        for (DataAllocationCriteria allocationCriteria : criteriaParameters) {
            AllocatedTestParameter param = new AllocatedTestParameter();
            if (!criteriaParamHash.containsKey(allocationCriteria.getParameterName())) continue;
            param.setCriteriaParameterId(criteriaParamHash.get(allocationCriteria.getParameterName()).getId());
            param.setValue(allocationCriteria.getParameterValue());
            param.setCriteriaParameterName(allocationCriteria.getParameterName());
            params.add(param);
        }
        allocatedTest.setParameters(params);
        AllocationPoolTestService allocationPoolTestService = new AllocationPoolTestService(this.m_ConnectionProfile);
        allocatedTest = allocationPoolTestService.CreateAllocatedTest(allocatedTest, allocationPool.getId());
        if (allocatedTest == null) {
            this.m_ErrorMessage = dataCriteriaService.getErrorMessage();
            System.out.println("Error CreateAllocatedTest() " + this.m_ErrorMessage);
            return null;
        }
        ArrayList<AllocationType> allocationTypes = new ArrayList<AllocationType>();
        allocationTypes.add(new AllocationType(allocationPool.getName(), allocatedTest.getSuiteName(), allocatedTest.getName()));
        this.performAllocation(serverName, allocationPool.getName(), allocationTypes, maxTime);
        DataAllocationResult res = this.getDataResult(allocationPool.getName(), allocatedTest.getSuiteName(), allocatedTest.getName());
        Boolean deleted = allocationPoolTestService.DeleteAllocationPoolTest(allocatedTest.getId());
        if (!deleted.booleanValue()) {
            this.m_ErrorMessage = allocationPoolTestService.getErrorMessage();
            System.out.println("Error DeleteAllocationPoolTest() " + this.m_ErrorMessage);
            return res;
        }
        return res;
    }

    public DataAllocationResult getDataResultForCriteria(String serverName, String catalogueName, String criteriaName, Integer howMany, ArrayList<DataAllocationCriteria> criteriaParameters) {
        return this.getDataResultForCriteria(serverName, catalogueName, criteriaName, howMany, criteriaParameters, 10000000L);
    }

    public DataAllocationResult getDataResultForCriteria(String serverName, String catalogueName, String criteriaName, Integer howMany, ArrayList<DataAllocationCriteria> criteriaParameters, Long maxTime) {
        DataCriteriaService dataCriteriaService = new DataCriteriaService(this.m_ConnectionProfile);
        DataCatalogueTestCriteria criteria = dataCriteriaService.GetTestCriteria(catalogueName, criteriaName);
        if (criteria == null) {
            this.m_ErrorMessage = dataCriteriaService.getErrorMessage();
            System.out.println("Error GetTestCriteria() " + this.m_ErrorMessage);
            return null;
        }
        AllocationPool allocationPool = new AllocationPool();
        allocationPool.setCatalogueId(criteria.getCatalogueId());
        allocationPool.setName("Temporary pool " + UUID.randomUUID().toString());
        AllocationPoolService allocationPoolService = new AllocationPoolService(this.m_ConnectionProfile);
        allocationPool = allocationPoolService.CreateAllocationPool(allocationPool);
        if (allocationPool == null) {
            this.m_ErrorMessage = dataCriteriaService.getErrorMessage();
            System.out.println("Error CreateAllocationPool() " + this.m_ErrorMessage);
            return null;
        }
        AllocatedTest allocatedTest = new AllocatedTest();
        allocatedTest.setHowMany(howMany);
        allocatedTest.setName("Test " + UUID.randomUUID().toString());
        allocatedTest.setPoolId(allocationPool.getId());
        allocatedTest.setSuiteName("DataAllocationFramework");
        allocatedTest.setTestCriteriaIdCatalogueId(allocationPool.getCatalogueId());
        allocatedTest.setTestCriteriaId(criteria.getId());
        allocatedTest.setUniqueFind(false);
        HashMap<String, DataCatalogueModellerParameter> criteriaParamHash = criteria.getModellerParameterHash();
        ArrayList<AllocatedTestParameter> params = new ArrayList<AllocatedTestParameter>();
        for (DataAllocationCriteria allocationCriteria : criteriaParameters) {
            AllocatedTestParameter param = new AllocatedTestParameter();
            if (!criteriaParamHash.containsKey(allocationCriteria.getParameterName())) continue;
            param.setCriteriaParameterId(criteriaParamHash.get(allocationCriteria.getParameterName()).getId());
            param.setValue(allocationCriteria.getParameterValue());
            param.setCriteriaParameterName(allocationCriteria.getParameterName());
            params.add(param);
        }
        allocatedTest.setParameters(params);
        AllocationPoolTestService allocationPoolTestService = new AllocationPoolTestService(this.m_ConnectionProfile);
        allocatedTest = allocationPoolTestService.CreateAllocatedTest(allocatedTest, allocationPool.getId());
        if (allocatedTest == null) {
            this.m_ErrorMessage = dataCriteriaService.getErrorMessage();
            System.out.println("Error CreateAllocatedTest() " + this.m_ErrorMessage);
            return null;
        }
        ArrayList<AllocationType> allocationTypes = new ArrayList<AllocationType>();
        allocationTypes.add(new AllocationType(allocationPool.getName(), allocatedTest.getSuiteName(), allocatedTest.getName()));
        this.performAllocation(serverName, allocationPool.getName(), allocationTypes, maxTime);
        DataAllocationResult res = this.getDataResult(allocationPool.getName(), allocatedTest.getSuiteName(), allocatedTest.getName());
        Boolean deleted = allocationPoolService.DeleteAllocationPool(allocationPool.getId());
        if (!deleted.booleanValue()) {
            this.m_ErrorMessage = allocationPoolService.getErrorMessage();
            System.out.println("Error DeleteAllocationPool() " + this.m_ErrorMessage);
            return res;
        }
        return res;
    }

    private Boolean performAllocation(String serverName, String poolName, List<AllocationType> allocationTypes, Long maxTimeMS) {
        JobSubmissionService jobSubmission = new JobSubmissionService(this.m_ConnectionProfile);
        Job curJobStatus = this.createAllocateJob(serverName, poolName, allocationTypes);
        if (curJobStatus == null) {
            return false;
        }
        Long jobId = curJobStatus.getId();
        long startTime = System.currentTimeMillis();
        while (true) {
            long ellapsed;
            if ((ellapsed = System.currentTimeMillis() - startTime) > maxTimeMS) {
                this.m_ErrorMessage = "Maximum time elapsed";
                System.out.println(this.m_ErrorMessage);
                return false;
            }
            curJobStatus = jobSubmission.getJob(jobId);
            if (curJobStatus == null) break;
            if (curJobStatus.getJobState().equals((Object)JobState.Complete)) {
                System.out.println("Executing job - State: " + (Object)((Object)curJobStatus.getJobState()) + " - Message: " + curJobStatus.getProgressMessage());
                return true;
            }
            if (curJobStatus.getJobState().equals((Object)JobState.Error)) {
                this.m_ErrorMessage = "Error executing job " + curJobStatus.getProgressMessage();
                System.out.println(this.m_ErrorMessage);
                return false;
            }
            System.out.println("Executing job - State: " + (Object)((Object)curJobStatus.getJobState()) + " - Message: " + curJobStatus.getProgressMessage());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Executing job - State: " + (Object)((Object)curJobStatus.getJobState()) + " - Message: " + curJobStatus.getProgressMessage());
        return false;
    }

    private Job createAllocateJob(String serverName, String poolName, List<AllocationType> allocationTypes) {
        try {
            HttpResponse postResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(this.m_ConnectionProfile.getAPIUrl() + "/api/apikey/" + this.m_ConnectionProfile.getAPIKey() + "/allocation-pool/" + poolName + "/resolve/server/" + serverName + "/execute")).header("accept", "application/json")).header("Content-Type", "application/json")).body(allocationTypes).asObject(Job.class);
            if (postResponse.getStatus() == 200) {
                return (Job)postResponse.getBody();
            }
            this.m_ErrorMessage = postResponse.getStatus() + " - " + postResponse.getStatusText();
            System.out.println("Error " + this.m_ErrorMessage);
            return null;
        }
        catch (Exception e) {
            this.m_ErrorMessage = e.getMessage();
            System.out.println("Error " + this.m_ErrorMessage);
            e.printStackTrace();
            return null;
        }
    }
}

