/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.allocation.engine;

import ie.curiositysoftware.allocation.dto.AllocationType;
import ie.curiositysoftware.allocation.dto.DataAllocationResult;
import ie.curiositysoftware.allocation.dto.ResultMergeMethod;
import ie.curiositysoftware.allocation.engine.DataAllocationEngine;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataAllocationGherkinResolver {
    private DataAllocationEngine m_DataAllocationEngine;
    private String m_ServerName;

    public DataAllocationGherkinResolver(DataAllocationEngine engine, String serverName) {
        this.m_DataAllocationEngine = engine;
        this.m_ServerName = serverName;
    }

    public void ResolveGherkinFeatures(String sourceLocation, String targetLocation) throws IOException {
        String test;
        String suite;
        String pool;
        Matcher matcher;
        String content;
        File[] files = new File(sourceLocation).listFiles(f -> f.getName().endsWith(".feature"));
        ArrayList<AllocationType> allocationTypes = new ArrayList<AllocationType>();
        String dataPattern = "(?<allocName>@Data\\(\\s*poolName\\s*=\\s*\"(?<pool>[^\"]*)\"\\s*,\\s*suiteName\\s*=\\s*\"(?<suite>[^\"]*)\"\\s*,\\s*test\\s*=\\s*\"(?<test>[^\"]*)\"\\)\\[(?<rowIndex>\\d)\\]\\[(?<colName>[^\"]*)\\])";
        Pattern dataRegex = Pattern.compile(dataPattern);
        String dataTablePattern = "(?<allocName>@DataTable\\(\\s*poolName\\s*=\\s*\"(?<pool>[^\"]*)\"\\s*,\\s*suiteName\\s*=\\s*\"(?<suite>[^\"]*)\"\\s*,\\s*test\\s*=\\s*\"(?<test>[^\"]*)\"\\)\\[(?<colName>[^\"]*)\\])";
        Pattern dataTableRegex = Pattern.compile(dataTablePattern);
        String dataTableInitialPattern = "\\|.*@DataTable.*\\|";
        Pattern dataTableInitialRegex = Pattern.compile(dataTableInitialPattern);
        ArrayList<String> allocUnique = new ArrayList<String>();
        for (File f2 : files) {
            content = new String(Files.readAllBytes(f2.toPath()));
            matcher = dataRegex.matcher(content);
            while (matcher.find()) {
                pool = matcher.group("pool");
                suite = matcher.group("suite");
                test = matcher.group("test");
                if (allocUnique.contains(pool + suite + test)) continue;
                AllocationType allocationType = new AllocationType(pool, suite, test);
                allocationTypes.add(allocationType);
                allocUnique.add(pool + suite + test);
            }
            Matcher dataTableMatcher = dataTableRegex.matcher(content);
            while (dataTableMatcher.find()) {
                String pool2 = dataTableMatcher.group("pool");
                String suite2 = dataTableMatcher.group("suite");
                String test2 = dataTableMatcher.group("test");
                if (allocUnique.contains(pool2 + suite2 + test2)) continue;
                AllocationType allocationType = new AllocationType(pool2, suite2, test2);
                allocationTypes.add(allocationType);
                allocUnique.add(pool2 + suite2 + test2);
            }
        }
        if (!this.m_DataAllocationEngine.resolvePools(this.m_ServerName, allocationTypes).booleanValue()) {
            System.out.println("Error during resolve - " + this.m_DataAllocationEngine.getErrorMessage());
        }
        for (File f2 : files) {
            content = new String(Files.readAllBytes(f2.toPath()));
            matcher = dataRegex.matcher(content);
            while (matcher.find()) {
                pool = matcher.group("pool");
                suite = matcher.group("suite");
                test = matcher.group("test");
                String rowIndex = matcher.group("rowIndex");
                String colName = matcher.group("colName");
                String allocName = matcher.group("allocName");
                DataAllocationResult allocResult = this.m_DataAllocationEngine.getDataResult(pool, suite, test);
                content = content.replaceAll(Pattern.quote(allocName), allocResult.getDataRows().get(Integer.parseInt(rowIndex)).get(colName).toString());
            }
            Matcher dTablematcher = dataTableInitialRegex.matcher(content);
            while (dTablematcher.find()) {
                String dTableRow = dTablematcher.group();
                Matcher dTableRowMatcher = dataTableRegex.matcher(dTableRow);
                Integer noRows = null;
                ArrayList<String> rows = new ArrayList<String>();
                while (dTableRowMatcher.find()) {
                    int i;
                    String pool3 = dTableRowMatcher.group("pool");
                    String suite3 = dTableRowMatcher.group("suite");
                    String test3 = dTableRowMatcher.group("test");
                    String colName = dTableRowMatcher.group("colName");
                    String allocName = dTableRowMatcher.group("allocName");
                    DataAllocationResult allocResult = this.m_DataAllocationEngine.getDataResult(pool3, suite3, test3, ResultMergeMethod.MinimumProductLoopBack);
                    if (allocResult != null && noRows == null) {
                        noRows = allocResult.getDataRows().size();
                        for (i = 0; i < noRows; ++i) {
                            rows.add(dTableRow);
                        }
                    }
                    if (noRows == null) continue;
                    for (i = 0; i < noRows; ++i) {
                        try {
                            rows.set(i, ((String)rows.get(i)).replaceAll(Pattern.quote(allocName), allocResult.getDataRows().get(i).get(colName).toString()));
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("No value found in result set for test '" + test3 + "' in column '" + colName + "'");
                            rows.set(i, ((String)rows.get(i)).replaceAll(Pattern.quote(allocName), ""));
                        }
                    }
                }
                content = content.replaceAll(Pattern.quote(dTableRow), String.join((CharSequence)"\r\n", rows));
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(targetLocation + f2.getName()));
            writer.write(content);
            writer.close();
        }
    }
}

