/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.datacatalogue.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import ie.curiositysoftware.datacatalogue.DataListRowDto;
import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.utils.RestResponsePage;
import ie.curiositysoftware.utils.ServiceBase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class DataCatalogueTestCriteriaExecutionService
extends ServiceBase {
    ConnectionProfile m_ConnectionProfile;
    String m_ErrorMessage;

    public DataCatalogueTestCriteriaExecutionService(ConnectionProfile connectionProfile) {
        this.m_ConnectionProfile = connectionProfile;
    }

    static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static String urlEncodeUTF8(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", DataCatalogueTestCriteriaExecutionService.urlEncodeUTF8(entry.getKey().toString()), DataCatalogueTestCriteriaExecutionService.urlEncodeUTF8(entry.getValue().toString())));
        }
        return sb.toString();
    }

    public PageImpl<DataListRowDto> GetDataListRows(Long catalogueId, Long criteriaId, Pageable pageable, Map<String, String> parameters) {
        try {
            HttpResponse postResponse;
            String queryString = "";
            if (parameters != null && parameters.size() > 0) {
                queryString = parameters.entrySet().stream().map(p -> DataCatalogueTestCriteriaExecutionService.urlEncodeUTF8((String)p.getKey()) + "=" + DataCatalogueTestCriteriaExecutionService.urlEncodeUTF8((String)p.getValue())).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            }
            if (pageable != null) {
                queryString = queryString + "page=" + pageable.getPageNumber() + "&size=" + pageable.getPageSize();
            }
            if ((postResponse = ((GetRequest)((GetRequest)Unirest.get((String)DataCatalogueTestCriteriaExecutionService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/data-catalogue/", catalogueId.toString(), "/test-criteria/", criteriaId.toString(), "/listdata?", queryString)).header("accept", "application/json")).header("Content-Type", "application/json")).asObject(JsonNode.class)).getStatus() == 200) {
                JsonNode node = (JsonNode)postResponse.getBody();
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                ObjectReader reader = objectMapper.readerFor((TypeReference)new TypeReference<RestResponsePage<DataListRowDto>>(){});
                return (PageImpl)reader.readValue(node);
            }
            this.m_ErrorMessage = postResponse.getStatus() + " - " + postResponse.getStatusText();
            return null;
        }
        catch (Exception e) {
            this.m_ErrorMessage = e.getMessage();
            e.printStackTrace();
            return null;
        }
    }

    public String getErrorMessage() {
        return this.m_ErrorMessage;
    }
}

