/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.gptprompt.services;

import ie.curiositysoftware.gptprompt.dto.ChatGPTModelQuery;
import ie.curiositysoftware.gptprompt.dto.GenerativeAIPromptTemplateType;
import ie.curiositysoftware.jobengine.dto.job.Job;
import ie.curiositysoftware.jobengine.dto.job.JobState;
import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.jobengine.services.ResourceIdentifier;
import ie.curiositysoftware.jobengine.services.job.JobResultService;
import ie.curiositysoftware.jobengine.services.job.JobSubmissionService;
import ie.curiositysoftware.utils.ServiceBase;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;

public class GPTPromptService
extends ServiceBase {
    private ConnectionProfile m_ConnectionProfile;
    private String m_ErrorMessage;

    public GPTPromptService(ConnectionProfile connectionProfile) {
        this.m_ConnectionProfile = connectionProfile;
        this.m_ErrorMessage = "";
    }

    public String GetErrorMessage() {
        return this.m_ErrorMessage;
    }

    public String RetrieveElementIdentifier(String dom, String identifier) {
        ResourceIdentifier res = this.startGptPrompt(dom, identifier);
        Long jobId = res.getId();
        long startTime = System.currentTimeMillis();
        long twoMinutes = 120000L;
        JobSubmissionService jobSubmission = new JobSubmissionService(this.m_ConnectionProfile);
        while (true) {
            long ellapsed;
            if ((ellapsed = System.currentTimeMillis() - startTime) > twoMinutes) {
                this.m_ErrorMessage = "Maximum time elapsed";
                return this.m_ErrorMessage;
            }
            Job savedJob = jobSubmission.getJob(jobId);
            if (savedJob == null) break;
            if (savedJob.getJobState().equals((Object)JobState.Complete)) {
                System.out.println("Executing job - State: " + (Object)((Object)savedJob.getJobState()) + " - Message: " + savedJob.getProgressMessage());
                JobResultService jobResultService = new JobResultService(this.m_ConnectionProfile);
                String jobres = jobResultService.getResult(savedJob.getId()).getResultValue();
                if (jobres != null && jobres.equals("Null")) {
                    return null;
                }
                return jobres;
            }
            if (savedJob.getJobState().equals((Object)JobState.Error)) {
                this.m_ErrorMessage = "Error executing job " + savedJob.getProgressMessage();
                return null;
            }
            System.out.println("Executing job - State: " + (Object)((Object)savedJob.getJobState()) + " - Message: " + savedJob.getProgressMessage());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private ResourceIdentifier startGptPrompt(String html, String elementIdentifier) {
        ChatGPTModelQuery modelQuery = new ChatGPTModelQuery();
        modelQuery.setHtml(html);
        modelQuery.setElementDescription(elementIdentifier);
        try {
            HttpResponse jsonResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)GPTPromptService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/project/release/model/import/gpt-model/template/type/", GenerativeAIPromptTemplateType.ExtractAutomationIdentifier.toString())).header("accept", "application/json")).header("Content-Type", "application/json")).body((Object)modelQuery).asObject(ResourceIdentifier.class);
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatusText();
                return null;
            }
            return (ResourceIdentifier)jsonResponse.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return null;
        }
    }
}

