/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.jobengine.services.job;

import com.fasterxml.jackson.databind.ObjectMapper;
import ie.curiositysoftware.jobengine.dto.job.RunResultAnalysisJobResult;
import ie.curiositysoftware.jobengine.dto.job.TestCoverageEnum;
import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.jobengine.services.job.CodeGenerationService;
import ie.curiositysoftware.jobengine.services.job.TestGenerationService;
import ie.curiositysoftware.jobengine.utils.JobExecutor;
import ie.curiositysoftware.utils.RestService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.joor.Reflect;

public class FailureAnalysisService
extends RestService {
    private final TestGenerationService testGenerationService;
    private final CodeGenerationService codeGenerationService;
    private final JobExecutor jobExecutor;
    private final ObjectMapper mapper = new ObjectMapper();
    private Long jobTimeout = 60000L;
    private String serverName;
    private Long templateId = CodeGenerationService.DEFAULT_JAVA_TEMPLATE_ID;
    private Boolean includeOldTests = true;
    private TestCoverageEnum targetCoverage = TestCoverageEnum.Exhaustive;
    private List<Class<?>> newTests;

    public FailureAnalysisService(ConnectionProfile profile) {
        super(profile);
        this.testGenerationService = new TestGenerationService(profile);
        this.codeGenerationService = new CodeGenerationService(profile);
        this.jobExecutor = new JobExecutor(profile);
    }

    public FailureAnalysisService(ConnectionProfile profile, Long jobTimeout, String serverName, Long templateId, Boolean includeOldTests, TestCoverageEnum targetCoverage) {
        this(profile);
        this.jobTimeout = jobTimeout;
        this.serverName = serverName;
        this.templateId = templateId;
        this.includeOldTests = includeOldTests;
        this.targetCoverage = targetCoverage;
    }

    public Long getJobTimeout() {
        return this.jobTimeout;
    }

    public void setJobTimeout(Long jobTimeout) {
        this.jobTimeout = jobTimeout;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Boolean getIncludeOldTests() {
        return this.includeOldTests;
    }

    public TestCoverageEnum getTargetCoverage() {
        return this.targetCoverage;
    }

    public void setTargetCoverage(TestCoverageEnum targetCoverage) {
        this.targetCoverage = targetCoverage;
    }

    public void setIncludeOldTests(Boolean includeOldTests) {
        this.includeOldTests = includeOldTests;
    }

    public Boolean analyseFailures(Long profileId) {
        if (this.getServerName() == null || this.getServerName().isEmpty()) {
            this.errorMessage = "No server name provided";
            return false;
        }
        if (this.getTemplateId() == null || this.getTemplateId() <= 0L) {
            this.errorMessage = "No template ID provided";
            return false;
        }
        try {
            Long testGenJob = this.testGenerationService.startAnalysisAndGenerationJob(profileId, this.getIncludeOldTests(), null, this.getTargetCoverage());
            if (testGenJob == null) {
                this.errorMessage = "Test Generation failed: " + this.testGenerationService.getErrorMessage();
                return false;
            }
            String testGenOutputFile = this.jobResultPath(testGenJob).toString();
            if (!this.jobExecutor.waitForJob(testGenJob, testGenOutputFile, this.getJobTimeout()).booleanValue()) {
                this.errorMessage = "Test Generation failed: " + this.jobExecutor.getErrorMessage();
                return false;
            }
            String resultJson = FileUtils.readFileToString((File)new File(testGenOutputFile), (Charset)StandardCharsets.UTF_8);
            RunResultAnalysisJobResult result = (RunResultAnalysisJobResult)this.mapper.readValue(resultJson, RunResultAnalysisJobResult.class);
            Long codeGenJob = this.codeGenerationService.startTestCaseCodeGenerationJob(result.getNewSuiteId(), this.getServerName(), this.getTemplateId());
            if (codeGenJob == null) {
                this.errorMessage = "Code Generation failed: " + this.codeGenerationService.getErrorMessage();
                return false;
            }
            Path codeGenOutputFile = this.jobResultPath(codeGenJob);
            if (!this.jobExecutor.waitForJob(codeGenJob, codeGenOutputFile.toString(), this.getJobTimeout()).booleanValue()) {
                this.errorMessage = "Code Generation failed: " + this.jobExecutor.getErrorMessage();
                return false;
            }
            this.newTests = this.newTestsFromResultFile(codeGenOutputFile);
        }
        catch (IOException e) {
            this.errorMessage = e.getMessage();
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Path jobResultPath(Long jobId) {
        return Paths.get(System.getProperty("user.home"), ".testmodeller", "jobresults", jobId + ".result");
    }

    private List<Class<?>> newTestsFromResultFile(Path resultFile) throws IOException {
        String resultFileName = FilenameUtils.removeExtension((String)resultFile.getFileName().toString());
        ZipFile zipFile = new ZipFile(resultFile.toString());
        String destDir = Paths.get(resultFile.getParent().toString(), resultFileName).toString();
        try {
            zipFile.extractAll(destDir);
        }
        catch (ZipException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        ArrayList tests = new ArrayList();
        for (File javaFile : Objects.requireNonNull(Paths.get(destDir, "code").toFile().listFiles())) {
            if (!FilenameUtils.getExtension((String)javaFile.getName()).equals("java")) continue;
            String content = new String(Files.readAllBytes(javaFile.toPath()), StandardCharsets.UTF_8);
            String className = this.parseQualifiedClassName(content, FilenameUtils.removeExtension((String)javaFile.getName()));
            Class test = Reflect.compile((String)className, (String)content).type();
            tests.add(test);
        }
        return tests;
    }

    private String parseQualifiedClassName(String fileContent, String className) {
        Pattern pattern = Pattern.compile("\\bpackage\\s+((?:\\w|_|$|.)+);");
        Matcher matcher = pattern.matcher(fileContent);
        String packagePrefix = matcher.find() ? matcher.group(1) + "." : "";
        return packagePrefix + className;
    }

    public List<Class<?>> getNewTests() {
        return this.newTests;
    }
}

