/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.jobengine.services.job;

import ie.curiositysoftware.jobengine.dto.job.Job;
import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.utils.ServiceBase;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;

public class JobSubmissionService
extends ServiceBase {
    private ConnectionProfile m_ConnectionProfile;
    private String m_ErrorMessage;

    public JobSubmissionService(ConnectionProfile connectionProfile) {
        this.m_ConnectionProfile = connectionProfile;
        this.m_ErrorMessage = "";
    }

    public String getErrorMessage() {
        return this.m_ErrorMessage;
    }

    public Job getJob(long jobId) {
        try {
            HttpResponse jsonResponse = ((GetRequest)((GetRequest)Unirest.get((String)JobSubmissionService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/job/", Long.toString(jobId))).header("Content-Type", "application/json")).header("accept", "application/json")).asObject(Job.class);
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatus() + jsonResponse.getStatusText();
                return null;
            }
            return (Job)jsonResponse.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return null;
        }
    }

    public Job addJob(Job job) {
        try {
            HttpResponse jsonResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)JobSubmissionService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/job")).header("accept", "application/json")).header("Content-Type", "application/json")).body((Object)job).asObject(Job.class);
            System.out.println(jsonResponse.getStatus() + jsonResponse.getStatusText() + jsonResponse.toString());
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatusText();
                return null;
            }
            return (Job)jsonResponse.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return null;
        }
    }

    public Job cloneJobAndRun(Long jobId) {
        try {
            HttpResponse jsonResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.put((String)JobSubmissionService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/job/" + jobId + "/clone-and-run")).header("accept", "application/json")).header("Content-Type", "application/json")).asObject(Job.class);
            System.out.println(jsonResponse.getStatus() + jsonResponse.getStatusText() + jsonResponse.toString());
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatusText();
                return null;
            }
            return (Job)jsonResponse.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return null;
        }
    }
}

