/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.jobengine.utils;

import ie.curiositysoftware.jobengine.dto.job.Job;
import ie.curiositysoftware.jobengine.dto.job.JobResult;
import ie.curiositysoftware.jobengine.dto.job.JobState;
import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.jobengine.services.job.JobResultService;
import ie.curiositysoftware.jobengine.services.job.JobSubmissionService;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class JobExecutor {
    private String errorMessage = "";
    private JobSubmissionService jobSubmissionService;
    private JobResultService jobResultService;

    public JobExecutor(ConnectionProfile profile) {
        this.jobSubmissionService = new JobSubmissionService(profile);
        this.jobResultService = new JobResultService(profile);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Boolean executeJob(Job job, Long maxTime) throws IOException {
        return this.executeJob(job, null, maxTime);
    }

    public Boolean executeJob(Job job, String outputLocation, Long maxTime) throws IOException {
        Job r = this.jobSubmissionService.addJob(job);
        if (r == null || r.getId() == null) {
            this.errorMessage = "Error submiting job - " + this.jobSubmissionService.getErrorMessage();
            return false;
        }
        return this.waitForJob(r.getId(), outputLocation, maxTime);
    }

    public Boolean waitForJob(Long jobId, Long maxTime) throws IOException {
        return this.waitForJob(jobId, null, maxTime);
    }

    public Boolean waitForJob(Long jobId, String outputLocation, Long maxTime) throws IOException {
        long startTime = System.currentTimeMillis();
        while (true) {
            long ellapsed;
            if ((ellapsed = System.currentTimeMillis() - startTime) > maxTime) {
                this.errorMessage = "Maximum time elapsed";
                System.out.println(this.errorMessage);
                return false;
            }
            Job curJobStatus = this.jobSubmissionService.getJob(jobId);
            if (curJobStatus == null) break;
            if (curJobStatus.getJobState().equals((Object)JobState.Complete)) {
                this.errorMessage = "Job complete";
                System.out.println(this.errorMessage);
                break;
            }
            if (curJobStatus.getJobState().equals((Object)JobState.Error)) {
                this.errorMessage = "Error executing job " + curJobStatus.getProgressMessage();
                System.out.println(this.errorMessage);
                return false;
            }
            this.errorMessage = "Executing job - State: " + (Object)((Object)curJobStatus.getJobState()) + " - Message: " + curJobStatus.getProgressMessage();
            System.out.println(this.errorMessage);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (outputLocation != null) {
            JobResult jobResult = this.jobResultService.getResult(jobId);
            if (jobResult == null) {
                this.errorMessage = "Error retrieving result";
                System.out.println(this.errorMessage);
                return false;
            }
            FileUtils.writeByteArrayToFile((File)new File(outputLocation), (byte[])jobResult.getResultObject());
        }
        return true;
    }
}

