/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.pageobjects.elementscanner;

import ie.curiositysoftware.pageobjects.dto.PageObjectParameterEntity;
import ie.curiositysoftware.pageobjects.dto.VipAutomationSelectorEnum;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ElementExtractor {
    public static boolean updateParameter(PageObjectParameterEntity parameter, WebElement element, WebDriver driver) {
        String newIdentifier = null;
        if (parameter.getParamType().equals((Object)VipAutomationSelectorEnum.ClassName)) {
            newIdentifier = element.getAttribute("class");
        } else if (parameter.getParamType().equals((Object)VipAutomationSelectorEnum.Id)) {
            newIdentifier = element.getAttribute("id");
        } else if (parameter.getParamType().equals((Object)VipAutomationSelectorEnum.LinkText)) {
            newIdentifier = element.getText();
        } else if (parameter.getParamType().equals((Object)VipAutomationSelectorEnum.Name)) {
            newIdentifier = element.getAttribute("name");
        } else if (parameter.getParamType().equals((Object)VipAutomationSelectorEnum.TagName)) {
            newIdentifier = element.getTagName();
        } else if (parameter.getParamType().equals((Object)VipAutomationSelectorEnum.XPath)) {
            newIdentifier = ElementExtractor.GetElementXPath(element, driver);
        } else {
            System.out.println("Unsupported identifier reusing old value - " + (Object)((Object)parameter.getParamType()));
            newIdentifier = parameter.getParamValue();
        }
        if (newIdentifier != null && newIdentifier.length() > 0) {
            parameter.setParamValue(newIdentifier);
            By identifer = ElementExtractor.GetElementIdentifierForParameter(parameter);
            if (identifer == null) {
                parameter.setConfidence(0.0);
                return true;
            }
            try {
                List elem = driver.findElements(identifer);
                if (elem.size() == 0) {
                    parameter.setConfidence(0.0);
                } else {
                    parameter.setConfidence(1.0f / (float)elem.size());
                }
            }
            catch (Exception e) {
                parameter.setConfidence(0.0);
            }
            return true;
        }
        parameter.setConfidence(0.0);
        return false;
    }

    public static By GetElementIdentifierForParameter(PageObjectParameterEntity parameterEntity) {
        if (parameterEntity.getParamType().equals((Object)VipAutomationSelectorEnum.ClassName)) {
            return By.className((String)parameterEntity.getParamValue());
        }
        if (parameterEntity.getParamType().equals((Object)VipAutomationSelectorEnum.CssSelector)) {
            return By.cssSelector((String)parameterEntity.getParamValue());
        }
        if (parameterEntity.getParamType().equals((Object)VipAutomationSelectorEnum.Id)) {
            return By.id((String)parameterEntity.getParamValue());
        }
        if (parameterEntity.getParamType().equals((Object)VipAutomationSelectorEnum.LinkText)) {
            return By.linkText((String)parameterEntity.getParamValue());
        }
        if (parameterEntity.getParamType().equals((Object)VipAutomationSelectorEnum.Name)) {
            return By.name((String)parameterEntity.getParamValue());
        }
        if (parameterEntity.getParamType().equals((Object)VipAutomationSelectorEnum.PartialLinkText)) {
            return By.partialLinkText((String)parameterEntity.getParamValue());
        }
        if (parameterEntity.getParamType().equals((Object)VipAutomationSelectorEnum.TagName)) {
            return By.tagName((String)parameterEntity.getParamValue());
        }
        if (parameterEntity.getParamType().equals((Object)VipAutomationSelectorEnum.XPath)) {
            return By.xpath((String)parameterEntity.getParamValue());
        }
        return null;
    }

    public static String GetElementXPath(WebElement element, WebDriver driver) {
        return (String)((JavascriptExecutor)driver).executeScript("getXPath=function(node){if (node.id !== ''){return '//' + node.tagName.toLowerCase() + '[@id=\"' + node.id + '\"]'}if (node === document.body){return node.tagName.toLowerCase()}var nodeCount = 0;var childNodes = node.parentNode.childNodes;for (var i=0; i<childNodes.length; i++){var currentNode = childNodes[i];if (currentNode === node){return getXPath(node.parentNode) + '/' + node.tagName.toLowerCase() + '[' + (nodeCount+1) + ']'}if (currentNode.nodeType === 1 && currentNode.tagName.toLowerCase() === node.tagName.toLowerCase()){nodeCount++}}};return getXPath(arguments[0]);", new Object[]{element});
    }
}

