/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.pageobjects.services;

import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.pageobjects.dto.PageObjectEntity;
import ie.curiositysoftware.pageobjects.dto.PageObjectHistoryEntity;
import ie.curiositysoftware.pageobjects.dto.PageObjectParameterEntity;
import ie.curiositysoftware.utils.ServiceBase;
import ie.curiositysoftware.utils.UnirestHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;

public class PageObjectService
extends ServiceBase {
    private ConnectionProfile m_ConnectionProfile;
    private String m_ErrorMessage;

    public PageObjectService(ConnectionProfile connectionProfile) {
        this.m_ConnectionProfile = connectionProfile;
        this.m_ErrorMessage = "";
    }

    public String GetErrorMessage() {
        return this.m_ErrorMessage;
    }

    public Boolean AddPageObjectHistory(PageObjectHistoryEntity pageObjectHistoryEntity) {
        try {
            HttpResponse jsonResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)PageObjectService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/page-collection/page-object/page-object-history")).header("accept", "application/json")).header("Content-Type", "application/json")).body((Object)pageObjectHistoryEntity).asJson();
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatusText();
                return false;
            }
            return true;
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return false;
        }
    }

    public Boolean UpdatePageObjectParameter(PageObjectParameterEntity pageObjectParameter) {
        try {
            HttpResponse jsonResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.put((String)PageObjectService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/page-collection/page-object/page-object-param")).header("accept", "application/json")).header("Content-Type", "application/json")).body((Object)pageObjectParameter).asJson();
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatusText();
                return false;
            }
            return true;
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return false;
        }
    }

    public Boolean UpdatePageObject(PageObjectEntity pageObjectEntity) {
        try {
            HttpResponse jsonResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.put((String)PageObjectService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/page-collection/page-object")).header("accept", "application/json")).header("Content-Type", "application/json")).body((Object)pageObjectEntity).asJson();
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatusText();
                return false;
            }
            return true;
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return false;
        }
    }

    public PageObjectEntity GetPageObject(String pageObjectName) {
        UnirestHelper.initUnirestMapper();
        try {
            String pattern = "\\[(?<projectName>[^\\[]*)\\]\\[(?<releaseName>[^\\[]*)\\]\\[(?<pColName>[^\\[]*)\\]\\[(?<objectName>[^\\[]*)\\]";
            Pattern patternRegex = Pattern.compile(pattern);
            Matcher matcher = patternRegex.matcher(pageObjectName);
            if (!matcher.find()) {
                return null;
            }
            PageObjectSearchCriteria poSearchCriteria = new PageObjectSearchCriteria();
            poSearchCriteria.project = matcher.group("projectName");
            poSearchCriteria.release = matcher.group("releaseName");
            poSearchCriteria.pageCollection = matcher.group("pColName");
            poSearchCriteria.objectName = matcher.group("objectName");
            HttpResponse jsonResponse = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)PageObjectService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/project/release/page-collection/page-object/criteria")).header("accept", "application/json")).header("Content-Type", "application/json")).body((Object)poSearchCriteria).asObject(PageObjectEntity.class);
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatusText();
                return null;
            }
            return (PageObjectEntity)jsonResponse.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return null;
        }
    }

    public PageObjectEntity GetPageObject(long pageId) {
        UnirestHelper.initUnirestMapper();
        try {
            HttpResponse jsonResponse = ((GetRequest)((GetRequest)Unirest.get((String)PageObjectService.createURLs(this.m_ConnectionProfile.getAPIUrl(), "api/apikey/", this.m_ConnectionProfile.getAPIKey(), "/page-collection/page-object/", Long.toString(pageId))).header("accept", "application/json")).header("Content-Type", "application/json")).asObject(PageObjectEntity.class);
            if (jsonResponse.getStatus() != 200) {
                this.m_ErrorMessage = jsonResponse.getStatusText();
                return null;
            }
            return (PageObjectEntity)jsonResponse.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.m_ErrorMessage = e.getMessage();
            return null;
        }
    }

    public static class PageObjectSearchCriteria {
        public String project;
        public String release;
        public String pageCollection;
        public String objectName;
    }
}

