/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.tdm.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import ie.curiositysoftware.datacatalogue.DataListRowDto;
import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import ie.curiositysoftware.utils.RestResponsePage;
import ie.curiositysoftware.utils.ServiceBase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.springframework.data.domain.PageImpl;

public class DataListService
extends ServiceBase {
    ConnectionProfile m_ConnectionProfile;
    String m_ErrorMessage;

    public DataListService(ConnectionProfile connectionProfile) {
        this.m_ConnectionProfile = connectionProfile;
    }

    static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public PageImpl<DataListRowDto> GetDataListRows(Long listID, String query, String select) {
        try {
            HttpResponse postResponse;
            String url = DataListService.createURLs(this.m_ConnectionProfile.getTDMUrl(), "apikey/", this.m_ConnectionProfile.getAPIKey(), "/metadata/lists/", listID.toString(), "/rows");
            String prepend = "?";
            if (!query.isEmpty()) {
                url = url + prepend + "where=" + DataListService.urlEncodeUTF8(query);
                prepend = "&";
            }
            if (!select.isEmpty()) {
                url = url + prepend + "select=" + DataListService.urlEncodeUTF8(select);
                prepend = "&";
            }
            if ((postResponse = ((GetRequest)((GetRequest)Unirest.get((String)url).header("accept", "application/json")).header("Content-Type", "application/json")).asObject(JsonNode.class)).getStatus() == 200) {
                JsonNode node = (JsonNode)postResponse.getBody();
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                ObjectReader reader = objectMapper.readerFor((TypeReference)new TypeReference<RestResponsePage<DataListRowDto>>(){});
                return (PageImpl)reader.readValue(node);
            }
            this.m_ErrorMessage = postResponse.getStatus() + " - " + postResponse.getStatusText();
            return null;
        }
        catch (Exception e) {
            this.m_ErrorMessage = e.getMessage();
            e.printStackTrace();
            return null;
        }
    }

    public String getErrorMessage() {
        return this.m_ErrorMessage;
    }
}

