/*
 * Decompiled with CFR 0.152.
 */
package ie.curiositysoftware.utils;

import ie.curiositysoftware.jobengine.services.ConnectionProfile;
import kong.unirest.HttpRequest;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;

public class RestService {
    protected ConnectionProfile connectionProfile;
    protected String errorMessage = "";

    public RestService(ConnectionProfile connectionProfile) {
        this.connectionProfile = connectionProfile;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected <T> T execute(HttpRequest request, Class<? extends T> responseClass) {
        try {
            HttpResponse jsonResponse = request.header("Content-Type", "application/json").header("accept", "application/json").asObject(responseClass);
            if (jsonResponse.getStatus() != 200) {
                this.errorMessage = jsonResponse.getStatus() + jsonResponse.getStatusText();
                return null;
            }
            return (T)jsonResponse.getBody();
        }
        catch (UnirestException e) {
            e.printStackTrace();
            this.errorMessage = e.getMessage();
            return null;
        }
    }

    protected String getUrl(String path) {
        return this.connectionProfile.getAPIUrl() + "api/apikey/" + this.connectionProfile.getAPIKey() + path;
    }
}

