/*
 * Decompiled with CFR 0.152.
 */
package com.twelfthmile.yuga;

import com.twelfthmile.yuga.YugaMethods;
import com.twelfthmile.yuga.types.GenTrie;
import com.twelfthmile.yuga.types.Pair;
import com.twelfthmile.yuga.types.Response;
import com.twelfthmile.yuga.types.RootTrie;
import com.twelfthmile.yuga.utils.Constants;
import com.twelfthmile.yuga.utils.FsaContextMap;
import com.twelfthmile.yuga.utils.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Yuga {
    private static final boolean D_DEBUG = false;

    public static void init() {
        RootTrie root = Yuga.getRoot();
    }

    private static RootTrie getRoot() {
        return LazyHolder.root;
    }

    private static RootTrie createRoot() {
        RootTrie root = new RootTrie();
        root.next.put("FSA_MONTHS", new GenTrie());
        root.next.put("FSA_DAYS", new GenTrie());
        root.next.put("FSA_TIMEPRFX", new GenTrie());
        root.next.put("FSA_AMT", new GenTrie());
        root.next.put("FSA_TIMES", new GenTrie());
        root.next.put("FSA_TZ", new GenTrie());
        root.next.put("FSA_DAYSFFX", new GenTrie());
        root.next.put("FSA_UPI", new GenTrie());
        root.next.put("FSA_DAYRANGE", new GenTrie());
        Yuga.seeding("jan;uary,feb;r;uary,mar;ch,apr;il,may,jun;e,jul;y,aug;ust,sep;t;ember,oct;ober,nov;ember,dec;ember", root.next.get("FSA_MONTHS"));
        Yuga.seeding("sun;day,mon;day,tue;sday,wed;nesday,thu;rsday,thur;sday,fri;day,sat;urday", root.next.get("FSA_DAYS"));
        Yuga.seeding("at,on,before,by", root.next.get("FSA_TIMEPRFX"));
        Yuga.seeding("lac,lakh,k", root.next.get("FSA_AMT"));
        Yuga.seeding("hours,hrs,hr,mins,minutes", root.next.get("FSA_TIMES"));
        Yuga.seeding("gmt,ist", root.next.get("FSA_TZ"));
        Yuga.seeding("st,nd,rd,th", root.next.get("FSA_DAYSFFX"));
        Yuga.seeding("UPI,MMT,NEFT", root.next.get("FSA_UPI"));
        Yuga.seeding("day;s,work days,working days,business days", root.next.get("FSA_DAYRANGE"));
        return root;
    }

    private static void seeding(String type, GenTrie root) {
        int c = 0;
        for (String fsaCldr : type.split(",")) {
            ++c;
            GenTrie t = root;
            int len = fsaCldr.length();
            for (int i = 0; i < len; ++i) {
                char ch = fsaCldr.charAt(i);
                t.child = true;
                if (!t.next.containsKey(Character.valueOf(ch))) {
                    t.next.put(Character.valueOf(ch), new GenTrie());
                }
                t = t.next.get(Character.valueOf(ch));
                if (i == len - 1) {
                    t.leaf = true;
                    t.token = fsaCldr.replace(";", "");
                    continue;
                }
                if (i >= len - 1 || fsaCldr.charAt(i + 1) != ';') continue;
                t.leaf = true;
                t.token = fsaCldr.replace(";", "");
                ++i;
            }
        }
    }

    public static Pair<Integer, Date> parseDate(String str) {
        Map<String, String> configMap = Yuga.generateDefaultConfig();
        return Yuga.getIntegerDatePair(str, configMap);
    }

    private static Pair<Integer, Date> getIntegerDatePair(String str, Map<String, String> configMap) {
        Pair<Integer, FsaContextMap> p = Yuga.parseInternal(str, configMap);
        if (p == null) {
            return null;
        }
        Date d = p.getB().getDate(configMap);
        if (d == null) {
            return null;
        }
        return new Pair<Integer, Date>(p.getA(), d);
    }

    public static Pair<Integer, Date> parseDate(String str, Map<String, String> config) {
        return Yuga.getIntegerDatePair(str, config);
    }

    public static Response parse(String str, Map<String, String> config) {
        return Yuga.getResponse(str, config);
    }

    private static Response getResponse(String str, Map<String, String> config) {
        Pair<Integer, FsaContextMap> p = Yuga.parseInternal(str, config);
        if (p == null) {
            return null;
        }
        Pair<String, Object> pr = Yuga.prepareResult(str, p, config);
        return new Response(pr.getA(), p.getB().getValMap(), pr.getB(), p.getA());
    }

    public static Response parse(String str) {
        Map<String, String> configMap = Yuga.generateDefaultConfig();
        return Yuga.getResponse(str, configMap);
    }

    private static Pair<String, Object> prepareResult(String str, Pair<Integer, FsaContextMap> p, Map<String, String> config) {
        int index = p.getA();
        FsaContextMap map = p.getB();
        if (map.getType().equals("DATE")) {
            if (map.contains("MMM") && map.size() < 3) {
                return new Pair<String, Object>("STR", str.substring(0, index));
            }
            if (!(!map.contains("HH") || !map.contains("mm") || map.contains("d") || map.contains("dd") || map.contains("MM") || map.contains("MMM") || map.contains("yy") || map.contains("yyyy"))) {
                map.setType("TIME", null);
                map.setVal("time", map.get("HH") + ":" + map.get("mm"));
                return new Pair<String, Object>("TIME", str.substring(0, index));
            }
            Date d = map.getDate(config);
            if (d != null) {
                return new Pair<String, Object>(p.getB().getType(), d);
            }
            return new Pair<String, Object>("STR", str.substring(0, index));
        }
        if (map.get(map.getType()) != null) {
            if (map.getType().equals("INSTRNO") && Yuga.configContextIsCURR(config)) {
                return new Pair<String, Object>("AMT", map.get(map.getType()).replaceAll("X", ""));
            }
            return new Pair<String, Object>(p.getB().getType(), map.get(map.getType()));
        }
        return new Pair<String, Object>(p.getB().getType(), str.substring(0, index));
    }

    private static Map<String, String> generateDefaultConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("YUGA_CONF_DATE", Constants.dateTimeFormatter().format(new Date()));
        return config;
    }

    public static Pair<Integer, String> checkTypes(String type, String word) {
        return Util.checkTypes(Yuga.getRoot(), type, word);
    }

    private static Pair<Integer, FsaContextMap> parseInternal(String str, Map<String, String> config) {
        char c2;
        int i;
        int state = 1;
        int comma_count = 1;
        boolean haveSeenAComma = false;
        FsaContextMap map = new FsaContextMap();
        DelimiterStack delimiterStack = new DelimiterStack();
        str = str.toLowerCase();
        int counter = 0;
        ArrayList<Integer> prevStates = new ArrayList<Integer>();
        prevStates.add(state);
        block46: for (i = 0; state > 0 && i < str.length(); ++i) {
            char c = str.charAt(i);
            if ((Integer)prevStates.get(prevStates.size() - 1) != state) {
                prevStates.add(state);
            }
            switch (state) {
                case 1: {
                    if (Util.isNumber(c)) {
                        map.setType("NUM", null);
                        map.put("NUM", c);
                        state = 2;
                        continue block46;
                    }
                    Pair<Integer, String> p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i));
                    if (p != null) {
                        map.setType("DATE", null);
                        map.put("MMM", p.getB());
                        i += p.getA().intValue();
                        state = 33;
                        continue block46;
                    }
                    p = Util.checkTypes(Yuga.getRoot(), "FSA_DAYS", str.substring(i));
                    if (p != null) {
                        map.setType("DATE", null);
                        map.put("dd", p.getB());
                        i += p.getA().intValue();
                        state = 30;
                        continue block46;
                    }
                    if (c == '-') {
                        state = 37;
                        continue block46;
                    }
                    if (c == '[') {
                        state = 1;
                        continue block46;
                    }
                    state = Yuga.accAmtNumPct(str, i, map, config);
                    if (map.getType() == null) {
                        return null;
                    }
                    if (state != -1 || map.getType().equals("PCT")) continue block46;
                    --i;
                    continue block46;
                }
                case 2: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 3;
                        continue block46;
                    }
                    if (Util.isTimeOperator(c)) {
                        delimiterStack.push(c);
                        map.setType("DATE", "HH");
                        state = 4;
                        continue block46;
                    }
                    if (Util.isDateOperator(c) || c == ',') {
                        if (c == ' ' && Util.meridienTimeAhead(str, i + 1)) {
                            map.setType("DATE", "HH");
                            map.put("mm", "00");
                            state = 7;
                            continue block46;
                        }
                        delimiterStack.push(c);
                        map.setType("DATE", "d");
                        state = 16;
                        continue block46;
                    }
                    Pair<Integer, String> p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i));
                    if (p != null) {
                        map.setType("DATE", "d");
                        map.put("MMM", p.getB());
                        i += p.getA().intValue();
                        state = 24;
                        continue block46;
                    }
                    if (Util.meridienTimeAhead(str, i)) {
                        map.setType("DATE", "HH");
                        map.put("mm", "00");
                        --i;
                        state = 7;
                        continue block46;
                    }
                    state = Yuga.accAmtNumPct(str, i, map, config);
                    if (state != -1 || map.getType().equals("PCT")) continue block46;
                    --i;
                    continue block46;
                }
                case 3: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 8;
                        continue block46;
                    }
                    if (Util.isTimeOperator(c)) {
                        delimiterStack.push(c);
                        map.setType("DATE", "HH");
                        state = 4;
                        continue block46;
                    }
                    if (Util.isDateOperator(c) && !Yuga.configContextIsCURR(config) || c == ',') {
                        if (c == ',') {
                            haveSeenAComma = true;
                        }
                        if (c == ' ' && Util.meridienTimeAhead(str, i + 1)) {
                            map.setType("DATE", "HH");
                            map.put("mm", "00");
                            state = 7;
                            continue block46;
                        }
                        delimiterStack.push(c);
                        map.setType("DATE", "d");
                        state = 16;
                        continue block46;
                    }
                    Pair<Integer, String> p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i));
                    if (p != null) {
                        map.setType("DATE", "d");
                        map.put("MMM", p.getB());
                        i += p.getA().intValue();
                        state = 24;
                        continue block46;
                    }
                    if (Util.meridienTimeAhead(str, i)) {
                        map.setType("DATE", "HH");
                        map.put("mm", "00");
                        --i;
                        state = 7;
                        continue block46;
                    }
                    p = Util.checkTypes(Yuga.getRoot(), "FSA_DAYSFFX", str.substring(i));
                    if (p != null) {
                        map.setType("DATE", "d");
                        i += p.getA().intValue();
                        state = 32;
                        continue block46;
                    }
                    state = Yuga.accAmtNumPct(str, i, map, config);
                    if (state != -1 || map.getType().equals("PCT")) continue block46;
                    --i;
                    continue block46;
                }
                case 4: {
                    if (Util.isNumber(c)) {
                        map.upgrade(c);
                        state = 5;
                        continue block46;
                    }
                    if (!map.contains("MMM")) {
                        map.setType("NUM", "NUM");
                    }
                    i -= 2;
                    state = -1;
                    continue block46;
                }
                case 5: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 5;
                        continue block46;
                    }
                    if (c == ':') {
                        state = 6;
                        continue block46;
                    }
                    if (c == 'a' && i + 1 < str.length() && str.charAt(i + 1) == 'm') {
                        ++i;
                        state = -1;
                        continue block46;
                    }
                    if (c == 'p' && i + 1 < str.length() && str.charAt(i + 1) == 'm') {
                        map.put("HH", String.valueOf(Integer.parseInt(map.get("HH")) + 12));
                        ++i;
                        state = -1;
                        continue block46;
                    }
                    Pair<Integer, String> p = Util.checkTypes(Yuga.getRoot(), "FSA_TIMES", str.substring(i));
                    if (p != null) {
                        i += p.getA().intValue();
                        state = -1;
                        continue block46;
                    }
                    state = 7;
                    continue block46;
                }
                case 6: {
                    if (Util.isNumber(c)) {
                        map.upgrade(c);
                        if (i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                            map.append(str.charAt(i + 1));
                        }
                        ++i;
                        state = -1;
                        continue block46;
                    }
                    state = -1;
                    continue block46;
                }
                case 7: {
                    Pair<Integer, String> p;
                    if (c == 'a' && i + 1 < str.length() && str.charAt(i + 1) == 'm') {
                        ++i;
                        int hh = Integer.parseInt(map.get("HH"));
                        if (hh == 12) {
                            map.put("HH", String.valueOf(0));
                        }
                    } else if (c == 'p' && i + 1 < str.length() && str.charAt(i + 1) == 'm') {
                        int hh = Integer.parseInt(map.get("HH"));
                        if (hh < 12) {
                            map.put("HH", String.valueOf(hh + 12));
                        } else if (hh > 12) {
                            map.put("HH", String.valueOf(hh));
                        }
                        ++i;
                    } else {
                        p = Util.checkTypes(Yuga.getRoot(), "FSA_TIMES", str.substring(i));
                        i = p != null ? (i += p.getA().intValue()) : (i -= 2);
                    }
                    state = -1;
                    continue block46;
                }
                case 8: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 9;
                        continue block46;
                    }
                    state = Yuga.accAmtNumPct(str, i, map, config);
                    if (c == ' ' && state == -1 && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1)) && !Yuga.configContextIsCURR(config)) {
                        state = 12;
                        continue block46;
                    }
                    if (c == '-' && state == -1 && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1)) && !Yuga.configContextIsCURR(config)) {
                        state = 45;
                        continue block46;
                    }
                    if (state != -1 || map.getType().equals("PCT")) continue block46;
                    --i;
                    continue block46;
                }
                case 9: {
                    if (Util.isDateOperator(c)) {
                        if (!Yuga.configContextIsCURR(config)) {
                            delimiterStack.push(c);
                            state = 25;
                            continue block46;
                        }
                        state = -1;
                        continue block46;
                    }
                    if (Util.isNumber(c)) {
                        map.append(c);
                        counter = 5;
                        state = 15;
                        continue block46;
                    }
                    if (c == ',') {
                        delimiterStack.push(c);
                    }
                    if ((state = Yuga.accAmtNumPct(str, i, map, config)) != -1 || map.getType().equals("PCT")) continue block46;
                    --i;
                    continue block46;
                }
                case 10: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        map.setType("AMT", "AMT");
                        state = 14;
                        continue block46;
                    }
                    map.pop();
                    i -= 2;
                    state = -1;
                    continue block46;
                }
                case 11: {
                    int insi;
                    if (c == '*' || c == 'X' || c == 'x') {
                        map.append('X');
                        continue block46;
                    }
                    if (c == '-') {
                        state = 11;
                        continue block46;
                    }
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 13;
                        continue block46;
                    }
                    if (c == ' ' && i + 1 < str.length() && (str.charAt(i + 1) == '*' || str.charAt(i + 1) == 'X' || str.charAt(i + 1) == 'x' || Util.isNumber(str.charAt(i + 1)))) {
                        state = 11;
                        continue block46;
                    }
                    if (c == '.' && (insi = YugaMethods.lookAheadForInstr(str, i)) > 0) {
                        for (int x = insi - i; x > 0; --x) {
                            map.append('X');
                        }
                        i = Util.isNumber(str.charAt(insi)) ? insi - 1 : insi;
                        continue block46;
                    }
                    --i;
                    state = -1;
                    continue block46;
                }
                case 12: {
                    Pair<Integer, String> p;
                    if (Util.isNumber(c)) {
                        if (i > 2 && str.charAt(i - 1) == ' ' && Util.isNumber(str.charAt(i - 2)) || delimiterStack.pop() == '/') {
                            map.append(c);
                            if (map.contains("NUM")) {
                                // empty if block
                            }
                            counter = map.get("NUM").length();
                            state = 15;
                            continue block46;
                        }
                        map.setType("AMT", "AMT");
                        map.append(c);
                        continue block46;
                    }
                    if (c == ',') {
                        ++comma_count;
                        state = 12;
                        continue block46;
                    }
                    if (c == '.') {
                        map.append(c);
                        state = 10;
                        continue block46;
                    }
                    if (c == '-' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                        state = 39;
                        continue block46;
                    }
                    if (Yuga.getPrevState(prevStates) == 37 && c == '-' && (p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i + 1))) != null) {
                        i = -1;
                        map = new FsaContextMap();
                        str = str.substring(1);
                        state = 1;
                        continue block46;
                    }
                    if (c == ' ' && YugaMethods.lookAheadForNum(str, i) != -1) {
                        if (delimiterStack.pop() == ',') {
                            state = -1;
                            continue block46;
                        }
                        state = 15;
                        continue block46;
                    }
                    if (i - 1 > 0 && str.charAt(i - 1) == ',') {
                        i -= 2;
                    } else if (i - 3 > 0 && str.charAt(i - 3) == ',' && comma_count == 1) {
                        char c1 = map.pop();
                        c2 = map.pop();
                        map.append('.');
                        map.append(c2);
                        map.append(c1);
                    } else {
                        --i;
                    }
                    if (comma_count > 1 && comma_count < 4 && map.getType().equals("AMT")) {
                        map.setType("NUM", "NUM");
                    } else if (comma_count >= 4 && map.getType().equals("AMT")) {
                        map.remove(map.getType());
                        map.remove("TYP");
                    }
                    state = -1;
                    continue block46;
                }
                case 13: {
                    int insi;
                    if (Util.isNumber(c)) {
                        map.append(c);
                        continue block46;
                    }
                    if (c == '*' || c == 'X' || c == 'x') {
                        map.append('X');
                        continue block46;
                    }
                    if (c == '.' && Yuga.configContextIsCURR(config)) {
                        map.setType("AMT", "AMT");
                        map.put("AMT", map.get("AMT").replaceAll("X", ""));
                        map.append(c);
                        state = 10;
                        continue block46;
                    }
                    if (c == '.' && (insi = YugaMethods.lookAheadForInstr(str, i)) > 0) {
                        for (int x = insi - i; x > 0; --x) {
                            map.append('X');
                        }
                        i = Util.isNumber(str.charAt(insi)) ? insi - 1 : insi;
                        continue block46;
                    }
                    if (c == '#' && (i == str.length() - 1 || str.charAt(i + 1) == ' ')) {
                        map.setType("USSD");
                        continue block46;
                    }
                    --i;
                    state = -1;
                    continue block46;
                }
                case 14: {
                    String[] samtarr;
                    String samt;
                    if (Util.isNumber(c)) {
                        map.append(c);
                        continue block46;
                    }
                    if (c == '%') {
                        map.setType("PCT", "PCT");
                        state = -1;
                        continue block46;
                    }
                    if ((c == 'k' || c == 'c') && i + 1 < str.length() && str.charAt(i + 1) == 'm') {
                        map.setType("DST", "DST");
                        ++i;
                        state = -1;
                        continue block46;
                    }
                    if ((c == 'k' || c == 'm') && i + 1 < str.length() && str.charAt(i + 1) == 'g') {
                        map.setType("WGT", "WGT");
                        ++i;
                        state = -1;
                        continue block46;
                    }
                    if (c == '.' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1)) && (samt = map.get(map.getType())).contains(".") && (samtarr = samt.split("\\.")).length == 2) {
                        map.setType("DATE");
                        map.put("d", samtarr[0]);
                        map.put("MM", samtarr[1]);
                        state = 19;
                        continue block46;
                    }
                    --i;
                    state = -1;
                    continue block46;
                }
                case 15: {
                    if (Util.isNumber(c)) {
                        ++counter;
                        map.append(c);
                        continue block46;
                    }
                    if (c == ',' && counter < 10) {
                        state = 12;
                        continue block46;
                    }
                    if (c == '.') {
                        map.append(c);
                        state = 10;
                        continue block46;
                    }
                    if (!(c != '*' && c != 'X' && c != 'x' || i + 1 >= str.length() || !Util.isNumber(str.charAt(i + 1)) && str.charAt(i + 1) != '-' && str.charAt(i + 1) != '*' && str.charAt(i + 1) != 'X' && str.charAt(i + 1) != 'x')) {
                        map.setType("INSTRNO", "INSTRNO");
                        map.append('X');
                        state = 11;
                        continue block46;
                    }
                    if (c == ' ' && counter >= 5 && counter < 10 && !Yuga.configContextIsCURR(config) && i + 2 < str.length() && Util.isNumber(str.charAt(i + 1)) && Util.isNumber(str.charAt(i + 2))) {
                        state = 41;
                        continue block46;
                    }
                    --i;
                    state = -1;
                    continue block46;
                }
                case 16: {
                    if (Util.isNumber(c)) {
                        map.upgrade(c);
                        state = 17;
                        continue block46;
                    }
                    if (c == ' ' || c == ',') {
                        state = 16;
                        continue block46;
                    }
                    Pair<Integer, String> p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i));
                    if (p != null) {
                        map.put("MMM", p.getB());
                        i += p.getA().intValue();
                        state = 24;
                        continue block46;
                    }
                    if (c == '.') {
                        map.setType("NUM", "NUM");
                        map.append(c);
                        state = 10;
                        continue block46;
                    }
                    if (i > 0 && (p = Util.checkTypes(Yuga.getRoot(), "FSA_TIMES", str.substring(i))) != null) {
                        map.setType("TIME", null);
                        String s = str.substring(0, i);
                        if (p.getB().equals("mins") || p.getB().equals("minutes")) {
                            s = "00" + s;
                        }
                        Yuga.extractTime(s, map.getValMap(), new String[0]);
                        i += p.getA().intValue();
                        state = -1;
                        continue block46;
                    }
                    if (delimiterStack.pop() == ' ' && c == '-' && i + 1 < str.length() && (Util.isNumber(str.charAt(i + 1)) || (p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i + 1))) != null)) {
                        state = 16;
                        continue block46;
                    }
                    map.setType("NUM", "NUM");
                    int j = i;
                    while (!Util.isNumber(str.charAt(j))) {
                        --j;
                    }
                    i = j;
                    state = -1;
                    continue block46;
                }
                case 17: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 18;
                        continue block46;
                    }
                    if (Util.isDateOperator(c)) {
                        delimiterStack.push(c);
                        state = 19;
                        continue block46;
                    }
                    if (c == ',' && delimiterStack.pop() == ',') {
                        map.setType("NUM", "NUM");
                        state = 12;
                        continue block46;
                    }
                    if (c == '.' && delimiterStack.pop() == ',') {
                        map.setType("NUM", "NUM");
                        map.append(c);
                        state = 10;
                        continue block46;
                    }
                    map.setType("STR", "STR");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 18: {
                    if (Util.isDateOperator(c)) {
                        delimiterStack.push(c);
                        state = 19;
                        continue block46;
                    }
                    if (Util.isNumber(c) && delimiterStack.pop() == ',') {
                        map.setType("NUM", "NUM");
                        state = 12;
                        map.append(c);
                        continue block46;
                    }
                    if (Util.isNumber(c) && delimiterStack.pop() == '-') {
                        map.setType("NUM", "NUM");
                        state = 42;
                        map.append(c);
                        continue block46;
                    }
                    if (c == ',' && delimiterStack.pop() == ',') {
                        map.setType("NUM", "NUM");
                        state = 12;
                        continue block46;
                    }
                    if (c == '.' && delimiterStack.pop() == ',') {
                        map.setType("NUM", "NUM");
                        map.append(c);
                        state = 10;
                        continue block46;
                    }
                    if (c == '.' && map.contains("d") && map.contains("MM")) {
                        state = -1;
                        continue block46;
                    }
                    map.setType("STR", "STR");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 19: {
                    if (Util.isNumber(c)) {
                        map.upgrade(c);
                        state = 20;
                        continue block46;
                    }
                    if (c == '-' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                        state = 19;
                        continue block46;
                    }
                    i -= 2;
                    state = -1;
                    continue block46;
                }
                case 20: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 21;
                        continue block46;
                    }
                    if (c == ':') {
                        if (map.contains("yy")) {
                            map.convert("yy", "HH");
                        } else if (map.contains("yyyy")) {
                            map.convert("yyyy", "HH");
                        }
                        state = 4;
                        continue block46;
                    }
                    map.remove("yy");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 21: {
                    if (Util.isNumber(c)) {
                        map.upgrade(c);
                        state = 22;
                        continue block46;
                    }
                    if (c == ':') {
                        if (map.contains("yy")) {
                            map.convert("yy", "HH");
                        } else if (map.contains("yyyy")) {
                            map.convert("yyyy", "HH");
                        }
                        state = 4;
                        continue block46;
                    }
                    --i;
                    state = -1;
                    continue block46;
                }
                case 22: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = -1;
                        continue block46;
                    }
                    map.remove("yyyy");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 24: {
                    if (Util.isDateOperator(c) || c == ',') {
                        delimiterStack.push(c);
                        state = 24;
                        continue block46;
                    }
                    if (Util.isNumber(c)) {
                        if (YugaMethods.lookAheadForMerid(str, i)) {
                            state = -1;
                            i -= 2;
                            continue block46;
                        }
                        map.upgrade(c);
                        state = 20;
                        continue block46;
                    }
                    if (c == '\'' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                        state = 24;
                        continue block46;
                    }
                    if (c == '|') {
                        state = 24;
                        continue block46;
                    }
                    --i;
                    state = -1;
                    continue block46;
                }
                case 25: {
                    if (Util.isNumber(c)) {
                        map.setType("DATE", "yyyy");
                        map.put("MM", c);
                        state = 26;
                        continue block46;
                    }
                    Pair<Integer, String> p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i));
                    if (p != null) {
                        if (map.getType().equals("NUM") && map.get(map.getType()).length() == 4) {
                            map.put("yyyy", map.get("NUM"));
                            map.remove("NUM");
                            map.setType("DATE");
                        }
                        map.put("MMM", p.getB());
                        i += p.getA().intValue();
                        state = 27;
                        continue block46;
                    }
                    if (i > 0 && (p = Util.checkTypes(Yuga.getRoot(), "FSA_TIMES", str.substring(i))) != null) {
                        map.setType("TIME", null);
                        String s = str.substring(0, i);
                        if (p.getB().equals("mins")) {
                            s = "00" + s;
                        }
                        Yuga.extractTime(s, map.getValMap(), new String[0]);
                        i += p.getA().intValue();
                        state = -1;
                        continue block46;
                    }
                    if (i + 2 < str.length() && str.substring(i, i + 2).equals("ai")) {
                        map.setType("TAGNUM", null);
                        map.put("TAGNUM", map.get("NUM") + str.substring(i, i + 2).toUpperCase());
                        map.remove("NUM");
                        ++i;
                        state = 26;
                        continue block46;
                    }
                    i -= 2;
                    state = -1;
                    continue block46;
                }
                case 26: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 27;
                        continue block46;
                    }
                    if (c == '-' && map.getType() == "TAGNUM") {
                        if (i + 6 >= str.length()) continue block46;
                        map.put("TAGNUM", map.get("TAGNUM") + str.substring(i + 1, i + 7));
                        i += 6;
                        state = -1;
                        continue block46;
                    }
                    map.setType("STR", "STR");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 27: {
                    if (Util.isDateOperator(c)) {
                        delimiterStack.push(c);
                        state = 28;
                        continue block46;
                    }
                    if (Util.isNumber(c)) {
                        if (map.getType().equals("DATE")) {
                            map.setType("NUM", "NUM");
                        }
                        map.append(c);
                        boolean checkIfPossTimeRange = Util.checkForTimeRange(map.get("NUM"));
                        if ((delimiterStack.pop() == '/' || delimiterStack.pop() == '-') && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1)) && (i + 2 == str.length() || Util.isDelimiter(str.charAt(i + 2)) || str.charAt(i + 2) == '/') && checkIfPossTimeRange) {
                            map.setType("TIMES", "TIMES");
                            map.append(str.charAt(i + 1));
                            ++i;
                            state = -1;
                            continue block46;
                        }
                        if (delimiterStack.pop() == ' ') {
                            state = 41;
                            continue block46;
                        }
                        state = 12;
                        continue block46;
                    }
                    if (c == '*' || c == 'X' || c == 'x') {
                        map.setType("INSTRNO", "INSTRNO");
                        map.append('X');
                        state = 11;
                        continue block46;
                    }
                    map.setType("STR", "STR");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 28: {
                    if (Util.isNumber(c) && map.getType() != "TAGNUM") {
                        map.put("d", c);
                        state = 29;
                        continue block46;
                    }
                    map.setType("STR", "STR");
                    i -= 2;
                    state = -1;
                    continue block46;
                }
                case 29: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                    } else {
                        --i;
                    }
                    state = -1;
                    continue block46;
                }
                case 30: {
                    if (c == ',' || c == ' ') {
                        state = 30;
                        continue block46;
                    }
                    if (Util.isNumber(c)) {
                        map.put("d", c);
                        state = 31;
                        continue block46;
                    }
                    map.setType("DATE");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 31: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 32;
                        continue block46;
                    }
                    Pair<Integer, String> p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i));
                    if (p != null) {
                        map.put("MMM", p.getB());
                        i += p.getA().intValue();
                        state = 24;
                        continue block46;
                    }
                    if (c == ',' || c == ' ') {
                        state = 32;
                        continue block46;
                    }
                    --i;
                    state = -1;
                    continue block46;
                }
                case 32: {
                    Pair<Integer, String> p = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", str.substring(i));
                    if (p != null) {
                        map.put("MMM", p.getB());
                        i += p.getA().intValue();
                        state = 24;
                        continue block46;
                    }
                    if (c == ',' || c == ' ' || c == '\n') {
                        state = 32;
                        continue block46;
                    }
                    p = Util.checkTypes(Yuga.getRoot(), "FSA_DAYSFFX", str.substring(i));
                    if (p != null) {
                        i += p.getA().intValue();
                        state = 32;
                        continue block46;
                    }
                    int j = i;
                    while (!Util.isNumber(str.charAt(j))) {
                        --j;
                    }
                    i = j;
                    state = -1;
                    continue block46;
                }
                case 33: {
                    if (i + 3 < str.length() && Util.isNumber(c) && str.substring(i + 1, i + 3).equals("th")) {
                        map.put("d", c);
                        i += 2;
                        state = 34;
                        continue block46;
                    }
                    if (Util.isNumber(c)) {
                        map.put("d", c);
                        state = 34;
                        continue block46;
                    }
                    if (c == ' ' || c == ',' || c == '-') {
                        state = 33;
                        continue block46;
                    }
                    if (Yuga.getPrevState(prevStates) == 1 && c == '.' && YugaMethods.lookAheadForNum(str, i) != -1) {
                        state = 33;
                        i = YugaMethods.lookAheadForNum(str, i);
                        continue block46;
                    }
                    map.setType("DATE");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 34: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        state = 35;
                        continue block46;
                    }
                    if (c == ' ' || c == ',') {
                        state = 35;
                        continue block46;
                    }
                    map.setType("DATE");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 35: {
                    if (Util.isNumber(c)) {
                        if (i > 1 && Util.isNumber(str.charAt(i - 1))) {
                            map.convert("d", "yyyy");
                            map.append(c);
                        } else {
                            map.put("yy", c);
                        }
                        state = 20;
                        continue block46;
                    }
                    if (c == ' ' || c == ',') {
                        state = 40;
                        continue block46;
                    }
                    map.setType("DATE");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 36: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        ++counter;
                        continue block46;
                    }
                    if (c == '.' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                        map.append(c);
                        state = 10;
                        continue block46;
                    }
                    if (c == '-' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                        delimiterStack.push(c);
                        map.append(c);
                        state = 16;
                        continue block46;
                    }
                    if (counter != 12 && !Util.isNumber(str.substring(1, i))) {
                        return null;
                    }
                    map.setType("NUM", "NUM");
                    state = -1;
                    continue block46;
                }
                case 37: {
                    if (Util.isNumber(c)) {
                        map.setType("AMT", "AMT");
                        map.put("AMT", '-');
                        map.append(c);
                        state = 12;
                        continue block46;
                    }
                    if (c == '.') {
                        map.put("AMT", '-');
                        map.append(c);
                        state = 10;
                        continue block46;
                    }
                    state = -1;
                    continue block46;
                }
                case 38: {
                    i = map.getIndex();
                    state = -1;
                    continue block46;
                }
                case 39: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        continue block46;
                    }
                    map.setType("INSTRNO", "INSTRNO");
                    state = -1;
                    continue block46;
                }
                case 40: {
                    if (Util.isNumber(c)) {
                        map.put("yy", c);
                        state = 20;
                        continue block46;
                    }
                    if (c == ' ' || c == ',') {
                        state = 40;
                        continue block46;
                    }
                    map.setType("DATE");
                    --i;
                    state = -1;
                    continue block46;
                }
                case 41: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        continue block46;
                    }
                    if (c == ' ') {
                        if (i >= 11 && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                            state = -1;
                            --i;
                            continue block46;
                        }
                        state = 41;
                        continue block46;
                    }
                    i = i - 1 > 0 && str.charAt(i - 1) == ' ' ? (i -= 2) : --i;
                    state = -1;
                    continue block46;
                }
                case 42: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        continue block46;
                    }
                    if (c == '-' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                        state = 39;
                        continue block46;
                    }
                    --i;
                    state = -1;
                    continue block46;
                }
                case 43: {
                    if (Util.isLowerAlpha(c) || Util.isNumber(c)) {
                        map.setType("VPD", "VPD");
                        map.append(delimiterStack.pop());
                        map.append(c);
                        state = 44;
                        continue block46;
                    }
                    state = -1;
                    continue block46;
                }
                case 44: {
                    if (Util.isLowerAlpha(c) || Util.isNumber(c) || c == '.') {
                        map.append(c);
                        state = 44;
                        continue block46;
                    }
                    state = -1;
                    continue block46;
                }
                case 45: {
                    if (Util.isNumber(c)) {
                        map.append(c);
                        continue block46;
                    }
                    if (c == '-' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                        state = 39;
                        continue block46;
                    }
                    if (c == ' ' && i + 1 < str.length() && Util.isNumber(str.charAt(i + 1))) {
                        state = 45;
                        continue block46;
                    }
                    i = i - 1 > 0 && str.charAt(i - 1) == ',' ? (i -= 2) : --i;
                    state = -1;
                }
            }
        }
        if (map.getType() == null) {
            return null;
        }
        if (state == 10) {
            map.pop();
            --i;
        } else if (state == 36) {
            if (counter == 12 || Util.isNumber(str.substring(1, i))) {
                map.setType("NUM", "NUM");
            } else {
                return null;
            }
        }
        if (map.getType().equals("AMT")) {
            int j;
            if (!map.contains(map.getType()) || map.get(map.getType()).contains(".") && map.get(map.getType()).split("\\.")[0].length() > 8 || !map.get(map.getType()).contains(".") && map.get(map.getType()).length() > 8) {
                map.setType("NUM", "NUM");
            }
            if (i - 3 > 0 && str.charAt(i - 3) == ',') {
                char c1 = map.pop();
                c2 = map.pop();
                map.append('.');
                map.append(c2);
                map.append(c1);
            }
            if ((j = i + Yuga.skip(str.substring(i))) < str.length()) {
                if ((str.charAt(j) == 'k' || str.charAt(j) == 'm' || str.charAt(j) == 'g') && j + 1 < str.length() && str.charAt(j + 1) == 'b') {
                    Yuga.checkIfData(str, j, map);
                    i = j + 2;
                } else if (str.charAt(j) == 'k' && j + 1 < str.length() && str.charAt(j + 1) == 'g') {
                    map.setVal("data", map.get(map.getType()));
                    String sData = " KG";
                    map.setType("WGT", "WGT");
                    map.append(sData);
                    i = j + 2;
                } else if (j + 2 < str.length() && str.charAt(j) == 't' && str.charAt(j + 1) == 'o' && str.charAt(j + 2) == 'n') {
                    String sData = " ton";
                    map.setType("WGT", "WGT");
                    map.append(sData);
                    i = j + 2;
                } else if (str.charAt(j) == 'x' && (j + 1 == str.length() || j + 1 < str.length() && (str.charAt(j + 1) == ' ' || str.charAt(j + 1) == '.' || str.charAt(j + 1) == ','))) {
                    map.setType("MLTPL", "MLTPL");
                    map.append(str.substring(i, j + 1));
                    i = j;
                }
            }
        }
        Yuga.setIfNumRange(str, i, map);
        if (map.getType().equals("NUM")) {
            int k = i + Yuga.skip(str.substring(i));
            if (k < str.length() && (str.charAt(k) == 'k' || str.charAt(k) == 'm' || str.charAt(k) == 'g') && k + 1 < str.length() && str.charAt(k + 1) == 'b') {
                Yuga.checkIfData(str, k, map);
                i = k + 2;
            } else if (i < str.length() && str.charAt(i - 1) != ' ' && Character.isAlphabetic(str.charAt(i)) && (!config.containsKey("YUGA_SOURCE_CONTEXT") || !"YUGA_SC_CURR".equals(config.get("YUGA_SOURCE_CONTEXT")) && !"YUGA_SC_TRANSID".equals(config.get("YUGA_SOURCE_CONTEXT")))) {
                int j;
                for (j = i; j < str.length() && str.charAt(j) != ' '; ++j) {
                }
                map.setType("STR", "STR");
                i = j;
            } else if (i + 1 < str.length() && str.charAt(i) == '/' && str.charAt(i + 1) == '-') {
                map.setType("AMT", "AMT");
            } else if (map.get("NUM") != null) {
                if (map.get("NUM").length() == 10 && (map.get("NUM").charAt(0) == '9' || map.get("NUM").charAt(0) == '8' || map.get("NUM").charAt(0) == '7')) {
                    map.setVal("num_class", "PHN");
                } else if (map.get("NUM").length() == 12 && map.get("NUM").startsWith("91")) {
                    map.setVal("num_class", "PHN");
                } else if (map.get("NUM").length() == 11 && map.get("NUM").startsWith("18")) {
                    map.setVal("num_class", "PHN");
                } else if (map.get("NUM").length() == 11 && map.get("NUM").charAt(0) == '0') {
                    map.setVal("num_class", "PHN");
                } else if (config.containsKey("YUGA_SOURCE_CONTEXT") && config.get("YUGA_SOURCE_CONTEXT").equals("YUGA_SC_TRANS")) {
                    if (map.get("NUM") != null && (haveSeenAComma || comma_count > 1)) {
                        map.setType("AMT");
                    }
                } else if (map.get("NUM") != null && (map.get("NUM").length() == 6 || map.get("NUM").length() == 8) && config.containsKey("YUGA_SOURCE_CONTEXT") && config.get("YUGA_SOURCE_CONTEXT").equals("YUGA_SC_ON") && (i >= str.length() || str.charAt(i) == ' ' || str.charAt(i) == '.' || str.charAt(i) == ',')) {
                    if (map.get("NUM").length() == 6) {
                        Pattern pattern = Pattern.compile("([0-3][0-9])([0-1][0-9])([1-3][0-9])");
                        Matcher m = pattern.matcher(str);
                        if (m.find()) {
                            Pair<Integer, FsaContextMap> p_ = Yuga.parseInternal(m.group(1) + "-" + m.group(2) + "-" + m.group(3), config);
                            if (p_ != null) {
                                i = p_.getA() - 2;
                                map = p_.getB();
                            }
                        } else {
                            map.setVal("num_class", "NUM");
                        }
                    } else if (map.get("NUM").length() == 8) {
                        Pattern pattern = Pattern.compile("([0-3][0-9])([0-1][0-9])([2][0-1][1-5][0-9])");
                        Matcher m = pattern.matcher(str);
                        if (m.find()) {
                            Pair<Integer, FsaContextMap> p_ = Yuga.parseInternal(m.group(1) + "-" + m.group(2) + "-" + m.group(3), config);
                            if (p_ != null) {
                                i = p_.getA() - 2;
                                map = p_.getB();
                            }
                        } else {
                            map.setVal("num_class", "NUM");
                        }
                    }
                } else {
                    map.setVal("num_class", "NUM");
                }
            }
        } else if (map.getType().equals("DATE") && i + 1 < str.length()) {
            int in = i + Yuga.skip(str.substring(i));
            String sub = str.substring(in);
            if (in < str.length()) {
                if (Util.isNumber(str.charAt(in)) || Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", sub) != null || Util.checkTypes(Yuga.getRoot(), "FSA_DAYS", sub) != null) {
                    Pair<Integer, FsaContextMap> p_ = Yuga.parseInternal(sub, config);
                    if (p_ != null && p_.getB().getType().equals("DATE")) {
                        map.putAll(p_.getB());
                        i = in + p_.getA();
                    }
                } else {
                    Pair<Integer, String> pTime = Util.checkTypes(Yuga.getRoot(), "FSA_TIMEPRFX", sub);
                    if (pTime != null) {
                        Pair<Integer, FsaContextMap> p_;
                        int iTime = in + pTime.getA() + 1 + Yuga.skip(str.substring(in + pTime.getA() + 1));
                        if (iTime < str.length() && (Util.isNumber(str.charAt(iTime)) || Util.checkTypes(Yuga.getRoot(), "FSA_DAYS", str.substring(iTime)) != null) && (p_ = Yuga.parseInternal(str.substring(iTime), config)) != null && p_.getB().getType().equals("DATE")) {
                            map.putAll(p_.getB());
                            i = iTime + p_.getA();
                        }
                    } else {
                        pTime = Util.checkTypes(Yuga.getRoot(), "FSA_TZ", sub);
                        if (pTime != null) {
                            int j = Yuga.skipForTZ(str.substring(in + pTime.getA() + 1), map);
                            i = in + pTime.getA() + 1 + j;
                        } else if ((sub.toLowerCase().startsWith("pm") || sub.toLowerCase().startsWith("am")) && (sub.length() >= 3 && Util.isDelimiter(sub.charAt(2)) || Util.meridienTimeAhead(sub, 0))) {
                            i = in + 2;
                        }
                    }
                }
            }
        } else if (map.getType().equals("TIMES")) {
            Yuga.handleTYTMS(map, map.get(map.getType()));
        } else if (map.getType().equals("NUMRANGE")) {
            int in = i + Yuga.skip(str.substring(i));
            Date dt = null;
            String fromNum = map.getVal("from_num");
            String toNum = map.getVal("to_num");
            if (config.containsKey("YUGA_CONF_DATE")) {
                dt = Util.getDateObject(config.get("YUGA_CONF_DATE"));
            }
            if (in < str.length() && dt != null) {
                String sub = str.substring(in);
                Pair<Integer, String> pRange = Util.checkTypes(Yuga.getRoot(), "FSA_TIMES", sub);
                if (pRange != null) {
                    i = in + pRange.getA() + 1;
                    if (Yuga.handleTYTMS(map, fromNum + toNum)) {
                        map.setType("TIMES");
                        map.getValMap().remove("from_num");
                        map.getValMap().remove("to_num");
                    } else {
                        map.setType("TIMERANGE");
                        if (sub.charAt(0) == 'h') {
                            map.setVal("time_type", "hour");
                        } else {
                            map.setVal("time_type", "min");
                        }
                    }
                } else {
                    pRange = Util.checkTypes(Yuga.getRoot(), "FSA_DAYRANGE", sub);
                    if (pRange != null) {
                        i = in + pRange.getA() + 1;
                        map.setType("DATERANGE");
                        map.setVal("from_date", Util.addDaysToDate(dt, Util.parseStrToInt(fromNum)));
                        map.setVal("to_date", Util.addDaysToDate(dt, Util.parseStrToInt(toNum)));
                        map.setVal("time_type", "day");
                        map.getValMap().remove("from_num");
                        map.getValMap().remove("to_num");
                    } else {
                        pRange = Util.checkTypes(Yuga.getRoot(), "FSA_MONTHS", sub);
                        if (pRange != null) {
                            i = in + pRange.getA() + 1;
                            map.setType("DATERANGE");
                            map.setVal("from_date", Yuga.getYugaResponseOutput(fromNum + " " + pRange.getB(), config, false));
                            map.setVal("to_date", Yuga.getYugaResponseOutput(toNum + " " + pRange.getB(), config, false));
                            map.setVal("time_type", "month");
                            map.getValMap().remove("from_num");
                            map.getValMap().remove("to_num");
                        } else if (Util.meridienTimeAhead(sub, 0)) {
                            String meridien = str.charAt(i) == 'a' ? "am" : "pm";
                            i = in + 2;
                            map.setVal("from_time", Yuga.getYugaResponseOutput(fromNum + " " + meridien, config, true));
                            map.setVal("to_time", Yuga.getYugaResponseOutput(toNum + " " + meridien, config, true));
                            map.getValMap().remove("from_num");
                            map.getValMap().remove("to_num");
                            map.setType("TIMES");
                        } else if (sub.length() > 3 && (sub.charAt(0) == '-' || sub.charAt(0) == 'x')) {
                            int del = Yuga.nextSpace(sub);
                            if (Util.isNumber(sub.substring(1))) {
                                map.append(sub);
                                map.setType("NUM", "NUM");
                            } else {
                                map.append(sub.substring(0, del));
                                map.setType("STR", "STR");
                            }
                            map.getValMap().remove("from_num");
                            map.getValMap().remove("to_num");
                            i += del;
                        }
                    }
                }
            }
            if (config.containsKey("YUGA_SOURCE_CONTEXT") && config.get("YUGA_SOURCE_CONTEXT").equals("YUGA_SC_TMERANGE") && fromNum.length() == 2 && toNum.length() == 2) {
                map.getValMap().put("from_time", Util.addTimeStampSuffix(fromNum));
                map.getValMap().put("to_time", Util.addTimeStampSuffix(toNum));
                map.getValMap().remove("from_num");
                map.getValMap().remove("to_num");
                map.setType("TIMES");
            } else if (map.getType().equals("NUMRANGE")) {
                map.setType("NUM");
                map.setVal("num", map.getValMap().remove("from_num") + map.getValMap().remove("to_num"));
            }
        }
        return new Pair<Integer, FsaContextMap>(i, map);
    }

    private static void setIfNumRange(String str, int i, FsaContextMap map) {
        String trimmed = str.substring(0, i).trim();
        if (Util.isDelimiter(trimmed.charAt(trimmed.length() - 1))) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        if (Util.checkForNumRange(trimmed) && !map.getType().equals("TIMES")) {
            String[] parts = trimmed.split("-");
            map.setVal("from_num", parts[0]);
            map.setVal("to_num", parts[1]);
            map.setType("NUMRANGE");
        }
    }

    private static void checkIfData(String str, int j, FsaContextMap map) {
        map.setVal("data", map.get(map.getType()));
        String sData = "";
        switch (str.charAt(j)) {
            case 'k': {
                map.setVal("data_type", "KB");
                sData = " KB";
                break;
            }
            case 'm': {
                map.setVal("data_type", "MB");
                sData = " MB";
                break;
            }
            case 'g': {
                map.setVal("data_type", "GB");
                sData = " GB";
            }
        }
        map.setType("DATA", "DATA");
        map.append(sData);
    }

    private static boolean handleTYTMS(FsaContextMap map, String v) {
        if (v != null && v.length() == 8 && Util.isHour(v.charAt(0), v.charAt(1)) && Util.isHour(v.charAt(4), v.charAt(5))) {
            Yuga.extractTime(v.substring(0, 4), map.getValMap(), "from");
            Yuga.extractTime(v.substring(4, 8), map.getValMap(), "to");
            return true;
        }
        return false;
    }

    private static int skipForTZ(String str, FsaContextMap map) {
        String s_;
        int i;
        int state = 1;
        block7: for (i = 0; state > 0 && i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (c == ' ' || c == '+' || Util.isNumber(c)) {
                        state = 1;
                        continue block7;
                    }
                    if (c == ':') {
                        state = 2;
                        continue block7;
                    }
                    s_ = str.substring(0, i).trim();
                    if (s_.length() == 4 && Util.isNumber(s_)) {
                        map.put("yyyy", s_);
                        state = -2;
                        continue block7;
                    }
                    state = -1;
                    continue block7;
                }
                case 2: {
                    if (Util.isNumber(c)) {
                        state = 3;
                        continue block7;
                    }
                    state = -1;
                    continue block7;
                }
                case 3: {
                    if (Util.isNumber(c)) {
                        state = 4;
                        continue block7;
                    }
                    state = -1;
                    continue block7;
                }
                case 4: {
                    if (c == ' ') {
                        state = 5;
                        continue block7;
                    }
                    state = -2;
                    continue block7;
                }
                case 5: {
                    String sy = str.substring(i, i + 4);
                    if (i + 3 < str.length() && Util.isNumber(sy)) {
                        map.put("yyyy", sy);
                        i += 3;
                    }
                    state = -2;
                }
            }
        }
        s_ = str.substring(0, i).trim();
        if (state == 1 && s_.length() == 4 && Util.isNumber(s_)) {
            map.put("yyyy", s_);
        }
        return state == -1 ? 0 : i;
    }

    private static int skip(String str) {
        int i;
        for (i = 0; i < str.length() && (str.charAt(i) == ' ' || str.charAt(i) == ',' || str.charAt(i) == '(' || str.charAt(i) == ':'); ++i) {
        }
        return i;
    }

    private static int nextSpace(String str) {
        int i;
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            return i;
        }
        return i;
    }

    private static int accAmtNumPct(String str, int i, FsaContextMap map, Map<String, String> config) {
        Pair<Integer, String> p;
        char c = str.charAt(i);
        String subStr = str.substring(i);
        if (c == '.') {
            if (i == 0 && Yuga.configContextIsCURR(config)) {
                map.setType("AMT", "AMT");
            }
            map.append(c);
            return 10;
        }
        if (YugaMethods.isInstrNumStart(c) && YugaMethods.lookAheadForInstr(str, i + 2) != -1) {
            map.setType("INSTRNO", "INSTRNO");
            map.append('X');
            return 11;
        }
        if (c == ',') {
            return 12;
        }
        if (c == '%' || c == ' ' && i + 1 < str.length() && str.charAt(i + 1) == '%') {
            map.setType("PCT", "PCT");
            return -1;
        }
        if (c == '+') {
            if (Yuga.configContextIsCURR(config)) {
                return -1;
            }
            map.setType("STR", "STR");
            return 36;
        }
        if (i > 0 && (p = Util.checkTypes(Yuga.getRoot(), "FSA_AMT", subStr)) != null) {
            map.setIndex(p.getA());
            map.setType("AMT", "AMT");
            map.append(YugaMethods.getAmt(p.getB()));
            return 38;
        }
        if (i > 0 && (p = Util.checkTypes(Yuga.getRoot(), "FSA_TIMES", subStr)) != null) {
            int ind = i + p.getA();
            map.setIndex(ind);
            map.setType("TIME", null);
            String s = str.substring(0, i);
            if (p.getB().equals("mins")) {
                s = "00" + s;
            }
            Yuga.extractTime(s, map.getValMap(), new String[0]);
            return 38;
        }
        return -1;
    }

    private static void extractTime(String str, Map<String, String> valMap, String ... prefix) {
        Pattern pattern;
        Matcher m;
        String pre = "";
        if (prefix != null && prefix.length > 0) {
            pre = prefix[0] + "_";
        }
        if ((m = (pattern = Pattern.compile("([0-9]{2})([0-9]{2})?([0-9]{2})?")).matcher(str)).find()) {
            valMap.put(pre + "time", m.group(1) + (m.groupCount() > 1 && m.group(2) != null ? ":" + m.group(2) : ":00"));
        }
    }

    private static boolean configContextIsCURR(Map config) {
        return config.containsKey("YUGA_SOURCE_CONTEXT") && config.get("YUGA_SOURCE_CONTEXT").equals("YUGA_SC_CURR");
    }

    private static int getPrevState(ArrayList<Integer> prevStates) {
        int res = prevStates.size() - 2;
        return res < 0 ? 1 : prevStates.get(res);
    }

    public static String getYugaResponseOutput(String str, Map<String, String> config, boolean isTime) {
        Response r = Yuga.getResponse(str, config);
        if (isTime) {
            return r.getValMap().get("time");
        }
        return r.getStr();
    }

    static /* synthetic */ RootTrie access$000() {
        return Yuga.createRoot();
    }

    static class DelimiterStack {
        final ArrayList<Character> stack = new ArrayList();

        DelimiterStack() {
        }

        void push(char ch) {
            this.stack.add(Character.valueOf(ch));
        }

        char pop() {
            if (this.stack.size() > 0) {
                return this.stack.get(this.stack.size() - 1).charValue();
            }
            return '~';
        }
    }

    private static class LazyHolder {
        static RootTrie root = Yuga.access$000();

        private LazyHolder() {
        }
    }
}

