/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import in.specmatic.core.Configuration;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.SpecmaticConfig;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.ContractException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0012\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0001\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"APPLICATION_NAME", "", "APPLICATION_NAME_LOWER_CASE", "CONTRACT_EXTENSION", "CONTRACT_EXTENSIONS", "", "getCONTRACT_EXTENSIONS", "()Ljava/util/List;", "DATA_DIR_SUFFIX", "DEFAULT_TIMEOUT_IN_SECONDS", "DEFAULT_WORKING_DIRECTORY", "EXAMPLES_DIR_SUFFIX", "JSON", "OPENAPI_FILE_EXTENSIONS", "getOPENAPI_FILE_EXTENSIONS", "SPECMATIC_GITHUB_ISSUES", "TEST_DIR_SUFFIX", "WSDL", "YAML", "YML", "invalidContractExtensionMessage", "filename", "loadSpecmaticConfig", "Lin/specmatic/core/SpecmaticConfig;", "configFileName", "isContractFile", "", "loadContract", "Lin/specmatic/core/Feature;", "core"})
public final class SpecmaticConfigKt {
    @NotNull
    public static final String APPLICATION_NAME = "Specmatic";
    @NotNull
    public static final String APPLICATION_NAME_LOWER_CASE = "specmatic";
    @NotNull
    public static final String DEFAULT_TIMEOUT_IN_SECONDS = "60";
    @NotNull
    public static final String CONTRACT_EXTENSION = "spec";
    @NotNull
    public static final String YAML = "yaml";
    @NotNull
    public static final String WSDL = "wsdl";
    @NotNull
    public static final String YML = "yml";
    @NotNull
    public static final String JSON = "json";
    @NotNull
    private static final List<String> OPENAPI_FILE_EXTENSIONS;
    @NotNull
    private static final List<String> CONTRACT_EXTENSIONS;
    @NotNull
    public static final String DATA_DIR_SUFFIX = "_data";
    @NotNull
    public static final String TEST_DIR_SUFFIX = "_tests";
    @NotNull
    public static final String EXAMPLES_DIR_SUFFIX = "_examples";
    @NotNull
    public static final String SPECMATIC_GITHUB_ISSUES = "https://github.com/znsio/specmatic/issues";
    @NotNull
    public static final String DEFAULT_WORKING_DIRECTORY = ".specmatic";

    @NotNull
    public static final List<String> getOPENAPI_FILE_EXTENSIONS() {
        return OPENAPI_FILE_EXTENSIONS;
    }

    @NotNull
    public static final List<String> getCONTRACT_EXTENSIONS() {
        return CONTRACT_EXTENSIONS;
    }

    @NotNull
    public static final String invalidContractExtensionMessage(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return "The file " + filename + " does not seem like a contract file. Valid extensions for contract files are " + CollectionsKt.joinToString$default((Iterable)CONTRACT_EXTENSIONS, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    public static final boolean isContractFile(@NotNull String $this$isContractFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractFile, (String)"<this>");
        return CONTRACT_EXTENSIONS.contains(FilesKt.getExtension((File)new File($this$isContractFile)));
    }

    @NotNull
    public static final Feature loadContract(@NotNull String $this$loadContract) {
        Intrinsics.checkNotNullParameter((Object)$this$loadContract, (String)"<this>");
        if (!SpecmaticConfigKt.isContractFile($this$loadContract)) {
            throw new ContractException(SpecmaticConfigKt.invalidContractExtensionMessage($this$loadContract), null, null, null, false, 30, null);
        }
        return FeatureKt.parseContractFileToFeature$default(new File($this$loadContract), null, null, null, null, null, null, null, 254, null);
    }

    @NotNull
    public static final SpecmaticConfig loadSpecmaticConfig(@Nullable String configFileName) {
        File configFile;
        String string = configFileName;
        if (string == null) {
            string = Configuration.Companion.getGlobalConfigFileName();
        }
        if (!(configFile = new File(string)).exists()) {
            throw new ContractException("Could not find the Specmatic configuration at path " + configFile.getCanonicalPath(), null, null, null, false, 30, null);
        }
        try {
            Object object = new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(FilesKt.readText$default((File)configFile, null, (int)1, null), SpecmaticConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (SpecmaticConfig)object;
        }
        catch (LinkageError e) {
            LoggingKt.getLogger().log(e, "A dependency version conflict has been detected. If you are using Spring in a maven project, a common resolution is to set the property <kotlin.version></kotlin.version> to your pom project.");
            throw e;
        }
        catch (Throwable e) {
            throw new Exception("Your configuration file may have some missing configuration sections. Please ensure that the " + configFileName + " file adheres to the schema described at: https://specmatic.in/documentation/specmatic_json.html", e);
        }
    }

    public static /* synthetic */ SpecmaticConfig loadSpecmaticConfig$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return SpecmaticConfigKt.loadSpecmaticConfig(string);
    }

    static {
        Object[] objectArray = new String[]{YAML, YML, JSON};
        OPENAPI_FILE_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{CONTRACT_EXTENSION, WSDL};
        CONTRACT_EXTENSIONS = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)OPENAPI_FILE_EXTENSIONS);
    }
}

