/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.git.SystemGit;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.ContractsSelectorPredicate;
import in.specmatic.core.utilities.GitSource;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J5\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J&\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lin/specmatic/core/utilities/GitMonoRepo;", "Lin/specmatic/core/utilities/ContractSource;", "Lin/specmatic/core/utilities/GitSource;", "testContracts", "", "", "stubContracts", "type", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "getType", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "directoryRelativeTo", "Ljava/io/File;", "workingDirectory", "equals", "", "other", "", "getLatest", "", "sourceGit", "Lin/specmatic/core/git/SystemGit;", "hashCode", "", "install", "loadContracts", "Lin/specmatic/core/utilities/ContractPathData;", "selector", "Lin/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "pathDescriptor", "path", "pushUpdates", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nGitMonoRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMonoRepo.kt\nin/specmatic/core/utilities/GitMonoRepo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1549#2:48\n1620#2,3:49\n*S KotlinDebug\n*F\n+ 1 GitMonoRepo.kt\nin/specmatic/core/utilities/GitMonoRepo\n*L\n38#1:48\n38#1:49,3\n*E\n"})
public final class GitMonoRepo
implements ContractSource,
GitSource {
    @NotNull
    private final List<String> testContracts;
    @NotNull
    private final List<String> stubContracts;
    @Nullable
    private final String type;

    public GitMonoRepo(@NotNull List<String> testContracts, @NotNull List<String> stubContracts, @Nullable String type) {
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        this.type = type;
    }

    @Override
    @NotNull
    public List<String> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<String> getStubContracts() {
        return this.stubContracts;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return path2;
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        System.out.println((Object)"Checking list of mono repo paths...");
        List contracts = CollectionsKt.plus((Collection)this.getTestContracts(), (Iterable)this.getStubContracts());
        for (String path2 : contracts) {
            String existenceMessage = new File(path2).exists() ? path2 + " exists" : path2 + " NOT FOUND!";
            System.out.println((Object)existenceMessage);
        }
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return FilesKt.resolve((File)workingDirectory, (String)Utilities.gitRootDir());
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        File monoRepoBaseDir = new File(new SystemGit(null, null, null, 7, null).gitRoot());
        File configFileLocation = new File(configFilePath).getAbsoluteFile().getParentFile();
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = monoRepoBaseDir.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
            Intrinsics.checkNotNull((Object)configFileLocation);
            String string3 = FilesKt.resolve((File)configFileLocation, (String)it).getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCanonicalPath(...)");
            collection.add(new ContractPathData(string2, string3, this.getType(), null, null, (String)it, 24, null));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> component1() {
        return this.testContracts;
    }

    @NotNull
    public final List<String> component2() {
        return this.stubContracts;
    }

    @Nullable
    public final String component3() {
        return this.type;
    }

    @NotNull
    public final GitMonoRepo copy(@NotNull List<String> testContracts, @NotNull List<String> stubContracts, @Nullable String type) {
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        return new GitMonoRepo(testContracts, stubContracts, type);
    }

    public static /* synthetic */ GitMonoRepo copy$default(GitMonoRepo gitMonoRepo, List list, List list2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = gitMonoRepo.testContracts;
        }
        if ((n & 2) != 0) {
            list2 = gitMonoRepo.stubContracts;
        }
        if ((n & 4) != 0) {
            string = gitMonoRepo.type;
        }
        return gitMonoRepo.copy(list, list2, string);
    }

    @NotNull
    public String toString() {
        return "GitMonoRepo(testContracts=" + this.testContracts + ", stubContracts=" + this.stubContracts + ", type=" + this.type + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.testContracts).hashCode();
        result2 = result2 * 31 + ((Object)this.stubContracts).hashCode();
        result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitMonoRepo)) {
            return false;
        }
        GitMonoRepo gitMonoRepo = (GitMonoRepo)other;
        if (!Intrinsics.areEqual(this.testContracts, gitMonoRepo.testContracts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stubContracts, gitMonoRepo.stubContracts)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.type, (Object)gitMonoRepo.type);
    }
}

