/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.test;

import in.specmatic.test.TimeoutPolicyKt;
import io.ktor.client.plugins.HttpTimeout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Lin/specmatic/test/TimeoutPolicy;", "", "timeout", "", "(I)V", "requestTimeoutInMillis", "", "getRequestTimeoutInMillis", "()J", "socketTimeoutInMillis", "getSocketTimeoutInMillis", "configure", "", "httpTimeoutCapabilityConfiguration", "Lio/ktor/client/plugins/HttpTimeout$HttpTimeoutCapabilityConfiguration;", "core"})
public class TimeoutPolicy {
    private final long requestTimeoutInMillis;
    private final long socketTimeoutInMillis;

    public TimeoutPolicy(int timeout) {
        this.requestTimeoutInMillis = TimeoutPolicyKt.secondsToMillis(timeout);
        this.socketTimeoutInMillis = TimeoutPolicyKt.secondsToMillis(timeout + 1);
    }

    public final long getRequestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    public final long getSocketTimeoutInMillis() {
        return this.socketTimeoutInMillis;
    }

    public final void configure(@NotNull HttpTimeout.HttpTimeoutCapabilityConfiguration httpTimeoutCapabilityConfiguration) {
        Intrinsics.checkNotNullParameter((Object)httpTimeoutCapabilityConfiguration, (String)"httpTimeoutCapabilityConfiguration");
        httpTimeoutCapabilityConfiguration.setSocketTimeoutMillis(Long.valueOf(this.socketTimeoutInMillis));
        httpTimeoutCapabilityConfiguration.setRequestTimeoutMillis(Long.valueOf(this.requestTimeoutInMillis));
    }
}

