/*
 * Decompiled with CFR 0.152.
 */
package application;

import in.specmatic.core.KeyData;
import in.specmatic.core.utilities.Utilities;
import io.ktor.network.tls.certificates.CertificatesKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"createKeyStore", "Lin/specmatic/core/KeyData;", "keyStoreDirPath", "", "keyStorePassword", "keyAlias", "keyPassword", "loadKeyStoreFromFile", "Ljava/security/KeyStore;", "keyStoreFile", "application"})
public final class CertInfoKt {
    private static final KeyData createKeyStore(String keyStoreDirPath, String keyStorePassword, String keyAlias, String keyPassword) {
        String filename;
        File keyStoreFile;
        File keyStoreDir = new File(keyStoreDirPath);
        if (!keyStoreDir.exists()) {
            keyStoreDir.mkdirs();
        }
        if ((keyStoreFile = FilesKt.resolve((File)keyStoreDir, (String)(filename = "specmatic.jks"))).exists()) {
            keyStoreFile.delete();
        }
        KeyStore keyStore = CertificatesKt.generateCertificate$default((File)keyStoreFile, null, (String)keyAlias, (String)keyPassword, (String)keyStorePassword, (int)0, null, (int)98, null);
        return new KeyData(keyStore, keyStorePassword, keyAlias, keyPassword);
    }

    private static final KeyStore loadKeyStoreFromFile(String keyStoreFile, String keyStorePassword) {
        KeyStore keyStore;
        String string;
        File certFilePath = new File(keyStoreFile);
        String string2 = FilesKt.getExtension((File)certFilePath).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        if (Intrinsics.areEqual((Object)string3, (Object)"jks")) {
            string = "JKS";
        } else if (Intrinsics.areEqual((Object)string3, (Object)"pfx")) {
            string = "PKCS12";
        } else {
            Utilities.exitWithMessage((String)"The certificate file must be either in Java Key Store or PKCS12 format");
            throw new KotlinNothingValueException();
        }
        String keyStoreType = string;
        KeyStore $this$loadKeyStoreFromFile_u24lambda_u240 = keyStore = KeyStore.getInstance(keyStoreType);
        boolean bl = false;
        InputStream inputStream = new FileInputStream(certFilePath);
        char[] cArray = keyStorePassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        $this$loadKeyStoreFromFile_u24lambda_u240.load(inputStream, cArray);
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"apply(...)");
        return keyStore2;
    }

    public static final /* synthetic */ KeyStore access$loadKeyStoreFromFile(String keyStoreFile, String keyStorePassword) {
        return CertInfoKt.loadKeyStoreFromFile(keyStoreFile, keyStorePassword);
    }

    public static final /* synthetic */ KeyData access$createKeyStore(String keyStoreDirPath, String keyStorePassword, String keyAlias, String keyPassword) {
        return CertInfoKt.createKeyStore(keyStoreDirPath, keyStorePassword, keyAlias, keyPassword);
    }
}

