/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.BackwardCompatibilityScope;
import application.CompatibilityOutput;
import application.DirectoryBackwardCompatibilityScope;
import application.FileBackwardCompatibilityScope;
import application.FileOperations;
import application.Outcome;
import application.PartialCommitFetchKt;
import in.specmatic.conversions.OpenApiSpecification;
import in.specmatic.conversions.WsdlSpecificationKt;
import in.specmatic.core.BackwardCompatibilityTest;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.Result;
import in.specmatic.core.Results;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.TestBackwardCompatibilityKt;
import in.specmatic.core.git.GitCommand;
import in.specmatic.core.git.NonZeroExitError;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0010H\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\u0016\u0010\u0014\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\u001a4\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a,\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a8\u0006\u001f"}, d2={"backwardCompatibleCommit", "Lapplication/Outcome;", "Lin/specmatic/core/Results;", "contractPath", "", "newerCommit", "olderCommit", "git", "Lin/specmatic/core/git/GitCommand;", "backwardCompatibleFile", "fileOperations", "Lapplication/FileOperations;", "backwardCompatibleOnFileOrDirectory", "", "path", "fn", "Lkotlin/Function1;", "checkCompatibility", "Lapplication/CompatibilityOutput;", "results", "compatibilityMessage", "compatibilityReport", "resultMessage", "generateCommitBackwardCompatibleTests", "", "Lin/specmatic/core/BackwardCompatibilityTest;", "generateFileBackwardCompatibilityTests", "getOlderFeature", "Lin/specmatic/core/Feature;", "parseContract", "content", "application"})
@SourceDebugExtension(value={"SMAP\nCompatibleCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompatibleCommand.kt\napplication/CompatibleCommandKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,375:1\n1#2:376\n*E\n"})
public final class CompatibleCommandKt {
    private static final int backwardCompatibleOnFileOrDirectory(String path, FileOperations fileOperations, Function1<? super String, Outcome<Results>> fn) {
        BackwardCompatibilityScope backwardCompatibilityScope;
        if (fileOperations.isFile(path)) {
            backwardCompatibilityScope = new FileBackwardCompatibilityScope(path, fn);
        } else if (fileOperations.isDirectory(path)) {
            backwardCompatibilityScope = new DirectoryBackwardCompatibilityScope(path, fn);
        } else {
            throw new ContractException(path + " was of an unexpected file type.", null, null, null, false, 30, null);
        }
        BackwardCompatibilityScope scope = backwardCompatibilityScope;
        return scope.executeCheck();
    }

    @NotNull
    public static final String compatibilityReport(@NotNull Results results, @NotNull String resultMessage) {
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)resultMessage, (String)"resultMessage");
        String countsMessage = "Tests run: " + (results.getSuccessCount() + results.getFailureCount()) + ", Passed: " + results.getSuccessCount() + ", Failed: " + results.getFailureCount() + "\n\n";
        String it = ((Object)StringsKt.trim((CharSequence)results.report("Match not found"))).toString();
        boolean bl = false;
        Object resultReport = ((CharSequence)it).length() > 0 ? it + "\n\n" : it;
        return ((Object)StringsKt.trim((CharSequence)(countsMessage + (String)resultReport + resultMessage))).toString();
    }

    @NotNull
    public static final Outcome<List<BackwardCompatibilityTest>> generateFileBackwardCompatibilityTests(@NotNull String contractPath, @NotNull FileOperations fileOperations, @NotNull GitCommand git) {
        Outcome<List<Object>> outcome;
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)fileOperations, (String)"fileOperations");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        try {
            LoggingKt.getLogger().debug("Newer version of " + contractPath);
            Feature newerFeature = CompatibleCommandKt.parseContract(LoggingKt.getLogger().debug(fileOperations.read(contractPath)), contractPath);
            Outcome<Feature> result = CompatibleCommandKt.getOlderFeature(contractPath, git);
            outcome = result.onSuccess((Function1)new Function1<Feature, Outcome<List<? extends BackwardCompatibilityTest>>>(newerFeature){
                final /* synthetic */ Feature $newerFeature;
                {
                    this.$newerFeature = $newerFeature;
                    super(1);
                }

                @NotNull
                public final Outcome<List<BackwardCompatibilityTest>> invoke(@NotNull Feature olderFeature) {
                    Intrinsics.checkNotNullParameter((Object)olderFeature, (String)"olderFeature");
                    return new Outcome<List<BackwardCompatibilityTest>>(TestBackwardCompatibilityKt.generateBackwardCompatibilityTests((Feature)olderFeature, (Feature)this.$newerFeature), null, 2, null);
                }
            });
        }
        catch (NonZeroExitError e) {
            outcome = new Outcome<List<BackwardCompatibilityTest>>(CollectionsKt.emptyList(), "Could not find " + contractPath + " at HEAD");
        }
        catch (FileNotFoundException e) {
            outcome = new Outcome<List>(CollectionsKt.emptyList(), "Could not find " + contractPath + " on the file system");
        }
        return outcome;
    }

    @NotNull
    public static final Outcome<Results> backwardCompatibleFile(@NotNull String contractPath, @NotNull FileOperations fileOperations, @NotNull GitCommand git) {
        Outcome<Results> outcome;
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)fileOperations, (String)"fileOperations");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        try {
            LoggingKt.getLogger().debug("Newer version of " + contractPath);
            Feature newerFeature = CompatibleCommandKt.parseContract(LoggingKt.getLogger().debug(fileOperations.read(contractPath)), contractPath);
            Outcome<Feature> result = CompatibleCommandKt.getOlderFeature(contractPath, git);
            outcome = result.onSuccess((Function1)new Function1<Feature, Outcome<Results>>(newerFeature){
                final /* synthetic */ Feature $newerFeature;
                {
                    this.$newerFeature = $newerFeature;
                    super(1);
                }

                @NotNull
                public final Outcome<Results> invoke(@NotNull Feature it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new Outcome<Results>(TestBackwardCompatibilityKt.testBackwardCompatibility((Feature)it, (Feature)this.$newerFeature), null, 2, null);
                }
            });
        }
        catch (NonZeroExitError e) {
            Object[] objectArray = new Result.Success[]{new Result.Success(null, null, 3, null)};
            outcome = new Outcome<Results>(new Results(CollectionsKt.mutableListOf((Object[])objectArray)), "Could not find " + contractPath + " at HEAD");
        }
        catch (FileNotFoundException e) {
            Object[] objectArray = new Result.Success[]{new Result.Success(null, null, 3, null)};
            outcome = new Outcome<Results>(new Results(CollectionsKt.mutableListOf((Object[])objectArray)), "Could not find " + contractPath + " on the file system");
        }
        return outcome;
    }

    @NotNull
    public static final Outcome<Results> backwardCompatibleCommit(@NotNull String contractPath, @NotNull String newerCommit, @NotNull String olderCommit, @NotNull GitCommand git) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)newerCommit, (String)"newerCommit");
        Intrinsics.checkNotNullParameter((Object)olderCommit, (String)"olderCommit");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Pair pair = git.relativeGitPath(contractPath);
        GitCommand gitRoot = (GitCommand)pair.component1();
        String relativeContractPath = (String)pair.component2();
        Function1 partial = (Function1)((Function1)((Function1)PartialCommitFetchKt.getGetFileContentAtSpecifiedCommit().invoke((Object)gitRoot)).invoke((Object)relativeContractPath)).invoke((Object)contractPath);
        return ((Outcome)partial.invoke((Object)newerCommit)).onSuccess((Function1)new Function1<String, Outcome<Results>>((Function1<? super String, Outcome<? extends String>>)partial, olderCommit, contractPath){
            final /* synthetic */ Function1<String, Outcome<? extends String>> $partial;
            final /* synthetic */ String $olderCommit;
            final /* synthetic */ String $contractPath;
            {
                this.$partial = $partial;
                this.$olderCommit = $olderCommit;
                this.$contractPath = $contractPath;
                super(1);
            }

            @NotNull
            public final Outcome<Results> invoke(@NotNull String newerGherkin) {
                Intrinsics.checkNotNullParameter((Object)newerGherkin, (String)"newerGherkin");
                Outcome olderCommitOutcome = (Outcome)this.$partial.invoke((Object)this.$olderCommit);
                return (String)olderCommitOutcome.getResult() == null ? new Outcome<Results>(new Results(null, 1, null), null, 2, null) : olderCommitOutcome.onSuccess((Function1)new Function1<String, Outcome<Results>>(this.$contractPath, newerGherkin){
                    final /* synthetic */ String $contractPath;
                    final /* synthetic */ String $newerGherkin;
                    {
                        this.$contractPath = $contractPath;
                        this.$newerGherkin = $newerGherkin;
                        super(1);
                    }

                    @NotNull
                    public final Outcome<Results> invoke(@NotNull String olderGherkin) {
                        Intrinsics.checkNotNullParameter((Object)olderGherkin, (String)"olderGherkin");
                        return new Outcome<Results>(TestBackwardCompatibilityKt.testBackwardCompatibility((Feature)CompatibleCommandKt.parseContract(olderGherkin, this.$contractPath), (Feature)CompatibleCommandKt.parseContract(this.$newerGherkin, this.$contractPath)), null, 2, null);
                    }
                });
            }
        });
    }

    @NotNull
    public static final Outcome<List<BackwardCompatibilityTest>> generateCommitBackwardCompatibleTests(@NotNull String contractPath, @NotNull String newerCommit, @NotNull String olderCommit, @NotNull GitCommand git) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)newerCommit, (String)"newerCommit");
        Intrinsics.checkNotNullParameter((Object)olderCommit, (String)"olderCommit");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Pair pair = git.relativeGitPath(contractPath);
        GitCommand gitRoot = (GitCommand)pair.component1();
        String relativeContractPath = (String)pair.component2();
        Function1 partial = (Function1)((Function1)((Function1)PartialCommitFetchKt.getGetFileContentAtSpecifiedCommit().invoke((Object)gitRoot)).invoke((Object)relativeContractPath)).invoke((Object)contractPath);
        return ((Outcome)partial.invoke((Object)newerCommit)).onSuccess((Function1)new Function1<String, Outcome<List<? extends BackwardCompatibilityTest>>>((Function1<? super String, Outcome<? extends String>>)partial, olderCommit, contractPath){
            final /* synthetic */ Function1<String, Outcome<? extends String>> $partial;
            final /* synthetic */ String $olderCommit;
            final /* synthetic */ String $contractPath;
            {
                this.$partial = $partial;
                this.$olderCommit = $olderCommit;
                this.$contractPath = $contractPath;
                super(1);
            }

            @NotNull
            public final Outcome<List<BackwardCompatibilityTest>> invoke(@NotNull String newerGherkin) {
                Intrinsics.checkNotNullParameter((Object)newerGherkin, (String)"newerGherkin");
                Outcome olderCommitOutcome = (Outcome)this.$partial.invoke((Object)this.$olderCommit);
                return (String)olderCommitOutcome.getResult() == null ? new Outcome<List<BackwardCompatibilityTest>>(CollectionsKt.emptyList(), null, 2, null) : olderCommitOutcome.onSuccess((Function1)new Function1<String, Outcome<List<? extends BackwardCompatibilityTest>>>(this.$contractPath, newerGherkin){
                    final /* synthetic */ String $contractPath;
                    final /* synthetic */ String $newerGherkin;
                    {
                        this.$contractPath = $contractPath;
                        this.$newerGherkin = $newerGherkin;
                        super(1);
                    }

                    @NotNull
                    public final Outcome<List<BackwardCompatibilityTest>> invoke(@NotNull String olderGherkin) {
                        Intrinsics.checkNotNullParameter((Object)olderGherkin, (String)"olderGherkin");
                        return new Outcome<List<BackwardCompatibilityTest>>(TestBackwardCompatibilityKt.generateBackwardCompatibilityTests((Feature)CompatibleCommandKt.parseContract(olderGherkin, this.$contractPath), (Feature)CompatibleCommandKt.parseContract(this.$newerGherkin, this.$contractPath)), null, 2, null);
                    }
                });
            }
        });
    }

    @NotNull
    public static final Feature parseContract(@NotNull String content, @NotNull String path) {
        Feature feature;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String extension = FilesKt.getExtension((File)new File(path));
        if (SpecmaticConfigKt.getOPENAPI_FILE_EXTENSIONS().contains(extension)) {
            feature = OpenApiSpecification.Companion.fromYAML$default((OpenApiSpecification.Companion)OpenApiSpecification.Companion, (String)content, (String)path, null, null, null, null, null, null, null, (int)508, null).toFeature();
        } else if (Intrinsics.areEqual((Object)extension, (Object)"wsdl")) {
            feature = WsdlSpecificationKt.wsdlContentToFeature((String)content, (String)path);
        } else if (SpecmaticConfigKt.getCONTRACT_EXTENSIONS().contains(extension)) {
            feature = FeatureKt.parseGherkinStringToFeature((String)content, (String)path);
        } else {
            throw FeatureKt.unsupportedFileExtensionContractException((String)path, (String)extension);
        }
        return feature;
    }

    @NotNull
    public static final Outcome<Feature> getOlderFeature(@NotNull String contractPath, @NotNull GitCommand git) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        if (!git.fileIsInGitDir(contractPath)) {
            return new Outcome<Object>(null, "Older contract file must be provided, or the file must be in a git directory");
        }
        Pair pair = git.relativeGitPath(contractPath);
        GitCommand contractGit = (GitCommand)pair.component1();
        String relativeContractPath = (String)pair.component2();
        LoggingKt.getLogger().debug("Older version of " + contractPath);
        return new Outcome<Feature>(CompatibleCommandKt.parseContract(LoggingKt.getLogger().debug(contractGit.show("HEAD", relativeContractPath)), contractPath), null, 2, null);
    }

    @NotNull
    public static final CompatibilityOutput compatibilityMessage(@NotNull Outcome<Results> results) {
        CompatibilityOutput compatibilityOutput;
        Intrinsics.checkNotNullParameter(results, (String)"results");
        if (results.getResult() == null) {
            compatibilityOutput = new CompatibilityOutput(1, results.getErrorMessage());
        } else if (results.getResult().hasFailures()) {
            compatibilityOutput = new CompatibilityOutput(1, CompatibleCommandKt.compatibilityReport(results.getResult(), "The newer contract is NOT backward compatible"));
        } else {
            CharSequence charSequence;
            int n = 0;
            CharSequence charSequence2 = results.getErrorMessage();
            if (charSequence2.length() == 0) {
                int n2 = n;
                boolean bl = false;
                String string = "The newer contract is backward compatible";
                n = n2;
                charSequence = string;
            } else {
                charSequence = charSequence2;
            }
            String string = (String)charSequence;
            int n3 = n;
            compatibilityOutput = new CompatibilityOutput(n3, string);
        }
        return compatibilityOutput;
    }

    @NotNull
    public static final CompatibilityOutput checkCompatibility(@NotNull Outcome<Results> results) {
        CompatibilityOutput compatibilityOutput;
        Intrinsics.checkNotNullParameter(results, (String)"results");
        try {
            compatibilityOutput = CompatibleCommandKt.compatibilityMessage(results);
        }
        catch (Throwable e) {
            compatibilityOutput = new CompatibilityOutput(1, "Could not run backward compatibility check, got exception\n" + Utilities.exceptionCauseMessage((Throwable)e));
        }
        return compatibilityOutput;
    }

    public static final /* synthetic */ int access$backwardCompatibleOnFileOrDirectory(String path, FileOperations fileOperations, Function1 fn) {
        return CompatibleCommandKt.backwardCompatibleOnFileOrDirectory(path, fileOperations, (Function1<? super String, Outcome<Results>>)fn);
    }
}

