/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.CompatibilityReport;
import application.DifferenceCommandKt;
import in.specmatic.core.Feature;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.log.LoggingKt;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="similar", mixinStandardHelpOptions=true, description={"Show the difference between two contracts"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u000e"}, d2={"Lapplication/DifferenceCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "newerContractFilePath", "", "getNewerContractFilePath", "()Ljava/lang/String;", "setNewerContractFilePath", "(Ljava/lang/String;)V", "olderContractFilePath", "getOlderContractFilePath", "setOlderContractFilePath", "call", "application"})
public final class DifferenceCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Older contract file path"})
    public String olderContractFilePath;
    @CommandLine.Parameters(index="1", description={"Newer contract file path"})
    public String newerContractFilePath;

    @NotNull
    public final String getOlderContractFilePath() {
        String string = this.olderContractFilePath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"olderContractFilePath");
        return null;
    }

    public final void setOlderContractFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.olderContractFilePath = string;
    }

    @NotNull
    public final String getNewerContractFilePath() {
        String string = this.newerContractFilePath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"newerContractFilePath");
        return null;
    }

    public final void setNewerContractFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.newerContractFilePath = string;
    }

    @Override
    public void call() {
        if (!SpecmaticConfigKt.isContractFile((String)this.getOlderContractFilePath())) {
            LoggingKt.getLogger().log(SpecmaticConfigKt.invalidContractExtensionMessage((String)this.getOlderContractFilePath()));
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (!SpecmaticConfigKt.isContractFile((String)this.getNewerContractFilePath())) {
            LoggingKt.getLogger().log(SpecmaticConfigKt.invalidContractExtensionMessage((String)this.getNewerContractFilePath()));
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        LoggingKt.logException((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DifferenceCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Feature olderContract = SpecmaticConfigKt.loadContract((String)this.this$0.getOlderContractFilePath());
                Feature newerContract = SpecmaticConfigKt.loadContract((String)this.this$0.getNewerContractFilePath());
                CompatibilityReport report = DifferenceCommandKt.difference(olderContract, newerContract);
                System.out.println((Object)report.message());
                System.exit(report.getExitCode());
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }));
    }
}

