/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.CompatibilityReport;
import application.CompatibleReport;
import application.ContractExceptionReport;
import application.ExceptionReport;
import application.IncompatibleReport;
import in.specmatic.core.Feature;
import in.specmatic.core.Results;
import in.specmatic.core.TestBackwardCompatibilityKt;
import in.specmatic.core.pattern.ContractException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0005"}, d2={"difference", "Lapplication/CompatibilityReport;", "olderContract", "Lin/specmatic/core/Feature;", "newerContract", "application"})
public final class DifferenceCommandKt {
    @NotNull
    public static final CompatibilityReport difference(@NotNull Feature olderContract, @NotNull Feature newerContract) {
        CompatibilityReport compatibilityReport;
        Intrinsics.checkNotNullParameter((Object)olderContract, (String)"olderContract");
        Intrinsics.checkNotNullParameter((Object)newerContract, (String)"newerContract");
        try {
            Results results = TestBackwardCompatibilityKt.findDifferences((Feature)olderContract, (Feature)newerContract);
            boolean bl = false;
            compatibilityReport = results.getFailureCount() > 0 ? (CompatibilityReport)new IncompatibleReport(results, "The two contracts are not similar.") : (CompatibilityReport)new CompatibleReport("The two contracts are similar.");
        }
        catch (ContractException e) {
            compatibilityReport = new ContractExceptionReport(e);
        }
        catch (Throwable e) {
            compatibilityReport = new ExceptionReport(e);
        }
        return compatibilityReport;
    }
}

