/*
 * Decompiled with CFR 0.152.
 */
package application;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"Lapplication/FileOperations;", "", "()V", "extensionIsNot", "", "fileName", "", "extensions", "", "files", "Ljava/io/File;", "stubDataDir", "isDirectory", "isFile", "isJSONFile", "file", "read", "path", "readBytes", "", "application"})
public final class FileOperations {
    @NotNull
    public final String read(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.readText$default((File)new File(path), null, (int)1, null);
    }

    @NotNull
    public final byte[] readBytes(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FilesKt.readBytes((File)new File(path));
    }

    @NotNull
    public final List<File> files(@NotNull String stubDataDir) {
        Intrinsics.checkNotNullParameter((Object)stubDataDir, (String)"stubDataDir");
        Object object = new File(stubDataDir).listFiles();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final boolean isFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new File(fileName).isFile();
    }

    public final boolean isDirectory(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new File(fileName).isDirectory();
    }

    public final boolean isJSONFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2.isFile() && StringsKt.equals((String)FilesKt.getExtension((File)file2), (String)"json", (boolean)true);
    }

    public final boolean extensionIsNot(@NotNull String fileName, @NotNull List<String> extensions) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        return !extensions.contains(FilesKt.getExtension((File)new File(fileName)));
    }
}

