/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.CompatibleCommandKt;
import application.FileOperations;
import application.JUnitBackwardCompatibilityTestRunner;
import application.Outcome;
import in.specmatic.core.BackwardCompatibilityTest;
import in.specmatic.core.Results;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.git.GitCommand;
import in.specmatic.core.log.CompositePrinter;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.log.Verbose;
import in.specmatic.stub.API;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.reporting.legacy.xml.LegacyXmlReportGeneratingListener;
import org.springframework.beans.factory.annotation.Autowired;
import picocli.CommandLine;

@CommandLine.Command(name="git", mixinStandardHelpOptions=true, description={"Checks backward compatibility of a contract in a git repository"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J:\u0010\u0018\u001a\u00020\u00022\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\b\b\u0001\u0010\u001c\u001a\u00020\u001a2\b\b\u0001\u0010\u001d\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0007J&\u0010 \u001a\u00020\u00022\b\b\u0001\u0010!\u001a\u00020\u001a2\b\b\u0001\u0010\u001d\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0007R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lapplication/GitCompatibleCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "fileOperations", "Lapplication/FileOperations;", "getFileOperations", "()Lapplication/FileOperations;", "setFileOperations", "(Lapplication/FileOperations;)V", "gitCommand", "Lin/specmatic/core/git/GitCommand;", "getGitCommand", "()Lin/specmatic/core/git/GitCommand;", "setGitCommand", "(Lin/specmatic/core/git/GitCommand;)V", "junitLauncher", "Lorg/junit/platform/launcher/Launcher;", "getJunitLauncher", "()Lorg/junit/platform/launcher/Launcher;", "setJunitLauncher", "(Lorg/junit/platform/launcher/Launcher;)V", "call", "()Ljava/lang/Integer;", "commits", "path", "", "newerCommit", "olderCommit", "junitReportDirName", "verbose", "", "file", "inputContractPath", "application"})
public final class GitCompatibleCommand
implements Callable<Integer> {
    @Autowired
    public GitCommand gitCommand;
    @Autowired
    public FileOperations fileOperations;
    @Autowired
    public Launcher junitLauncher;

    @NotNull
    public final GitCommand getGitCommand() {
        GitCommand gitCommand = this.gitCommand;
        if (gitCommand != null) {
            return gitCommand;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"gitCommand");
        return null;
    }

    public final void setGitCommand(@NotNull GitCommand gitCommand) {
        Intrinsics.checkNotNullParameter((Object)gitCommand, (String)"<set-?>");
        this.gitCommand = gitCommand;
    }

    @NotNull
    public final FileOperations getFileOperations() {
        FileOperations fileOperations = this.fileOperations;
        if (fileOperations != null) {
            return fileOperations;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fileOperations");
        return null;
    }

    public final void setFileOperations(@NotNull FileOperations fileOperations) {
        Intrinsics.checkNotNullParameter((Object)fileOperations, (String)"<set-?>");
        this.fileOperations = fileOperations;
    }

    @NotNull
    public final Launcher getJunitLauncher() {
        Launcher launcher = this.junitLauncher;
        if (launcher != null) {
            return launcher;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"junitLauncher");
        return null;
    }

    public final void setJunitLauncher(@NotNull Launcher launcher) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"<set-?>");
        this.junitLauncher = launcher;
    }

    @CommandLine.Command(name="file", description={"Compare file in working tree against HEAD"})
    public final int file(@CommandLine.Parameters(paramLabel="contractPath", defaultValue=".") @NotNull String inputContractPath, @CommandLine.Option(names={"--junitReportDir"}, required=false, defaultValue="") @NotNull String junitReportDirName, @CommandLine.Option(names={"--debug"}, required=false, defaultValue="false") boolean verbose) {
        int n;
        Intrinsics.checkNotNullParameter((Object)inputContractPath, (String)"inputContractPath");
        Intrinsics.checkNotNullParameter((Object)junitReportDirName, (String)"junitReportDirName");
        if (verbose) {
            LoggingKt.setLogger((LogStrategy)((LogStrategy)new Verbose(new CompositePrinter(null, 1, null))));
        }
        if (!(SpecmaticConfigKt.isContractFile((String)inputContractPath) || API.hasOpenApiFileExtension((String)inputContractPath) || new File(inputContractPath).isDirectory())) {
            LoggingKt.getLogger().log(SpecmaticConfigKt.invalidContractExtensionMessage((String)inputContractPath));
            return 1;
        }
        try {
            n = CompatibleCommandKt.access$backwardCompatibleOnFileOrDirectory(inputContractPath, this.getFileOperations(), (Function1)new Function1<String, Outcome<Results>>(this, junitReportDirName){
                final /* synthetic */ GitCompatibleCommand this$0;
                final /* synthetic */ String $junitReportDirName;
                {
                    this.this$0 = $receiver;
                    this.$junitReportDirName = $junitReportDirName;
                    super(1);
                }

                @NotNull
                public final Outcome<Results> invoke(@NotNull String contractPath) {
                    Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
                    Outcome<List<BackwardCompatibilityTest>> testGenerationOutcome = CompatibleCommandKt.generateFileBackwardCompatibilityTests(contractPath, this.this$0.getFileOperations(), this.this$0.getGitCommand());
                    return testGenerationOutcome.onSuccess((Function1)new Function1<List<? extends BackwardCompatibilityTest>, Outcome<Results>>(this.this$0, this.$junitReportDirName){
                        final /* synthetic */ GitCompatibleCommand this$0;
                        final /* synthetic */ String $junitReportDirName;
                        {
                            this.this$0 = $receiver;
                            this.$junitReportDirName = $junitReportDirName;
                            super(1);
                        }

                        @NotNull
                        public final Outcome<Results> invoke(@NotNull List<BackwardCompatibilityTest> tests) {
                            Intrinsics.checkNotNullParameter(tests, (String)"tests");
                            JUnitBackwardCompatibilityTestRunner.Companion.setTests(tests);
                            DiscoverySelector[] discoverySelectorArray = new DiscoverySelector[]{DiscoverySelectors.selectClass(JUnitBackwardCompatibilityTestRunner.class)};
                            LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(discoverySelectorArray).build();
                            Intrinsics.checkNotNullExpressionValue((Object)launcherDiscoveryRequest, (String)"build(...)");
                            LauncherDiscoveryRequest request = launcherDiscoveryRequest;
                            this.this$0.getJunitLauncher().discover(request);
                            if (!StringsKt.isBlank((CharSequence)this.$junitReportDirName)) {
                                LegacyXmlReportGeneratingListener reportListener = new LegacyXmlReportGeneratingListener(Paths.get(this.$junitReportDirName, new String[0]), new PrintWriter(System.out, true));
                                discoverySelectorArray = new TestExecutionListener[]{reportListener};
                                this.this$0.getJunitLauncher().registerTestExecutionListeners((TestExecutionListener[])discoverySelectorArray);
                            }
                            this.this$0.getJunitLauncher().execute(request, new TestExecutionListener[0]);
                            return JUnitBackwardCompatibilityTestRunner.Companion.outcome();
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            LogStrategy.DefaultImpls.log$default((LogStrategy)LoggingKt.getLogger(), (Throwable)e, null, (int)2, null);
            n = 1;
        }
        return n;
    }

    @CommandLine.Command(name="commits", description={"Compare file in newer commit against older commit"})
    public final int commits(@CommandLine.Parameters(paramLabel="contractPath", defaultValue=".") @NotNull String path, @CommandLine.Parameters(paramLabel="newerCommit") @NotNull String newerCommit, @CommandLine.Parameters(paramLabel="olderCommit") @NotNull String olderCommit, @CommandLine.Option(names={"--junitReportDir"}, required=false, defaultValue="") @NotNull String junitReportDirName, @CommandLine.Option(names={"--debug"}, required=false, defaultValue="false") boolean verbose) {
        int n;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)newerCommit, (String)"newerCommit");
        Intrinsics.checkNotNullParameter((Object)olderCommit, (String)"olderCommit");
        Intrinsics.checkNotNullParameter((Object)junitReportDirName, (String)"junitReportDirName");
        if (verbose) {
            LoggingKt.setLogger((LogStrategy)((LogStrategy)new Verbose(null, 1, null)));
        }
        try {
            n = CompatibleCommandKt.access$backwardCompatibleOnFileOrDirectory(path, this.getFileOperations(), (Function1)new Function1<String, Outcome<Results>>(newerCommit, olderCommit, this, junitReportDirName){
                final /* synthetic */ String $newerCommit;
                final /* synthetic */ String $olderCommit;
                final /* synthetic */ GitCompatibleCommand this$0;
                final /* synthetic */ String $junitReportDirName;
                {
                    this.$newerCommit = $newerCommit;
                    this.$olderCommit = $olderCommit;
                    this.this$0 = $receiver;
                    this.$junitReportDirName = $junitReportDirName;
                    super(1);
                }

                @NotNull
                public final Outcome<Results> invoke(@NotNull String contractPath) {
                    Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
                    Outcome<List<BackwardCompatibilityTest>> testGenerationOutcome = CompatibleCommandKt.generateCommitBackwardCompatibleTests(contractPath, this.$newerCommit, this.$olderCommit, this.this$0.getGitCommand());
                    return testGenerationOutcome.onSuccess((Function1)new Function1<List<? extends BackwardCompatibilityTest>, Outcome<Results>>(this.this$0, this.$junitReportDirName){
                        final /* synthetic */ GitCompatibleCommand this$0;
                        final /* synthetic */ String $junitReportDirName;
                        {
                            this.this$0 = $receiver;
                            this.$junitReportDirName = $junitReportDirName;
                            super(1);
                        }

                        @NotNull
                        public final Outcome<Results> invoke(@NotNull List<BackwardCompatibilityTest> tests) {
                            Intrinsics.checkNotNullParameter(tests, (String)"tests");
                            JUnitBackwardCompatibilityTestRunner.Companion.setTests(tests);
                            DiscoverySelector[] discoverySelectorArray = new DiscoverySelector[]{DiscoverySelectors.selectClass(JUnitBackwardCompatibilityTestRunner.class)};
                            LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(discoverySelectorArray).build();
                            Intrinsics.checkNotNullExpressionValue((Object)launcherDiscoveryRequest, (String)"build(...)");
                            LauncherDiscoveryRequest request = launcherDiscoveryRequest;
                            this.this$0.getJunitLauncher().discover(request);
                            if (!StringsKt.isBlank((CharSequence)this.$junitReportDirName)) {
                                LegacyXmlReportGeneratingListener reportListener = new LegacyXmlReportGeneratingListener(Paths.get(this.$junitReportDirName, new String[0]), new PrintWriter(System.out, true));
                                discoverySelectorArray = new TestExecutionListener[]{reportListener};
                                this.this$0.getJunitLauncher().registerTestExecutionListeners((TestExecutionListener[])discoverySelectorArray);
                            }
                            this.this$0.getJunitLauncher().execute(request, new TestExecutionListener[0]);
                            return JUnitBackwardCompatibilityTestRunner.Companion.outcome();
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            LogStrategy.DefaultImpls.log$default((LogStrategy)LoggingKt.getLogger(), (Throwable)e, null, (int)2, null);
            n = 1;
        }
        return n;
    }

    @Override
    @NotNull
    public Integer call() {
        new CommandLine((Object)new GitCompatibleCommand()).usage(System.out);
        return 0;
    }
}

