/*
 * Decompiled with CFR 0.152.
 */
package application;

import in.specmatic.core.RepositoryInfo;
import in.specmatic.core.Source;
import in.specmatic.core.SpecmaticConfigJson;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.azure.AzureAPI;
import in.specmatic.core.azure.AzureAuthToken;
import in.specmatic.core.azure.PersonalAccessToken;
import in.specmatic.core.git.GitOperations;
import in.specmatic.core.log.CompositePrinter;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.log.Verbose;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.Utilities;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="graph", mixinStandardHelpOptions=true, description={"Dependency graph"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\u001c\u0010\u0005\u001a\u00020\u00022\b\b\u0003\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lapplication/GraphCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "call", "consumers", "verbose", "", "azureBaseURL", "", "application"})
@SourceDebugExtension(value={"SMAP\nGraphCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphCommand.kt\napplication/GraphCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1855#2:89\n1855#2:90\n1855#2,2:91\n1856#2:93\n1856#2:94\n*S KotlinDebug\n*F\n+ 1 GraphCommand.kt\napplication/GraphCommand\n*L\n65#1:89\n68#1:90\n75#1:91,2\n68#1:93\n65#1:94\n*E\n"})
public final class GraphCommand
implements Callable<Unit> {
    @CommandLine.Command(name="consumers", description={"Display a list of services depending on contracts in this repo"})
    public final void consumers(@CommandLine.Option(names={"--verbose"}, description={"Print verbose logs"}) boolean verbose, @CommandLine.Option(names={"--azureBaseURL"}, required=true, description={"Azure base URL"}) @NotNull String azureBaseURL) {
        Intrinsics.checkNotNullParameter((Object)azureBaseURL, (String)"azureBaseURL");
        if (verbose) {
            LoggingKt.setLogger((LogStrategy)((LogStrategy)new Verbose(new CompositePrinter(null, 1, null))));
        }
        SpecmaticConfigJson configJson = SpecmaticConfigKt.loadSpecmaticJsonConfig$default(null, (int)1, null);
        String string = GitOperations.getPersonalAccessToken();
        if (string == null) {
            throw new ContractException("Access token not found, put it in " + System.getProperty("user.home") + "/specmatic.json", null, null, null, false, 30, null);
        }
        PersonalAccessToken azureAuthToken = new PersonalAccessToken(string);
        RepositoryInfo repositoryInfo = configJson.getRepository();
        if (repositoryInfo == null) {
            Utilities.exitWithMessage((String)"specmatic.json needs to contain a the repository information, as below:\n{\n  \"repository\": {\n    \"provider\": \"azure\"\n    \"collectionName\": \"NameOfTheCollectionContainingThisProject\"\n  }\n}");
            throw new KotlinNothingValueException();
        }
        RepositoryInfo repository = repositoryInfo;
        String collection = repository.getCollectionName();
        AzureAPI azure = new AzureAPI((AzureAuthToken)azureAuthToken, azureBaseURL, collection);
        LoggingKt.getLogger().log("Dependency projects");
        LoggingKt.getLogger().log("-------------------");
        Iterable $this$forEach$iv = configJson.getSources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Source source = (Source)element$iv;
            boolean bl = false;
            LoggingKt.getLogger().log("In central repo " + source.getRepository());
            List list = source.getTest();
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String relativeContractPath = (String)element$iv2;
                boolean bl2 = false;
                LoggingKt.getLogger().log("  Consumers of " + relativeContractPath);
                List consumers = azure.referencesToContract(relativeContractPath);
                if (consumers.isEmpty()) {
                    LoggingKt.getLogger().log("    ** no consumers found **");
                } else {
                    Iterable $this$forEach$iv3 = consumers;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        AzureAPI.ContractConsumerEntry it = (AzureAPI.ContractConsumerEntry)element$iv3;
                        boolean bl3 = false;
                        LoggingKt.getLogger().log("  - " + it.getDescription());
                    }
                }
                LoggingKt.getLogger().newLine();
            }
        }
    }

    public static /* synthetic */ void consumers$default(GraphCommand graphCommand, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        graphCommand.consumers(bl, string);
    }

    @Override
    public void call() {
    }
}

