/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ImportCommandKt;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.log.Verbose;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="import", mixinStandardHelpOptions=true, description={"Converts a Specmatic stub, Postman or WSDL file into a Specmatic spec file"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0014R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lapplication/ImportCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "path", "", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "userSpecifiedOutFile", "getUserSpecifiedOutFile", "setUserSpecifiedOutFile", "verbose", "", "getVerbose", "()Z", "setVerbose", "(Z)V", "call", "()Ljava/lang/Integer;", "application"})
public final class ImportCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"File to convert"})
    public String path;
    @CommandLine.Option(names={"--output"}, required=false, description={"Write the contract into this file"})
    @Nullable
    private String userSpecifiedOutFile;
    @CommandLine.Option(names={"--debug"}, required=false, defaultValue="false")
    private boolean verbose;

    @NotNull
    public final String getPath() {
        String string = this.path;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"path");
        return null;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @Nullable
    public final String getUserSpecifiedOutFile() {
        return this.userSpecifiedOutFile;
    }

    public final void setUserSpecifiedOutFile(@Nullable String string) {
        this.userSpecifiedOutFile = string;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Override
    @NotNull
    public Integer call() {
        if (this.verbose) {
            LoggingKt.setLogger((LogStrategy)((LogStrategy)new Verbose(null, 1, null)));
        }
        return LoggingKt.logException((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ImportCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (StringsKt.endsWith$default((String)this.this$0.getPath(), (String)".postman_collection.json", (boolean)false, (int)2, null)) {
                    ImportCommandKt.convertPostman(this.this$0.getPath(), this.this$0.getUserSpecifiedOutFile());
                } else if (StringsKt.endsWith$default((String)this.this$0.getPath(), (String)".json", (boolean)false, (int)2, null)) {
                    ImportCommandKt.convertStub(this.this$0.getPath(), this.this$0.getUserSpecifiedOutFile());
                } else if (StringsKt.endsWith$default((String)this.this$0.getPath(), (String)".wsdl", (boolean)false, (int)2, null)) {
                    ImportCommandKt.convertWSDL(this.this$0.getPath(), this.this$0.getUserSpecifiedOutFile());
                } else {
                    throw new Exception("File type not recognized. Support exceptions include .postman_collection.json (Postman), .json (Specmatic stub), .wsdl (WSDL)");
                }
            }
        }));
    }
}

