/*
 * Decompiled with CFR 0.152.
 */
package application;

import in.specmatic.conversions.BaseURLInfo;
import in.specmatic.conversions.BaseURLInfoKt;
import in.specmatic.conversions.ImportedPostmanContracts;
import in.specmatic.conversions.PostmanKt;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.NamedStub;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.utilities.JSONSerialisationKt;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.XMLNode;
import in.specmatic.core.value.XMLNodeKt;
import in.specmatic.core.wsdl.parser.WSDLKt;
import in.specmatic.mock.ScenarioStub;
import in.specmatic.mock.ScenarioStubKt;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a$\u0010\u000e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006\u0011"}, d2={"convertPostman", "", "path", "", "userSpecifiedOutPath", "convertStub", "userSpecifiedOutFile", "convertWSDL", "fileWithTag", "Ljava/io/File;", "file", "tag", "gherkinToOpenApiYAML", "gherkin", "writeOut", "outputFilePath", "hostAndPort", "application"})
public final class ImportCommandKt {
    public static final void convertStub(@NotNull String path, @Nullable String userSpecifiedOutFile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File inputFile = new File(path);
        ScenarioStub stub = ScenarioStubKt.mockFromJSON((Map)JSONSerialisationKt.jsonStringToValueMap((String)FilesKt.readText$default((File)inputFile, null, (int)1, null)));
        String gherkin = FeatureKt.toGherkinFeature((NamedStub)new NamedStub("New scenario", stub));
        String openApiYAML = ImportCommandKt.gherkinToOpenApiYAML(gherkin);
        Object object = userSpecifiedOutFile;
        if (object == null) {
            object = FilesKt.getNameWithoutExtension((File)inputFile) + ".yaml";
        }
        String outFile = object;
        ImportCommandKt.writeOut$default(openApiYAML, outFile, null, 4, null);
    }

    private static final String gherkinToOpenApiYAML(String gherkin) {
        OpenAPI openApi = FeatureKt.parseGherkinStringToFeature$default((String)gherkin, null, (int)2, null).toOpenApi();
        String string = Yaml.pretty((Object)openApi);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pretty(...)");
        return string;
    }

    public static final void convertPostman(@NotNull String path, @Nullable String userSpecifiedOutPath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File inputFile = new File(path);
        List contracts = PostmanKt.postmanCollectionToGherkin((String)FilesKt.readText$default((File)inputFile, null, (int)1, null));
        for (ImportedPostmanContracts contract : contracts) {
            PostmanKt.runTests((ImportedPostmanContracts)contract);
        }
        if (contracts.size() == 1) {
            Object object = userSpecifiedOutPath;
            if (object == null) {
                object = FilesKt.getNameWithoutExtension((File)inputFile) + ".yaml";
            }
            String outPath = object;
            ImportCommandKt.writeOut(ImportCommandKt.gherkinToOpenApiYAML(((ImportedPostmanContracts)CollectionsKt.first((List)contracts)).getGherkin()), outPath, BaseURLInfoKt.toFragment((BaseURLInfo)((ImportedPostmanContracts)CollectionsKt.first((List)contracts)).getBaseURLInfo()));
        } else {
            for (ImportedPostmanContracts contract : contracts) {
                String gherkin = contract.component2();
                BaseURLInfo baseURLInfo = contract.component3();
                Object object = userSpecifiedOutPath;
                if (object == null) {
                    object = FilesKt.getNameWithoutExtension((File)inputFile) + ".yaml";
                }
                String outFilePath = object;
                ImportCommandKt.writeOut(ImportCommandKt.gherkinToOpenApiYAML(gherkin), outFilePath, BaseURLInfoKt.toFragment((BaseURLInfo)baseURLInfo));
            }
        }
    }

    public static final void convertWSDL(@NotNull String path, @Nullable String userSpecifiedOutFile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File inputFile = new File(path);
        String inputFileContent = FilesKt.readText$default((File)inputFile, null, (int)1, null);
        XMLNode wsdlXML = XMLNodeKt.toXMLNode$default((Document)Utilities.parseXML((String)inputFileContent), null, (int)2, null);
        String contract = WSDLKt.WSDL((XMLNode)wsdlXML, (String)path).convertToGherkin();
        Object object = userSpecifiedOutFile;
        if (object == null) {
            object = FilesKt.getNameWithoutExtension((File)inputFile) + ".spec";
        }
        String outFile = object;
        ImportCommandKt.writeOut$default(contract, outFile, null, 4, null);
    }

    private static final void writeOut(String gherkin, String outputFilePath, String hostAndPort) {
        File outputFile = new File(outputFilePath);
        String string = hostAndPort;
        String tag = string != null ? "-" + StringsKt.replace$default((String)string, (String)":", (String)"-", (boolean)false, (int)4, null) : "";
        FilesKt.writeText$default((File)ImportCommandKt.fileWithTag(outputFile, tag), (String)gherkin, null, (int)2, null);
        LoggingKt.getLogger().log("Written to file " + ImportCommandKt.fileWithTag(outputFile, tag).getPath());
    }

    static /* synthetic */ void writeOut$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        ImportCommandKt.writeOut(string, string2, string3);
    }

    private static final File fileWithTag(File file2, String tag) {
        String string = file2.getAbsoluteFile().getParentFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        String taggedFilePath = StringsKt.removeSuffix((String)string, (CharSequence)string2) + File.separator + FilesKt.getNameWithoutExtension((File)file2) + tag + "." + FilesKt.getExtension((File)file2);
        return new File(taggedFilePath);
    }
}

