/*
 * Decompiled with CFR 0.152.
 */
package application;

import in.specmatic.core.Configuration;
import in.specmatic.core.Result;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="install", mixinStandardHelpOptions=true, description={"Clone the git repositories declared in the manifest"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lapplication/InstallCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "targetDirectory", "", "getTargetDirectory", "()Ljava/lang/String;", "setTargetDirectory", "(Ljava/lang/String;)V", "call", "application"})
public final class InstallCommand
implements Callable<Unit> {
    @CommandLine.Option(names={"--targetDirectory"}, description={"Directory in which the git repository will be cloned"})
    @NotNull
    private String targetDirectory;

    public InstallCommand() {
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.targetDirectory = string;
    }

    @NotNull
    public final String getTargetDirectory() {
        return this.targetDirectory;
    }

    public final void setTargetDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.targetDirectory = string;
    }

    @Override
    public void call() {
        List list;
        File userHome = new File(this.targetDirectory);
        File workingDirectory = FilesKt.resolve((File)userHome, (String)".specmatic/repos");
        try {
            list = Utilities.loadSources((String)Configuration.Companion.getGlobalConfigFileName());
        }
        catch (ContractException e) {
            Utilities.exitWithMessage((String)Result.toReport$default((Result)((Result)e.failure()), null, (int)1, null).toText());
            throw new KotlinNothingValueException();
        }
        List sources = list;
        for (ContractSource source : sources) {
            System.out.println((Object)("Installing " + source));
            source.install(workingDirectory);
        }
    }
}

