/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.CompatibleCommandKt;
import in.specmatic.core.Feature;
import in.specmatic.core.ResolverStrategies;
import in.specmatic.core.log.LoggingKt;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="merge", mixinStandardHelpOptions=true, description={"Merge the specified contracts"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0002H\u0016R$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lapplication/MergeCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "contractFiles", "", "Ljava/io/File;", "getContractFiles", "()Ljava/util/List;", "setContractFiles", "(Ljava/util/List;)V", "outputFile", "getOutputFile", "()Ljava/io/File;", "setOutputFile", "(Ljava/io/File;)V", "call", "application"})
@SourceDebugExtension(value={"SMAP\nMergeCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeCommand.kt\napplication/MergeCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1549#2:42\n1620#2,3:43\n1360#2:46\n1446#2,5:47\n*S KotlinDebug\n*F\n+ 1 MergeCommand.kt\napplication/MergeCommand\n*L\n24#1:42\n24#1:43,3\n34#1:46\n34#1:47,5\n*E\n"})
public final class MergeCommand
implements Callable<Unit> {
    @CommandLine.Parameters
    @NotNull
    private List<? extends File> contractFiles = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--merged-contract"})
    @NotNull
    private File outputFile = new File("new-contract.yaml");

    @NotNull
    public final List<File> getContractFiles() {
        return this.contractFiles;
    }

    public final void setContractFiles(@NotNull List<? extends File> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.contractFiles = list;
    }

    @NotNull
    public final File getOutputFile() {
        return this.outputFile;
    }

    public final void setOutputFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"<set-?>");
        this.outputFile = file2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        if (this.contractFiles.isEmpty()) {
            LoggingKt.getLogger().log("No contracts were specified.");
            return;
        }
        Iterable $this$map$iv = this.contractFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Feature feature;
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                String string = FilesKt.readText$default((File)it, null, (int)1, null);
                String string2 = it.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
                feature = CompatibleCommandKt.parseContract(string, string2);
            }
            catch (Throwable e) {
                System.out.println((Object)("Exception loading contract " + it.getCanonicalPath()));
                e.printStackTrace();
                return;
            }
            collection.add(feature);
        }
        List contracts = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = contracts;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Feature it = (Feature)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getScenarios();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8186;
        ResolverStrategies resolverStrategies = null;
        Map map = null;
        String string = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Map map2 = null;
        Map map3 = null;
        String string8 = ((Feature)CollectionsKt.first((List)contracts)).getName();
        Map map4 = null;
        List list = (List)destination$iv$iv2;
        Feature mergedFeature = new Feature(list, map4, string8, map3, map2, string7, string6, string5, string4, string3, string, map, resolverStrategies, n, defaultConstructorMarker);
        OpenAPI openApi = mergedFeature.toOpenApi();
        LoggingKt.getLogger().log("Writing merged contract file to " + this.outputFile.getPath());
        String string9 = Yaml.pretty((Object)openApi);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"pretty(...)");
        FilesKt.writeText$default((File)this.outputFile, (String)string9, null, (int)2, null);
    }
}

