/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.CertInfo;
import in.specmatic.core.KeyData;
import in.specmatic.core.log.LogMessage;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.log.StringLog;
import in.specmatic.core.log.Verbose;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.proxy.Proxy;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="proxy", mixinStandardHelpOptions=true, description={"Proxies requests to the specified target and converts the result into contracts and stubs"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u00101\u001a\u00020\u0002H\u0002J\b\u00102\u001a\u00020\u0002H\u0016J\u001c\u00103\u001a\u00020\u00022\b\u00104\u001a\u0004\u0018\u00010\u000b2\b\u0010+\u001a\u0004\u0018\u00010\u000bH\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001e\u0010\u0013\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001e\u0010\u0016\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001e\u0010\u0019\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001e\u0010\u001c\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000fR\u001e\u0010\u001f\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\r\"\u0004\b-\u0010\u000fR\u001e\u0010.\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\r\"\u0004\b0\u0010\u000f\u00a8\u00065"}, d2={"Lapplication/ProxyCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "debugLog", "", "getDebugLog", "()Z", "setDebugLog", "(Z)V", "host", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "keyPassword", "getKeyPassword", "setKeyPassword", "keyStoreAlias", "getKeyStoreAlias", "setKeyStoreAlias", "keyStoreDir", "getKeyStoreDir", "setKeyStoreDir", "keyStoreFile", "getKeyStoreFile", "setKeyStoreFile", "keyStorePassword", "getKeyStorePassword", "setKeyStorePassword", "port", "", "getPort", "()I", "setPort", "(I)V", "proxy", "Lin/specmatic/proxy/Proxy;", "getProxy", "()Lin/specmatic/proxy/Proxy;", "setProxy", "(Lin/specmatic/proxy/Proxy;)V", "proxySpecmaticDataDir", "getProxySpecmaticDataDir", "setProxySpecmaticDataDir", "targetBaseURL", "getTargetBaseURL", "setTargetBaseURL", "addShutdownHook", "call", "validatedProxySettings", "unknownProxyTarget", "application"})
@SourceDebugExtension(value={"SMAP\nProxyCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyCommand.kt\napplication/ProxyCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class ProxyCommand
implements Callable<Unit> {
    @CommandLine.Option(names={"--target"}, description={"Base URL of the target to proxy"})
    @NotNull
    private String targetBaseURL = "";
    @CommandLine.Option(names={"--host"}, description={"Host for the proxy"}, defaultValue="localhost")
    public String host;
    @CommandLine.Option(names={"--port"}, description={"Port for the proxy"}, defaultValue="9000")
    private int port = 9000;
    @CommandLine.Parameters(index="0", description={"Store data from the proxy interactions into this dir"})
    public String proxySpecmaticDataDir;
    @CommandLine.Option(names={"--httpsKeyStore"}, description={"Run the proxy on https using a key in this store"})
    @NotNull
    private String keyStoreFile = "";
    @CommandLine.Option(names={"--httpsKeyStoreDir"}, description={"Run the proxy on https, create a store named specmatic.jks in this directory"})
    @NotNull
    private String keyStoreDir = "";
    @CommandLine.Option(names={"--httpsKeyStorePassword"}, description={"Run the proxy on https, password for pre-existing key store"})
    @NotNull
    private String keyStorePassword = "forgotten";
    @CommandLine.Option(names={"--httpsKeyAlias"}, description={"Run the proxy on https using a key by this name"})
    @NotNull
    private String keyStoreAlias = "specmaticproxy";
    @CommandLine.Option(names={"--httpsPassword"}, description={"Key password if any"})
    @NotNull
    private String keyPassword = "forgotten";
    @CommandLine.Option(names={"--debug"}, description={"Write verbose logs to console for debugging"})
    private boolean debugLog;
    @Nullable
    private Proxy proxy;

    @NotNull
    public final String getTargetBaseURL() {
        return this.targetBaseURL;
    }

    public final void setTargetBaseURL(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.targetBaseURL = string;
    }

    @NotNull
    public final String getHost() {
        String string = this.host;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        return null;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getProxySpecmaticDataDir() {
        String string = this.proxySpecmaticDataDir;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"proxySpecmaticDataDir");
        return null;
    }

    public final void setProxySpecmaticDataDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.proxySpecmaticDataDir = string;
    }

    @NotNull
    public final String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public final void setKeyStoreFile(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStoreFile = string;
    }

    @NotNull
    public final String getKeyStoreDir() {
        return this.keyStoreDir;
    }

    public final void setKeyStoreDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStoreDir = string;
    }

    @NotNull
    public final String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public final void setKeyStorePassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStorePassword = string;
    }

    @NotNull
    public final String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public final void setKeyStoreAlias(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStoreAlias = string;
    }

    @NotNull
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    public final void setKeyPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyPassword = string;
    }

    public final boolean getDebugLog() {
        return this.debugLog;
    }

    public final void setDebugLog(boolean bl) {
        this.debugLog = bl;
    }

    @Nullable
    public final Proxy getProxy() {
        return this.proxy;
    }

    public final void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void call() {
        String string;
        if (this.debugLog) {
            LoggingKt.setLogger((LogStrategy)((LogStrategy)new Verbose(null, 1, null)));
        }
        this.validatedProxySettings(this.targetBaseURL, this.getProxySpecmaticDataDir());
        CertInfo certInfo = new CertInfo(this.keyStoreFile, this.keyStoreDir, this.keyStorePassword, this.keyStoreAlias, this.keyPassword);
        KeyData keyStoreData = certInfo.getHttpsCert();
        this.proxy = new Proxy(this.getHost(), this.port, this.targetBaseURL, this.getProxySpecmaticDataDir(), keyStoreData);
        this.addShutdownHook();
        KeyData keyData = keyStoreData;
        if (keyData != null) {
            KeyData it = keyData;
            boolean bl = false;
            string = "https";
        } else {
            string = "http";
        }
        String protocol = string;
        LoggingKt.consoleLog((LogMessage)((LogMessage)new StringLog("Proxy server is running on " + protocol + "://" + this.getHost() + ":" + this.port + ". Ctrl + C to stop.")));
        while (true) {
            Thread.sleep(10000L);
        }
    }

    private final void validatedProxySettings(String unknownProxyTarget, String proxySpecmaticDataDir) {
        if (unknownProxyTarget == null && proxySpecmaticDataDir == null) {
            return;
        }
        if (unknownProxyTarget != null && proxySpecmaticDataDir != null) {
            File dataDirFile = new File(proxySpecmaticDataDir);
            if (!dataDirFile.exists()) {
                try {
                    dataDirFile.mkdirs();
                }
                catch (Throwable e) {
                    Utilities.exitWithMessage((String)Utilities.exceptionCauseMessage((Throwable)e));
                    throw new KotlinNothingValueException();
                }
            } else {
                File[] fileArray = dataDirFile.listFiles();
                boolean bl = fileArray != null ? !(fileArray.length == 0) : false;
                if (bl) {
                    Utilities.exitWithMessage((String)("This data directory " + proxySpecmaticDataDir + " must be empty if it exists"));
                    throw new KotlinNothingValueException();
                }
            }
        }
    }

    private final void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            final /* synthetic */ ProxyCommand this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                try {
                    System.out.println((Object)"Shutting down stub servers");
                    Proxy proxy = this.this$0.getProxy();
                    if (proxy != null) {
                        proxy.close();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    LogStrategy.DefaultImpls.log$default((LogStrategy)LoggingKt.getLogger(), (Throwable)e, null, (int)2, null);
                }
            }
        });
    }
}

