/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.PushCommandKt;
import in.specmatic.core.Configuration;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.Result;
import in.specmatic.core.Results;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.TestBackwardCompatibilityKt;
import in.specmatic.core.git.NonZeroExitError;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.Value;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import picocli.CommandLine;

@CommandLine.Command(name="push", mixinStandardHelpOptions=true, description={"Check the new contract for backward compatibility with the specified version, then overwrite the old one with it."})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J(\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lapplication/PushCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "call", "testBackwardCompatibility", "sourceDir", "Ljava/io/File;", "contractPath", "", "sourceGit", "Lin/specmatic/core/git/SystemGit;", "source", "Lin/specmatic/core/utilities/ContractSource;", "application"})
@SourceDebugExtension(value={"SMAP\nPushCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PushCommand.kt\napplication/PushCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n766#2:157\n857#2,2:158\n*S KotlinDebug\n*F\n+ 1 PushCommand.kt\napplication/PushCommand\n*L\n38#1:157\n38#1:158,2\n*E\n"})
public final class PushCommand
implements Callable<Unit> {
    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        List list;
        JSONObjectValue jSONObjectValue;
        File userHome = new File(System.getProperty("user.home"));
        File workingDirectory = FilesKt.resolve((File)userHome, (String)".specmatic/repos");
        File manifestFile = new File(Configuration.Companion.getGlobalConfigFileName());
        try {
            jSONObjectValue = Utilities.loadConfigJSON((File)manifestFile);
        }
        catch (ContractException e) {
            Utilities.exitWithMessage((String)Result.toReport$default((Result)((Result)e.failure()), null, (int)1, null).toText());
            throw new KotlinNothingValueException();
        }
        JSONObjectValue manifestData = jSONObjectValue;
        try {
            list = Utilities.loadSources((JSONObjectValue)manifestData);
        }
        catch (ContractException e) {
            Utilities.exitWithMessage((String)Result.toReport$default((Result)((Result)e.failure()), null, (int)1, null).toText());
            throw new KotlinNothingValueException();
        }
        List sources = list;
        for (ContractSource source : sources) {
            File sourceDir = source.directoryRelativeTo(workingDirectory);
            String string = sourceDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            SystemGit sourceGit = new SystemGit(string, null, null, 6, null);
            try {
                void $this$filterTo$iv$iv;
                if (!sourceGit.workingDirectoryIsGitRepo()) continue;
                source.getLatest(sourceGit);
                Iterable $this$filter$iv = sourceGit.getChangedFiles();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!SpecmaticConfigKt.getCONTRACT_EXTENSIONS().contains(FilesKt.getExtension((File)new File(it)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List changedSpecFiles = (List)destination$iv$iv;
                for (String contractPath : changedSpecFiles) {
                    this.testBackwardCompatibility(sourceDir, contractPath, sourceGit, source);
                    Value value = (Value)manifestData;
                    String string2 = FilesKt.resolve((File)sourceDir, (String)contractPath).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    PushCommandKt.subscribeToContract(value, string2, sourceGit);
                }
                for (String contractPath : changedSpecFiles) {
                    sourceGit.add(contractPath);
                }
                source.pushUpdates(sourceGit);
                System.out.println((Object)"Done");
            }
            catch (NonZeroExitError e) {
                System.out.println((Object)("Couldn't push the latest. Got error: " + Utilities.exceptionCauseMessage((Throwable)e)));
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
    }

    private final void testBackwardCompatibility(File sourceDir, String contractPath, SystemGit sourceGit, ContractSource source) {
        Object gitRoot;
        File sourcePath = FilesKt.resolve((File)sourceDir, (String)contractPath);
        String newVersion = FilesKt.readText$default((File)sourcePath, null, (int)1, null);
        try {
            gitRoot = new File(sourceGit.gitRoot()).getAbsoluteFile();
            System.out.println((Object)("Git root: " + ((File)gitRoot).getPath()));
            System.out.println((Object)("Source path: " + sourcePath.getAbsoluteFile().getPath()));
            File file2 = sourcePath.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
            Intrinsics.checkNotNull((Object)gitRoot);
            File relativeSourcePath = FilesKt.relativeTo((File)file2, (File)gitRoot);
            System.out.println((Object)("Relative source path: " + relativeSourcePath.getPath()));
            String string = relativeSourcePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            gitRoot = sourceGit.show("HEAD", string);
        }
        catch (Throwable e) {
            gitRoot = "";
        }
        String oldVersion = gitRoot;
        if (((CharSequence)oldVersion).length() > 0) {
            Feature newVersionFeature = FeatureKt.parseGherkinStringToFeature$default((String)newVersion, null, (int)2, null);
            Feature oldVersionFeature = FeatureKt.parseGherkinStringToFeature$default((String)oldVersion, null, (int)2, null);
            Results results = TestBackwardCompatibilityKt.testBackwardCompatibility((Feature)oldVersionFeature, (Feature)newVersionFeature);
            if (!results.success()) {
                System.out.println((Object)results.report("Match not found"));
                System.out.println();
                Utilities.exitWithMessage((String)("The new version of " + source.pathDescriptor(contractPath) + " is not backward compatible."));
                throw new KotlinNothingValueException();
            }
        }
    }
}

