/*
 * Decompiled with CFR 0.152.
 */
package application;

import in.specmatic.core.git.GitOperations;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.Value;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"pipelineKeyInSpecmaticConfig", "", "hasAzureData", "", "azureInfo", "", "Lin/specmatic/core/value/Value;", "registerPipelineCredentials", "", "manifestData", "Lin/specmatic/core/value/JSONObjectValue;", "contractPath", "sourceGit", "Lin/specmatic/core/git/SystemGit;", "subscribeToContract", "application"})
@SourceDebugExtension(value={"SMAP\nPushCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PushCommand.kt\napplication/PushCommandKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n2624#3,3:158\n*S KotlinDebug\n*F\n+ 1 PushCommand.kt\napplication/PushCommandKt\n*L\n144#1:158,3\n*E\n"})
public final class PushCommandKt {
    @NotNull
    private static final String pipelineKeyInSpecmaticConfig = "pipeline";

    public static final boolean hasAzureData(@NotNull Map<String, ? extends Value> azureInfo) {
        boolean bl;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter(azureInfo, (String)"azureInfo");
            Object[] objectArray = new String[]{"organization", "project", "definitionId", "provider"};
            List expectedKeys = CollectionsKt.listOf((Object[])objectArray);
            Iterable iterable = expectedKeys;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl2 = false;
                boolean bl3 = !azureInfo.containsKey(it);
                if (!bl3) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        String missingKey = v1;
        if (missingKey == null) {
            bl = true;
        } else {
            System.out.println((Object)"Azure info must contain the key \"organisation\"");
            bl = false;
        }
        return bl;
    }

    public static final void subscribeToContract(@NotNull Value manifestData, @NotNull String contractPath, @NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)manifestData, (String)"manifestData");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        System.out.println((Object)"Checking to see if manifest has CI credentials");
        if (!(manifestData instanceof JSONObjectValue)) {
            Utilities.exitWithMessage((String)"Manifest must contain a json object");
            throw new KotlinNothingValueException();
        }
        if (((JSONObjectValue)manifestData).getJsonObject().containsKey(pipelineKeyInSpecmaticConfig)) {
            PushCommandKt.registerPipelineCredentials((JSONObjectValue)manifestData, contractPath, sourceGit);
        }
    }

    public static final void registerPipelineCredentials(@NotNull JSONObjectValue manifestData, @NotNull String contractPath, @NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)manifestData, (String)"manifestData");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        System.out.println((Object)"Manifest has pipeline credentials, checking if they are already registered");
        Object[] objectArray = new String[]{pipelineKeyInSpecmaticConfig, "provider"};
        Value value = GitOperations.loadFromPath((Value)((Value)manifestData), (List)CollectionsKt.listOf((Object[])objectArray));
        String provider = value != null ? value.toStringLiteral() : null;
        Map pipelineInfo = manifestData.getJSONObject(pipelineKeyInSpecmaticConfig);
        if (Intrinsics.areEqual((Object)provider, (Object)"azure") && PushCommandKt.hasAzureData(pipelineInfo)) {
            boolean bl;
            Value pipelines;
            Value specmaticConfig;
            String pipelinesKeyInContractMetaData;
            File specmaticConfigFile;
            File filePath;
            block10: {
                filePath = new File(contractPath);
                specmaticConfigFile = new File(filePath.getParent() + "/" + FilesKt.getNameWithoutExtension((File)filePath) + ".json");
                pipelinesKeyInContractMetaData = "pipelines";
                if (specmaticConfigFile.exists()) {
                    v1 = GrammarKt.parsedJSON$default((String)FilesKt.readText$default((File)specmaticConfigFile, null, (int)1, null), null, (int)2, null);
                } else {
                    System.out.println((Object)"Could not find Specmatic config file");
                    v1 = specmaticConfig = (Value)new JSONObjectValue(MapsKt.mapOf((Pair)TuplesKt.to((Object)pipelinesKeyInContractMetaData, (Object)new JSONArrayValue(CollectionsKt.emptyList()))));
                }
                if (!(specmaticConfig instanceof JSONObjectValue)) {
                    Utilities.exitWithMessage((String)"Contract meta data must contain a json object");
                    throw new KotlinNothingValueException();
                }
                if (!((JSONObjectValue)specmaticConfig).getJsonObject().containsKey(pipelinesKeyInContractMetaData)) {
                    Utilities.exitWithMessage((String)"Contract meta data must contain the key \"azure-pipelines\"");
                    throw new KotlinNothingValueException();
                }
                pipelines = (Value)MapsKt.getValue((Map)((JSONObjectValue)specmaticConfig).getJsonObject(), (Object)pipelinesKeyInContractMetaData);
                if (!(pipelines instanceof JSONArrayValue)) {
                    Utilities.exitWithMessage((String)"\"azure-pipelines\" key must contain a list of pipelines");
                    throw new KotlinNothingValueException();
                }
                Iterable $this$none$iv = ((JSONArrayValue)pipelines).getList();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Value it = (Value)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof JSONObjectValue && Intrinsics.areEqual((Object)((JSONObjectValue)it).getJsonObject(), (Object)pipelineInfo))) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (bl) {
                System.out.println((Object)("Updating the contract manifest to run this project's CI when " + filePath.getName() + " changes..."));
                JSONArrayValue newPipelines = new JSONArrayValue(CollectionsKt.plus((Collection)((JSONArrayValue)pipelines).getList(), (Object)new JSONObjectValue(pipelineInfo)));
                Map newMetaData = MapsKt.plus((Map)((JSONObjectValue)specmaticConfig).getJsonObject(), (Pair)TuplesKt.to((Object)pipelinesKeyInContractMetaData, (Object)newPipelines));
                FilesKt.writeText$default((File)specmaticConfigFile, (String)new JSONObjectValue(newMetaData).toStringLiteral(), null, (int)2, null);
                sourceGit.add();
            }
        }
    }
}

