/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.APIReDeclarations;
import application.ContractToCheck;
import application.GitCompatibleCommand;
import application.ReDeclaredAPICommand;
import application.RedeclaredAPICommandKt;
import in.specmatic.core.Feature;
import in.specmatic.core.git.GitCommand;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.log.LogMessage;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="redeclared", mixinStandardHelpOptions=true, description={"Checks if new APIs in this file have been re-declared"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u0002H\u0016J:\u0010\u000b\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\t2\b\b\u0003\u0010\r\u001a\u00020\u00052\u0010\b\u0003\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00052\b\b\u0001\u0010\u0011\u001a\u00020\tH\u0007J*\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00022\u001e\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u00170\u000fH\u0002JB\u0010\u0018\u001a\u00020\u00022\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u00142\u001e\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\u00170\u000fH\u0002\u00a8\u0006\u001a"}, d2={"Lapplication/ReDeclaredAPICommand;", "Ljava/util/concurrent/Callable;", "", "()V", "branch", "", "json", "", "mainBranch", "", "call", "entireRepo", "suppliedBaseDirectory", "systemLevel", "ignoreAPIs", "", "file", "contractFilePath", "logReDeclarations", "reDeclarations", "", "printJSON", "sorted", "", "printText", "JSONArrayLogMessage", "application"})
@SourceDebugExtension(value={"SMAP\nRedeclaredAPICommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedeclaredAPICommand.kt\napplication/ReDeclaredAPICommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,247:1\n1855#2,2:248\n766#2:257\n857#2,2:258\n1360#2:260\n1446#2,5:261\n1477#2:266\n1502#2,3:267\n1505#2,3:277\n1238#2,2:282\n1360#2:284\n1446#2,5:285\n1241#2:290\n1045#2:298\n1855#2:299\n1549#2:300\n1620#2,3:301\n1856#2:304\n1549#2:305\n1620#2,2:306\n1549#2:308\n1620#2,3:309\n1622#2:312\n478#3,7:250\n372#3,7:270\n453#3:280\n403#3:281\n526#3:291\n511#3,6:292\n*S KotlinDebug\n*F\n+ 1 RedeclaredAPICommand.kt\napplication/ReDeclaredAPICommand\n*L\n43#1:248,2\n86#1:257\n86#1:258,2\n87#1:260\n87#1:261,5\n89#1:266\n89#1:267,3\n89#1:277,3\n91#1:282,2\n92#1:284\n92#1:285,5\n91#1:290\n109#1:298\n123#1:299\n126#1:300\n126#1:301,3\n123#1:304\n135#1:305\n135#1:306,2\n136#1:308\n136#1:309,3\n135#1:312\n72#1:250,7\n89#1:270,7\n91#1:280\n91#1:281\n93#1:291\n93#1:292,6\n*E\n"})
public final class ReDeclaredAPICommand
implements Callable<Unit> {
    @CommandLine.Command(name="file", description={"Check the specified contract for re-declarations"})
    public final int file(@CommandLine.Parameters(paramLabel="contractPath") @NotNull String contractFilePath) {
        Intrinsics.checkNotNullParameter((Object)contractFilePath, (String)"contractFilePath");
        List<APIReDeclarations> reDeclarations = RedeclaredAPICommandKt.findReDeclaredContracts(new ContractToCheck(contractFilePath, (GitCommand)new SystemGit(null, null, null, 7, null)));
        if (!((Collection)reDeclarations).isEmpty()) {
            LoggingKt.getLogger().log("Some APIs in " + contractFilePath + " have been declared in other files as well.");
            LoggingKt.getLogger().newLine();
        }
        Iterable $this$forEach$iv = reDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            APIReDeclarations aPIReDeclarations = (APIReDeclarations)element$iv;
            boolean bl = false;
            String newPath = aPIReDeclarations.component1();
            List<String> contracts = aPIReDeclarations.component2();
            LoggingKt.getLogger().log(newPath);
            LoggingKt.getLogger().log(CollectionsKt.joinToString$default((Iterable)contracts, (CharSequence)"\n", null, null, (int)0, null, (Function1)file.1.1.INSTANCE, (int)30, null));
        }
        return !((Collection)reDeclarations).isEmpty() ? 1 : 0;
    }

    @CommandLine.Command(name="entire-repo", description={"Check all contracts in the repo for re-declarations"})
    public final int entireRepo(@CommandLine.Option(names={"--json"}) boolean json2, @CommandLine.Option(names={"--baseDirectory"}) @Nullable String suppliedBaseDirectory, @CommandLine.Option(names={"--systemLevel"}) int systemLevel, @CommandLine.Option(names={"--ignoreAPI"}) @Nullable List<String> ignoreAPIs) {
        String string = suppliedBaseDirectory;
        if (string == null) {
            string = new SystemGit(null, null, null, 7, null).gitRoot();
        }
        String baseDirectory = string;
        List<Pair<Feature, String>> contracts = RedeclaredAPICommandKt.fetchAllContracts(baseDirectory);
        List list = ignoreAPIs;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List ignorableAPIs = list;
        Map<String, List<String>> $this$filterKeys$iv = RedeclaredAPICommandKt.findReDeclarationsAmongstContracts(contracts, baseDirectory, systemLevel);
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, List<String>> result$iv = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!(!ignorableAPIs.contains(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map reDeclarations = result$iv;
        this.logReDeclarations(json2, reDeclarations);
        return !reDeclarations.isEmpty() ? 1 : 0;
    }

    public static /* synthetic */ int entireRepo$default(ReDeclaredAPICommand reDeclaredAPICommand, boolean bl, String string, int n, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return reDeclaredAPICommand.entireRepo(bl, string, n, list);
    }

    /*
     * WARNING - void declaration
     */
    @CommandLine.Command(name="branch", description={"Check all new or updated contracts in the branch for re-declarations"})
    public final int branch(@CommandLine.Option(names={"--json"}) boolean json2, @CommandLine.Option(names={"--main-branch"}, defaultValue="master") @NotNull String mainBranch) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapValuesTo$iv$iv;
        Object $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$flatMapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)mainBranch, (String)"mainBranch");
        Iterable $this$filter$iv2 = new SystemGit(null, null, null, 7, null).getChangesFromMainBranch(mainBranch);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!new File(it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it, (String)"yaml", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relativePaths = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = relativePaths;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it2 = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = RedeclaredAPICommandKt.findReDeclaredContracts(new ContractToCheck(it2, (GitCommand)new SystemGit(null, null, null, 7, null)));
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            APIReDeclarations it3 = (APIReDeclarations)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it3.getApiURLPath();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            void entry;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv2;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object2 = object;
            boolean bl3 = false;
            Iterable $this$flatMap$iv2 = (Iterable)entry.getValue();
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                APIReDeclarations it4 = (APIReDeclarations)element$iv$iv;
                boolean bl4 = false;
                Iterable list$iv$iv = it4.getContractsContainingAPI();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List list = CollectionsKt.distinct((Iterable)((List)destination$iv$iv3));
            object2.put(k, list);
        }
        $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$filter2 = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it5 = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((List)it5.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object reDeclarations = destination$iv$iv2;
        this.logReDeclarations(json2, (Map<String, ? extends List<String>>)reDeclarations);
        return !reDeclarations.isEmpty() ? 1 : 0;
    }

    private final void logReDeclarations(boolean json2, Map<String, ? extends List<String>> reDeclarations) {
        Iterable $this$sortedBy$iv = reDeclarations.entrySet();
        boolean $i$f$sortedBy = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                boolean bl = false;
                String api = (String)entry.getKey();
                entry = (Map.Entry)b;
                Comparable comparable = (Comparable)((Object)api);
                bl = false;
                api = (String)entry.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)api)));
            }
        });
        if (json2) {
            this.printJSON(sorted);
        } else {
            this.printText(reDeclarations, sorted);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printText(Map<String, ? extends List<String>> reDeclarations, List<? extends Map.Entry<String, ? extends List<String>>> sorted) {
        if (!reDeclarations.isEmpty()) {
            LoggingKt.getLogger().log("Some APIs have been declared in multiple files.");
            LoggingKt.getLogger().newLine();
        }
        Iterable $this$forEach$iv = sorted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String newPath = (String)entry.getKey();
            List contracts = (List)entry.getValue();
            LoggingKt.getLogger().log(newPath);
            LoggingKt.getLogger().log(CollectionsKt.joinToString$default((Iterable)contracts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            Iterable $this$map$iv = contracts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(FilesKt.readText$default((File)new File((String)it), null, (int)1, null));
            }
            if (CollectionsKt.distinct((Iterable)((List)destination$iv$iv)).size() == 1) {
                LoggingKt.getLogger().log("NOTE: These files are exact duplicates");
            }
            LoggingKt.getLogger().newLine();
        }
        LoggingKt.getLogger().log("Count of APIs re-declared: " + reDeclarations.size());
    }

    /*
     * WARNING - void declaration
     */
    private final void printJSON(List<? extends Map.Entry<String, ? extends List<String>>> sorted) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = sorted;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String api = (String)entry.getKey();
            List files = (List)entry.getValue();
            Iterable $this$map$iv2 = files;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new StringValue((String)it));
            }
            List list = (List)destination$iv$iv2;
            JSONArrayValue jsonFileList = new JSONArrayValue(list);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"api", (Object)new StringValue(api)), TuplesKt.to((Object)"files", (Object)jsonFileList)};
            collection.add(new JSONObjectValue(MapsKt.mapOf((Pair[])pairArray)));
        }
        List list = (List)destination$iv$iv;
        JSONArrayValue reDeclarationsJSON = new JSONArrayValue(list);
        LoggingKt.getLogger().log((LogMessage)new JSONArrayLogMessage(reDeclarationsJSON));
    }

    @Override
    public void call() {
        new CommandLine((Object)new GitCompatibleCommand()).usage(System.out);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lapplication/ReDeclaredAPICommand$JSONArrayLogMessage;", "Lin/specmatic/core/log/LogMessage;", "json", "Lin/specmatic/core/value/JSONArrayValue;", "(Lin/specmatic/core/value/JSONArrayValue;)V", "getJson", "()Lin/specmatic/core/value/JSONArrayValue;", "toJSONObject", "Lin/specmatic/core/value/JSONObjectValue;", "toLogString", "", "application"})
    public static final class JSONArrayLogMessage
    implements LogMessage {
        @NotNull
        private final JSONArrayValue json;

        public JSONArrayLogMessage(@NotNull JSONArrayValue json2) {
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            this.json = json2;
        }

        @NotNull
        public final JSONArrayValue getJson() {
            return this.json;
        }

        @NotNull
        public JSONObjectValue toJSONObject() {
            return new JSONObjectValue(MapsKt.mapOf((Pair)TuplesKt.to((Object)"list", (Object)this.json)));
        }

        @NotNull
        public String toLogString() {
            return this.json.displayableValue();
        }
    }
}

