/*
 * Decompiled with CFR 0.152.
 */
package application;

import in.specmatic.core.Contract;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.log.CompositePrinter;
import in.specmatic.core.log.JSONConsoleLogPrinter;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.log.NonVerbose;
import in.specmatic.stub.HttpStub;
import in.specmatic.test.TestExecutor;
import java.io.Closeable;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="samples", mixinStandardHelpOptions=true, description={"Generate samples of the API requests and responses for all scenarios"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lapplication/SamplesCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "contractFile", "Ljava/io/File;", "getContractFile", "()Ljava/io/File;", "setContractFile", "(Ljava/io/File;)V", "call", "application"})
public final class SamplesCommand
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Contract file path"})
    public File contractFile;

    @NotNull
    public final File getContractFile() {
        File file2 = this.contractFile;
        if (file2 != null) {
            return file2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"contractFile");
        return null;
    }

    public final void setContractFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"<set-?>");
        this.contractFile = file2;
    }

    @Override
    public void call() {
        LoggingKt.setLogger((LogStrategy)((LogStrategy)new NonVerbose(new CompositePrinter(CollectionsKt.listOf((Object)JSONConsoleLogPrinter.INSTANCE)))));
        LoggingKt.logException((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SamplesCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                if (!this.this$0.getContractFile().exists()) {
                    throw new Exception("Could not find file " + this.this$0.getContractFile().getPath());
                }
                try {
                    Feature feature = FeatureKt.parseContractFileToFeature$default((File)this.this$0.getContractFile(), null, null, null, null, null, null, null, (int)254, null);
                    Closeable closeable = (Closeable)new HttpStub(feature, CollectionsKt.emptyList(), "127.0.0.1", 56789, null, 16, null);
                    Throwable throwable = null;
                    try {
                        HttpStub stub = (HttpStub)closeable;
                        boolean bl = false;
                        Feature.executeTests$default((Feature)feature, (TestExecutor)((TestExecutor)stub.getClient()), null, (int)2, null);
                        new Contract(feature).samples(stub);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (StackOverflowError e) {
                    LoggingKt.getLogger().log("Got a stack overflow error. You probably have a recursive data structure definition in the contract.");
                }
            }
        }));
    }
}

