/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.CertInfo;
import application.FileOperations;
import application.HTTPStubEngine;
import application.PortUtilKt;
import application.SpecmaticConfig;
import application.StubCommandKt;
import application.StubLoaderEngine;
import application.WatchMaker;
import application.Watcher;
import in.specmatic.core.Configuration;
import in.specmatic.core.Feature;
import in.specmatic.core.WorkingDirectory;
import in.specmatic.core.log.CompositePrinter;
import in.specmatic.core.log.ConsolePrinter;
import in.specmatic.core.log.JSONConsoleLogPrinter;
import in.specmatic.core.log.JSONFilePrinter;
import in.specmatic.core.log.LogDirectory;
import in.specmatic.core.log.LogFile;
import in.specmatic.core.log.LogMessage;
import in.specmatic.core.log.LogPrinter;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LogTail;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.log.NonVerbose;
import in.specmatic.core.log.StringLog;
import in.specmatic.core.log.TextFilePrinter;
import in.specmatic.core.log.Verbose;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.mock.ScenarioStub;
import in.specmatic.stub.ContractStub;
import in.specmatic.stub.HttpClientFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import picocli.CommandLine;

@CommandLine.Command(name="stub", mixinStandardHelpOptions=true, description={"Start a stub server with contract"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010c\u001a\u00020\u0002H\u0002J\b\u0010d\u001a\u00020\u0002H\u0016J\u000e\u0010e\u001a\b\u0012\u0004\u0012\u00020f0\u000bH\u0002J\u000e\u0010g\u001a\b\u0012\u0004\u0012\u00020f0\u000bH\u0002J\u000e\u0010h\u001a\b\u0012\u0004\u0012\u00020f0\u000bH\u0002J\u000e\u0010i\u001a\b\u0012\u0004\u0012\u00020f0\u000bH\u0002J\u0010\u0010j\u001a\u00020)2\u0006\u0010I\u001a\u00020JH\u0002J\b\u0010k\u001a\u00020\u0002H\u0002J\b\u0010l\u001a\u00020\u0002H\u0002J\b\u0010m\u001a\u00020\u0002H\u0002R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u000fR\u0016\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u0016\u0010\u001c\u001a\u00020\u001d8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0012\u0010&\u001a\u00020'8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020)8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R \u0010.\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\tR\u001e\u00101\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0007\"\u0004\b3\u0010\tR\u001e\u00104\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0007\"\u0004\b6\u0010\tR\u001e\u00107\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0007\"\u0004\b9\u0010\tR\u001e\u0010:\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u0007\"\u0004\b<\u0010\tR\u001e\u0010=\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0007\"\u0004\b?\u0010\tR\u001e\u0010@\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0007\"\u0004\bB\u0010\tR\u001e\u0010C\u001a\u00020)8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010+\"\u0004\bE\u0010-R\u001e\u0010F\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u0007\"\u0004\bH\u0010\tR\u001e\u0010I\u001a\u00020J8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0012\u0010O\u001a\u00020P8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010Q\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010\u0007\"\u0004\bS\u0010\tR\u001e\u0010T\u001a\u00020)8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010+\"\u0004\bV\u0010-R\u0012\u0010W\u001a\u00020X8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010Y\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u0007\"\u0004\b[\u0010\tR\u001e\u0010\\\u001a\u00020)8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010+\"\u0004\b^\u0010-R\u0016\u0010_\u001a\u00020`8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010b\u00a8\u0006n"}, d2={"Lapplication/StubCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "configFileName", "", "getConfigFileName", "()Ljava/lang/String;", "setConfigFileName", "(Ljava/lang/String;)V", "contractPaths", "", "getContractPaths", "()Ljava/util/List;", "setContractPaths", "(Ljava/util/List;)V", "contractSources", "Lin/specmatic/core/utilities/ContractPathData;", "dataDirs", "getDataDirs", "setDataDirs", "fileOperations", "Lapplication/FileOperations;", "getFileOperations", "()Lapplication/FileOperations;", "host", "getHost", "setHost", "httpClientFactory", "Lin/specmatic/stub/HttpClientFactory;", "getHttpClientFactory", "()Lin/specmatic/stub/HttpClientFactory;", "httpStub", "Lin/specmatic/stub/ContractStub;", "getHttpStub", "()Lin/specmatic/stub/ContractStub;", "setHttpStub", "(Lin/specmatic/stub/ContractStub;)V", "httpStubEngine", "Lapplication/HTTPStubEngine;", "jsonConsoleLog", "", "getJsonConsoleLog", "()Z", "setJsonConsoleLog", "(Z)V", "jsonLog", "getJsonLog", "setJsonLog", "keyPassword", "getKeyPassword", "setKeyPassword", "keyStoreAlias", "getKeyStoreAlias", "setKeyStoreAlias", "keyStoreDir", "getKeyStoreDir", "setKeyStoreDir", "keyStoreFile", "getKeyStoreFile", "setKeyStoreFile", "keyStorePassword", "getKeyStorePassword", "setKeyStorePassword", "logPrefix", "getLogPrefix", "setLogPrefix", "noConsoleLog", "getNoConsoleLog", "setNoConsoleLog", "passThroughTargetBase", "getPassThroughTargetBase", "setPassThroughTargetBase", "port", "", "getPort", "()I", "setPort", "(I)V", "specmaticConfig", "Lapplication/SpecmaticConfig;", "specmaticConfigPath", "getSpecmaticConfigPath", "setSpecmaticConfigPath", "strictMode", "getStrictMode", "setStrictMode", "stubLoaderEngine", "Lapplication/StubLoaderEngine;", "textLog", "getTextLog", "setTextLog", "verbose", "getVerbose", "setVerbose", "watchMaker", "Lapplication/WatchMaker;", "getWatchMaker", "()Lapplication/WatchMaker;", "addShutdownHook", "call", "configureConsoleLogPrinter", "Lin/specmatic/core/log/LogPrinter;", "configureJSONLogPrinter", "configureLogPrinters", "configureTextLogPrinter", "isDefaultPort", "restartServer", "startServer", "stopServer", "application"})
@SourceDebugExtension(value={"SMAP\nStubCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StubCommand.kt\napplication/StubCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1549#2:229\n1620#2,3:230\n1549#2:233\n1620#2,3:234\n*S KotlinDebug\n*F\n+ 1 StubCommand.kt\napplication/StubCommand\n*L\n121#1:229\n121#1:230,3\n125#1:233\n125#1:234,3\n*E\n"})
public final class StubCommand
implements Callable<Unit> {
    @Nullable
    private ContractStub httpStub;
    @Autowired
    @NotNull
    private HTTPStubEngine httpStubEngine = new HTTPStubEngine();
    @Autowired
    @NotNull
    private StubLoaderEngine stubLoaderEngine = new StubLoaderEngine();
    @Autowired
    @NotNull
    private SpecmaticConfig specmaticConfig = new SpecmaticConfig();
    @CommandLine.Parameters(description={"Contract file paths"}, arity="0..*")
    @NotNull
    private List<String> contractPaths = new ArrayList();
    @CommandLine.Option(names={"--data"}, required=false, description={"Directory in which contract data may be found"})
    @NotNull
    private List<String> dataDirs = new ArrayList();
    @CommandLine.Option(names={"--host"}, description={"Host for the http stub"}, defaultValue="0.0.0.0")
    public String host;
    @CommandLine.Option(names={"--port"}, description={"Port for the http stub"}, defaultValue="9000")
    private int port;
    @CommandLine.Option(names={"--strict"}, required=false, description={"Start HTTP stub in strict mode"})
    private boolean strictMode;
    @CommandLine.Option(names={"--passThroughTargetBase"}, description={"All requests that did not match a url in any contract will be forwarded to this service"})
    @NotNull
    private String passThroughTargetBase = "";
    @CommandLine.Option(names={"--httpsKeyStore"}, description={"Run the proxy on https using a key in this store"})
    @NotNull
    private String keyStoreFile = "";
    @CommandLine.Option(names={"--httpsKeyStoreDir"}, description={"Run the proxy on https, create a store named specmatic.jks in this directory"})
    @NotNull
    private String keyStoreDir = "";
    @CommandLine.Option(names={"--httpsKeyStorePassword"}, description={"Run the proxy on https, password for pre-existing key store"})
    @NotNull
    private String keyStorePassword = "forgotten";
    @CommandLine.Option(names={"--httpsKeyAlias"}, description={"Run the proxy on https using a key by this name"})
    @NotNull
    private String keyStoreAlias = "specmaticproxy";
    @CommandLine.Option(names={"--httpsPassword"}, description={"Key password if any"})
    @NotNull
    private String keyPassword = "forgotten";
    @CommandLine.Option(names={"--debug"}, description={"Debug logs"})
    private boolean verbose;
    @CommandLine.Option(names={"--config"}, description={"Configuration file name (specmatic.json by default)"})
    @Nullable
    private String configFileName;
    @CommandLine.Option(names={"--textLog"}, description={"Directory in which to write a text log"})
    @Nullable
    private String textLog;
    @CommandLine.Option(names={"--jsonLog"}, description={"Directory in which to write a JSON log"})
    @Nullable
    private String jsonLog;
    @CommandLine.Option(names={"--jsonConsoleLog"}, description={"Console log should be in JSON format"})
    private boolean jsonConsoleLog;
    @CommandLine.Option(names={"--noConsoleLog"}, description={"Don't log to console"})
    private boolean noConsoleLog;
    @CommandLine.Option(names={"--logPrefix"}, description={"Prefix of log file"})
    @NotNull
    private String logPrefix = "specmatic";
    @Autowired
    @NotNull
    private final WatchMaker watchMaker = new WatchMaker();
    @Autowired
    @NotNull
    private final FileOperations fileOperations = new FileOperations();
    @Autowired
    @NotNull
    private final HttpClientFactory httpClientFactory = new HttpClientFactory();
    @NotNull
    private List<ContractPathData> contractSources = CollectionsKt.emptyList();
    @Nullable
    private String specmaticConfigPath;

    @Nullable
    public final ContractStub getHttpStub() {
        return this.httpStub;
    }

    public final void setHttpStub(@Nullable ContractStub contractStub) {
        this.httpStub = contractStub;
    }

    @NotNull
    public final List<String> getContractPaths() {
        return this.contractPaths;
    }

    public final void setContractPaths(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.contractPaths = list;
    }

    @NotNull
    public final List<String> getDataDirs() {
        return this.dataDirs;
    }

    public final void setDataDirs(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dataDirs = list;
    }

    @NotNull
    public final String getHost() {
        String string = this.host;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        return null;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final boolean getStrictMode() {
        return this.strictMode;
    }

    public final void setStrictMode(boolean bl) {
        this.strictMode = bl;
    }

    @NotNull
    public final String getPassThroughTargetBase() {
        return this.passThroughTargetBase;
    }

    public final void setPassThroughTargetBase(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.passThroughTargetBase = string;
    }

    @NotNull
    public final String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public final void setKeyStoreFile(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStoreFile = string;
    }

    @NotNull
    public final String getKeyStoreDir() {
        return this.keyStoreDir;
    }

    public final void setKeyStoreDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStoreDir = string;
    }

    @NotNull
    public final String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public final void setKeyStorePassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStorePassword = string;
    }

    @NotNull
    public final String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public final void setKeyStoreAlias(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStoreAlias = string;
    }

    @NotNull
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    public final void setKeyPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyPassword = string;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Nullable
    public final String getConfigFileName() {
        return this.configFileName;
    }

    public final void setConfigFileName(@Nullable String string) {
        this.configFileName = string;
    }

    @Nullable
    public final String getTextLog() {
        return this.textLog;
    }

    public final void setTextLog(@Nullable String string) {
        this.textLog = string;
    }

    @Nullable
    public final String getJsonLog() {
        return this.jsonLog;
    }

    public final void setJsonLog(@Nullable String string) {
        this.jsonLog = string;
    }

    public final boolean getJsonConsoleLog() {
        return this.jsonConsoleLog;
    }

    public final void setJsonConsoleLog(boolean bl) {
        this.jsonConsoleLog = bl;
    }

    public final boolean getNoConsoleLog() {
        return this.noConsoleLog;
    }

    public final void setNoConsoleLog(boolean bl) {
        this.noConsoleLog = bl;
    }

    @NotNull
    public final String getLogPrefix() {
        return this.logPrefix;
    }

    public final void setLogPrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.logPrefix = string;
    }

    @NotNull
    public final WatchMaker getWatchMaker() {
        return this.watchMaker;
    }

    @NotNull
    public final FileOperations getFileOperations() {
        return this.fileOperations;
    }

    @NotNull
    public final HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    @Nullable
    public final String getSpecmaticConfigPath() {
        return this.specmaticConfigPath;
    }

    public final void setSpecmaticConfigPath(@Nullable String string) {
        this.specmaticConfigPath = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        List<LogPrinter> logPrinters = this.configureLogPrinters();
        LoggingKt.setLogger((LogStrategy)(this.verbose ? (LogStrategy)new Verbose(new CompositePrinter(logPrinters)) : (LogStrategy)new NonVerbose(new CompositePrinter(logPrinters))));
        String string = this.configFileName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Configuration.Companion.setGlobalConfigFileName(it);
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection collection;
            StubCommand stubCommand;
            List list;
            StubCommand stubCommand2 = this;
            if (this.contractPaths.isEmpty()) {
                LoggingKt.getLogger().debug("No contractPaths specified. Using configuration file named " + this.configFileName);
                this.specmaticConfigPath = new File(Configuration.Companion.getGlobalConfigFileName()).getCanonicalPath();
                list = this.specmaticConfig.contractStubPathData();
            } else {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable iterable = this.contractPaths;
                stubCommand = stubCommand2;
                boolean $i$f$map2 = false;
                void bl = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    String string2 = (String)item$iv$iv2;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new ContractPathData("", (String)it, null, null, null, null, 60, null));
                }
                list = (List)destination$iv$iv;
                stubCommand2 = stubCommand;
            }
            stubCommand2.contractSources = list;
            Iterable iterable = this.contractSources;
            stubCommand = this;
            boolean $i$f$map = false;
            void $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object item$iv$iv2;
                item$iv$iv2 = (ContractPathData)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            stubCommand.contractPaths = (List)destination$iv$iv;
            StubCommandKt.validateContractFileExtensions(this.contractPaths, this.fileOperations);
            this.startServer();
            if (this.httpStub != null) {
                this.addShutdownHook();
                Watcher watcher = this.watchMaker.make(CollectionsKt.plus((Collection)this.contractPaths, (Iterable)this.dataDirs));
                watcher.watchForChanges((Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ StubCommand this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        StubCommand.access$restartServer(this.this$0);
                    }
                }));
            }
        }
        catch (Throwable e) {
            LoggingKt.consoleLog((Throwable)e);
        }
    }

    private final List<LogPrinter> configureLogPrinters() {
        List<LogPrinter> consoleLogPrinter = this.configureConsoleLogPrinter();
        List<LogPrinter> textLogPrinter = this.configureTextLogPrinter();
        List<LogPrinter> jsonLogPrinter = this.configureJSONLogPrinter();
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)consoleLogPrinter, (Iterable)textLogPrinter), (Iterable)jsonLogPrinter);
    }

    private final List<LogPrinter> configureConsoleLogPrinter() {
        if (this.noConsoleLog) {
            return CollectionsKt.emptyList();
        }
        if (this.jsonConsoleLog) {
            return CollectionsKt.listOf((Object)JSONConsoleLogPrinter.INSTANCE);
        }
        return CollectionsKt.listOf((Object)ConsolePrinter.INSTANCE);
    }

    private final List<LogPrinter> configureJSONLogPrinter() {
        Object object;
        block3: {
            block2: {
                object = this.jsonLog;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)new JSONFilePrinter((LogFile)new LogDirectory(it, this.logPrefix, "json", "log")));
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final List<LogPrinter> configureTextLogPrinter() {
        Object object;
        block3: {
            block2: {
                object = this.textLog;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)new TextFilePrinter((LogFile)new LogDirectory(it, this.logPrefix, "", "log")));
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final void startServer() {
        int n;
        WorkingDirectory workingDirectory = new WorkingDirectory(null, 1, null);
        List<Pair<Feature, List<ScenarioStub>>> stubData = this.stubLoaderEngine.loadStubs(this.contractSources, this.dataDirs);
        CertInfo certInfo = new CertInfo(this.keyStoreFile, this.keyStoreDir, this.keyStorePassword, this.keyStoreAlias, this.keyPassword);
        boolean bl = this.isDefaultPort(this.port);
        if (bl) {
            n = PortUtilKt.portIsInUse(this.getHost(), this.port) ? PortUtilKt.findRandomFreePort() : this.port;
        } else if (!bl) {
            n = this.port;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.port = n;
        this.httpStub = (ContractStub)this.httpStubEngine.runHTTPStub(stubData, this.getHost(), this.port, certInfo, this.strictMode, this.passThroughTargetBase, this.specmaticConfigPath, this.httpClientFactory, workingDirectory);
        LogTail.INSTANCE.storeSnapshot();
    }

    private final boolean isDefaultPort(int port) {
        return Intrinsics.areEqual((Object)"9000", (Object)String.valueOf(port));
    }

    private final void restartServer() {
        LoggingKt.consoleLog((LogMessage)((LogMessage)new StringLog("Stopping servers...")));
        try {
            this.stopServer();
            LoggingKt.consoleLog((LogMessage)((LogMessage)new StringLog("Stopped.")));
        }
        catch (Throwable e) {
            LoggingKt.consoleLog((Throwable)e, (String)"Error stopping server");
        }
        try {
            this.startServer();
        }
        catch (Throwable e) {
            LoggingKt.consoleLog((Throwable)e, (String)"Error starting server");
        }
    }

    private final void stopServer() {
        ContractStub contractStub = this.httpStub;
        if (contractStub != null) {
            contractStub.close();
        }
        this.httpStub = null;
    }

    private final void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            final /* synthetic */ StubCommand this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                try {
                    LoggingKt.consoleLog((LogMessage)((LogMessage)new StringLog("Shutting down stub servers")));
                    ContractStub contractStub = this.this$0.getHttpStub();
                    if (contractStub != null) {
                        contractStub.close();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    public static final /* synthetic */ void access$restartServer(StubCommand $this) {
        $this.restartServer();
    }
}

